/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.logging.Logger;
import org.geoserver.security.AuthenticationKeyFilterConfig;
import org.geoserver.security.AuthenticationKeyFilterConfigException;
import org.geoserver.security.AuthenticationKeyFilterConfigValidator;
import org.geoserver.security.GeoServerAuthenticationKeyFilter;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.test.GeoServerMockTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthenticationKeyFilterConfigValidatorTest
extends GeoServerMockTestSupport {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    AuthenticationKeyFilterConfigValidator validator;

    @Before
    public void setValidator() {
        this.validator = new AuthenticationKeyFilterConfigValidator(this.getSecurityManager());
    }

    @Test
    public void testCasFilterConfigValidation() throws Exception {
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName("testAuthKey");
        this.check(config);
    }

    public void check(AuthenticationKeyFilterConfig config) throws Exception {
        boolean failed = false;
        try {
            this.validator.validateFilterConfig(config);
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"USER_GROUP_SERVICE_NEEDED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setUserGroupServiceName("blabla");
        failed = false;
        try {
            this.validator.validateFilterConfig(config);
        }
        catch (FilterConfigException ex) {
            Assert.assertEquals((Object)"UNKNOWN_USER_GROUP_SERVICE", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"blabla", (Object)ex.getArgs()[0]);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setUserGroupServiceName(XMLUserGroupService.DEFAULT_NAME);
        config.setAuthKeyParamName(null);
        failed = false;
        try {
            this.validator.validateFilterConfig(config);
        }
        catch (AuthenticationKeyFilterConfigException ex) {
            Assert.assertEquals((Object)"AUTH_KEY_PARAM_NAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setAuthKeyParamName("authkey");
        failed = false;
        try {
            this.validator.validateFilterConfig(config);
        }
        catch (AuthenticationKeyFilterConfigException ex) {
            Assert.assertEquals((Object)"AUTH_KEY_MAPPER_NAME_REQUIRED", (Object)ex.getId());
            Assert.assertEquals((long)0L, (long)ex.getArgs().length);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        config.setAuthKeyMapperName("blabla");
        failed = false;
        try {
            this.validator.validateFilterConfig(config);
        }
        catch (AuthenticationKeyFilterConfigException ex) {
            Assert.assertEquals((Object)"AUTH_KEY_MAPPER_NOT_FOUND", (Object)ex.getId());
            Assert.assertEquals((long)1L, (long)ex.getArgs().length);
            Assert.assertEquals((Object)"blabla", (Object)ex.getArgs()[0]);
            LOGGER.info(ex.getMessage());
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }
}

