/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SerializationUtils;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.config.SecurityAuthFilterConfig;
import org.geoserver.security.config.SecurityConfig;
import org.geoserver.security.config.SecurityFilterConfig;

public class AuthenticationKeyFilterConfig
extends SecurityFilterConfig
implements SecurityAuthFilterConfig {
    private static final long serialVersionUID = 1L;
    private String authKeyMapperName;
    private String authKeyParamName = "authkey";
    private String userGroupServiceName;
    private Map<String, String> mapperParameters;
    private boolean allowMapperKeysAutoSync = false;
    private boolean allowChallengeAnonymousSessions = false;

    public boolean providesAuthenticationEntryPoint() {
        return true;
    }

    public String getAuthKeyMapperName() {
        return this.authKeyMapperName;
    }

    public void setAuthKeyMapperName(String authKeyMapperName) {
        this.authKeyMapperName = authKeyMapperName;
    }

    public String getAuthKeyParamName() {
        return this.authKeyParamName;
    }

    public void setAuthKeyParamName(String authKeyParamName) {
        this.authKeyParamName = authKeyParamName;
    }

    public String getUserGroupServiceName() {
        return this.userGroupServiceName;
    }

    public void setUserGroupServiceName(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    public Map<String, String> getMapperParameters() {
        if (this.mapperParameters == null) {
            this.mapperParameters = new HashMap<String, String>();
        }
        return this.mapperParameters;
    }

    public void setMapperParameters(Map<String, String> mapperParameters) {
        this.mapperParameters = mapperParameters;
    }

    public boolean isAllowMapperKeysAutoSync() {
        return this.allowMapperKeysAutoSync;
    }

    public void setAllowMapperKeysAutoSync(boolean allowMapperKeysAutoSync) {
        this.allowMapperKeysAutoSync = allowMapperKeysAutoSync;
    }

    public boolean isAllowChallengeAnonymousSessions() {
        return this.allowChallengeAnonymousSessions;
    }

    public void setAllowChallengeAnonymousSessions(boolean allowChallengeAnonymousSessions) {
        this.allowChallengeAnonymousSessions = allowChallengeAnonymousSessions;
    }

    public SecurityConfig clone(boolean allowEnvParametrization) {
        AuthenticationKeyFilterConfig target = (AuthenticationKeyFilterConfig)((Object)SerializationUtils.clone((Serializable)((Object)this)));
        if (target != null) {
            GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
            if (target.getMapperParameters() != null && !target.getMapperParameters().isEmpty() && allowEnvParametrization) {
                for (Map.Entry<String, String> param : target.getMapperParameters().entrySet()) {
                    String key = param.getKey();
                    Object value = param.getValue();
                    if (gsEnvironment != null && GeoServerEnvironment.allowEnvParametrization()) {
                        value = gsEnvironment.resolveValue(value);
                    }
                    target.getMapperParameters().put(key, (String)value);
                }
            }
        }
        return target;
    }
}

