/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import org.geoserver.security.AuthenticationKeyFilterConfig;
import org.geoserver.security.AuthenticationKeyFilterConfigException;
import org.geoserver.security.AuthenticationKeyMapper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.validation.FilterConfigException;
import org.geoserver.security.validation.FilterConfigValidator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class AuthenticationKeyFilterConfigValidator
extends FilterConfigValidator {
    public AuthenticationKeyFilterConfigValidator(GeoServerSecurityManager securityManager) {
        super(securityManager);
    }

    public void validateFilterConfig(SecurityNamedServiceConfig config) throws FilterConfigException {
        if (config instanceof AuthenticationKeyFilterConfig) {
            this.validateFilterConfig((AuthenticationKeyFilterConfig)config);
        } else {
            super.validateFilterConfig(config);
        }
    }

    public void validateFilterConfig(AuthenticationKeyFilterConfig config) throws FilterConfigException {
        this.checkExistingUGService(config.getUserGroupServiceName());
        if (!this.isNotEmpty(config.getAuthKeyParamName())) {
            throw this.createFilterException("AUTH_KEY_PARAM_NAME_REQUIRED", new Object[0]);
        }
        if (!this.isNotEmpty(config.getAuthKeyMapperName())) {
            throw this.createFilterException("AUTH_KEY_MAPPER_NAME_REQUIRED", new Object[0]);
        }
        try {
            this.lookupBean(config.getAuthKeyMapperName());
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw this.createFilterException("AUTH_KEY_MAPPER_NOT_FOUND", config.getAuthKeyMapperName());
        }
        AuthenticationKeyMapper mapper = (AuthenticationKeyMapper)this.lookupBean(config.getAuthKeyMapperName());
        for (String paramName : config.getMapperParameters().keySet()) {
            if (!mapper.getAvailableParameters().contains(paramName)) {
                throw this.createFilterException("INVALID_AUTH_KEY_MAPPER_PARAMETER", paramName);
            }
            mapper.validateParameter(paramName, config.getMapperParameters().get(paramName));
        }
        mapper.configureMapper(config.getMapperParameters());
        GeoServerUserGroupService service = null;
        try {
            service = this.manager.loadUserGroupService(config.getUserGroupServiceName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!mapper.supportsReadOnlyUserGroupService() && !service.canCreateStore()) {
            throw this.createFilterException("INVALID_AUTH_KEY_MAPPER", config.getAuthKeyMapperName(), config.getUserGroupServiceName());
        }
    }

    protected AuthenticationKeyFilterConfigException createFilterException(String errorid, Object ... args) {
        return new AuthenticationKeyFilterConfigException(errorid, args);
    }
}

