/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minidev.json.JSONArray;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerRestRoleServiceConfig;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class GeoServerRestRoleService
extends AbstractGeoServerSecurityService
implements GeoServerRoleService {
    static final SortedSet<String> emptyStringSet = Collections.unmodifiableSortedSet(new TreeSet());
    static final Map<String, String> emptyMap = Collections.emptyMap();
    static Cache<String, String> cachedResponses;
    static final int CONN_TIMEOUT = 30000;
    static final int READ_TIMEOUT = 30000;
    private RestTemplate restTemplate;
    private static String rolePrefix;
    GeoServerRestRoleServiceConfig restRoleServiceConfig;
    private boolean convertToUpperCase = true;
    private String adminGroup;
    private String groupAdminGroup;
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());

    static boolean isEmpty(String property) {
        return property == null || property.isEmpty();
    }

    public GeoServerRestRoleService(SecurityNamedServiceConfig config) throws IOException {
        this.initializeFromConfig(config);
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.restRoleServiceConfig = (GeoServerRestRoleServiceConfig)config;
        if (!GeoServerRestRoleService.isEmpty(this.restRoleServiceConfig.getAdminRoleName())) {
            this.adminGroup = this.restRoleServiceConfig.getAdminRoleName();
        }
        if (!GeoServerRestRoleService.isEmpty(this.restRoleServiceConfig.getGroupAdminRoleName())) {
            this.groupAdminGroup = this.restRoleServiceConfig.getGroupAdminRoleName();
        }
        cachedResponses = CacheBuilder.newBuilder().concurrencyLevel(this.restRoleServiceConfig.getCacheConcurrencyLevel()).maximumSize(this.restRoleServiceConfig.getCacheMaximumSize()).expireAfterWrite(this.restRoleServiceConfig.getCacheExpirationTime(), TimeUnit.MILLISECONDS).build();
    }

    private String resolveEnvironmentValue(String value) {
        GeoServerEnvironment gsEnvironment = (GeoServerEnvironment)GeoServerExtensions.bean(GeoServerEnvironment.class);
        if (gsEnvironment != null && GeoServerEnvironment.allowEnvParametrization()) {
            return (String)gsEnvironment.resolveValue((Object)value);
        }
        return value;
    }

    public boolean canCreateStore() {
        return false;
    }

    public GeoServerRoleStore createStore() throws IOException {
        return null;
    }

    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return emptyStringSet;
    }

    public SortedSet<String> getUserNamesForRole(GeoServerRole role) throws IOException {
        TreeSet users = new TreeSet();
        return Collections.unmodifiableSortedSet(users);
    }

    public SortedSet<GeoServerRole> getRolesForUser(final String username) throws IOException {
        final TreeSet roles = new TreeSet();
        try {
            RestEndpointConnectionCallback callback = new RestEndpointConnectionCallback(){

                @Override
                public Object executeWithContext(String json) throws Exception {
                    try {
                        List rolesString = (List)JsonPath.read((String)json, (String)GeoServerRestRoleService.this.restRoleServiceConfig.getUsersJSONPath().replace("${username}", username), (Predicate[])new Predicate[0]);
                        for (Object roleObj : rolesString) {
                            if (roleObj instanceof String) {
                                this.populateRoles((String)roleObj, roles);
                                continue;
                            }
                            if (!(roleObj instanceof JSONArray)) continue;
                            for (Object role : (JSONArray)roleObj) {
                                this.populateRoles((String)role, roles);
                            }
                        }
                    }
                    catch (PathNotFoundException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINEST, null, ex);
                        roles.clear();
                        roles.add(GeoServerRole.AUTHENTICATED_ROLE);
                    }
                    SortedSet<GeoServerRole> finalRoles = Collections.unmodifiableSortedSet(GeoServerRestRoleService.this.fixGeoServerRoles(roles));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Setting ROLES for User [" + username + "] to " + finalRoles);
                    }
                    return finalRoles;
                }

                private void populateRoles(String role, SortedSet<GeoServerRole> roles2) throws IOException {
                    if (role.startsWith(rolePrefix)) {
                        role = role.substring(rolePrefix.length());
                    }
                    roles2.add(GeoServerRestRoleService.this.createRoleObject(role));
                }
            };
            return (SortedSet)this.connectToRESTEndpoint(this.resolveEnvironmentValue(this.restRoleServiceConfig.getBaseUrl()), this.restRoleServiceConfig.getUsersRESTEndpoint() + "/" + username, this.restRoleServiceConfig.getUsersJSONPath().replace("${username}", username), this.resolveEnvironmentValue(this.restRoleServiceConfig.getAuthApiKey()), callback);
        }
        catch (Exception ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINEST, null, ex);
            return Collections.unmodifiableSortedSet(roles);
        }
    }

    protected SortedSet<GeoServerRole> fixGeoServerRoles(SortedSet<GeoServerRole> roles) {
        GeoServerRole adminRole = this.getAdminRole();
        if (roles.contains(GeoServerRole.ADMIN_ROLE) || roles.contains(adminRole)) {
            roles.clear();
            roles.add(GeoServerRole.ADMIN_ROLE);
        }
        if (roles.size() > 1 && roles.contains(GeoServerRole.ANONYMOUS_ROLE)) {
            roles.remove(GeoServerRole.ANONYMOUS_ROLE);
        }
        return roles;
    }

    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        TreeSet<GeoServerRole> set = new TreeSet<GeoServerRole>();
        GeoServerRole role = this.getRoleByName(groupname);
        if (role != null) {
            set.add(role);
        }
        return Collections.unmodifiableSortedSet(set);
    }

    public SortedSet<GeoServerRole> getRoles() throws IOException {
        final TreeSet roles = new TreeSet();
        try {
            RestEndpointConnectionCallback callback = new RestEndpointConnectionCallback(){

                @Override
                public Object executeWithContext(String json) throws Exception {
                    try {
                        List rolesString = (List)JsonPath.read((String)json, (String)GeoServerRestRoleService.this.restRoleServiceConfig.getRolesJSONPath(), (Predicate[])new Predicate[0]);
                        for (String role : rolesString) {
                            if (role.startsWith(rolePrefix)) {
                                role = role.substring(rolePrefix.length());
                            }
                            roles.add(GeoServerRestRoleService.this.createRoleObject(role));
                        }
                    }
                    catch (PathNotFoundException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINEST, null, ex);
                    }
                    return Collections.unmodifiableSortedSet(roles);
                }
            };
            return (SortedSet)this.connectToRESTEndpoint(this.resolveEnvironmentValue(this.restRoleServiceConfig.getBaseUrl()), this.restRoleServiceConfig.getRolesRESTEndpoint(), this.restRoleServiceConfig.getRolesJSONPath(), this.resolveEnvironmentValue(this.restRoleServiceConfig.getAuthApiKey()), callback);
        }
        catch (Exception ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINEST, null, ex);
            return Collections.unmodifiableSortedSet(roles);
        }
    }

    public Map<String, String> getParentMappings() throws IOException {
        return emptyMap;
    }

    public GeoServerRole createRoleObject(String role) throws IOException {
        return new GeoServerRole(rolePrefix + (this.convertToUpperCase ? role.toUpperCase() : role));
    }

    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return null;
    }

    public GeoServerRole getRoleByName(String role) throws IOException {
        if (role.startsWith(rolePrefix)) {
            role = role.substring(rolePrefix.length());
        }
        final String roleName = role;
        try {
            RestEndpointConnectionCallback callback = new RestEndpointConnectionCallback(){

                @Override
                public Object executeWithContext(String json) throws Exception {
                    try {
                        List rolesString = (List)JsonPath.read((String)json, (String)GeoServerRestRoleService.this.restRoleServiceConfig.getRolesJSONPath(), (Predicate[])new Predicate[0]);
                        for (String targetRole : rolesString) {
                            if (targetRole.startsWith(rolePrefix)) {
                                targetRole = targetRole.substring(rolePrefix.length());
                            }
                            if (!roleName.equalsIgnoreCase(targetRole)) continue;
                            return GeoServerRestRoleService.this.createRoleObject(roleName);
                        }
                    }
                    catch (PathNotFoundException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.FINEST, null, ex);
                    }
                    return null;
                }
            };
            return (GeoServerRole)this.connectToRESTEndpoint(this.resolveEnvironmentValue(this.restRoleServiceConfig.getBaseUrl()), this.restRoleServiceConfig.getRolesRESTEndpoint(), this.restRoleServiceConfig.getRolesJSONPath(), this.resolveEnvironmentValue(this.restRoleServiceConfig.getAuthApiKey()), callback);
        }
        catch (Exception ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINEST, null, ex);
            return null;
        }
    }

    public void load() throws IOException {
    }

    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return null;
    }

    public GeoServerRole getAdminRole() {
        if (this.adminGroup == null) {
            try {
                RestEndpointConnectionCallback callback = new RestEndpointConnectionCallback(){

                    @Override
                    public Object executeWithContext(String json) throws Exception {
                        try {
                            String targetRole = (String)JsonPath.read((String)json, (String)GeoServerRestRoleService.this.restRoleServiceConfig.getAdminRoleJSONPath(), (Predicate[])new Predicate[0]);
                            if (targetRole.startsWith(rolePrefix)) {
                                targetRole = targetRole.substring(rolePrefix.length());
                            }
                            return GeoServerRestRoleService.this.createRoleObject(targetRole);
                        }
                        catch (PathNotFoundException ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINEST, null, ex);
                            return null;
                        }
                    }
                };
                return (GeoServerRole)this.connectToRESTEndpoint(this.resolveEnvironmentValue(this.restRoleServiceConfig.getBaseUrl()), this.restRoleServiceConfig.getAdminRoleRESTEndpoint(), this.restRoleServiceConfig.getAdminRoleJSONPath(), this.resolveEnvironmentValue(this.restRoleServiceConfig.getAuthApiKey()), callback);
            }
            catch (Exception ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINEST, null, ex);
            }
        }
        try {
            return this.getRoleByName(this.adminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeoServerRole getGroupAdminRole() {
        if (this.groupAdminGroup == null) {
            return this.getAdminRole();
        }
        try {
            return this.getRoleByName(this.groupAdminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRoleCount() throws IOException {
        return this.getRoles().size();
    }

    public RestTemplate getRestTemplate() {
        if (this.restTemplate == null) {
            this.restTemplate = this.restTemplate();
        }
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private RestTemplate restTemplate() {
        return new RestTemplate(this.clientHttpRequestFactory());
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setReadTimeout(30000);
        factory.setConnectTimeout(30000);
        return factory;
    }

    protected Object connectToRESTEndpoint(final String roleRESTBaseURL, final String roleRESTEndpoint, String roleJSONPath, final String authApiKey, RestEndpointConnectionCallback callback) throws Exception {
        final String restEndPoint = roleRESTBaseURL + roleRESTEndpoint + roleJSONPath;
        String hash = GeoServerRestRoleService.getHash(restEndPoint);
        try {
            Callable<String> authorization = new Callable<String>(){

                /*
                 * Unable to fully structure code
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public String call() throws Exception {
                    block18: {
                        GeoServerRestRoleService.access$200().fine("GeoServer REST Role Service CACHE MISS for '" + restEndPoint + "'");
                        try {
                            baseURI = new URI(roleRESTBaseURL);
                            url = baseURI.resolve(roleRESTEndpoint).toURL();
                            req = GeoServerRestRoleService.this.getRestTemplate().getRequestFactory().createRequest(url.toURI(), HttpMethod.GET);
                            if (authApiKey != null) {
                                req.getHeaders().add("Authorization", "ApiKey " + authApiKey);
                            }
                            res = req.execute();
                            try {
                                status = res.getRawStatusCode();
                                switch (status) {
                                    case 200: 
                                    case 201: {
                                        br = new BufferedReader(new InputStreamReader(res.getBody()));
                                        try {
                                            sb = new StringBuilder();
                                            while ((line = br.readLine()) != null) {
                                                sb.append(line + "\n");
                                            }
                                            var9_14 = sb.toString();
                                        }
                                        catch (Throwable var7_11) {
                                            try {
                                                br.close();
                                            }
                                            catch (Throwable var8_13) {
                                                var7_11.addSuppressed(var8_13);
                                            }
                                            throw var7_11;
                                        }
                                        br.close();
                                        return var9_14;
                                    }
                                    ** default:
lbl32:
                                    // 1 sources

                                    break block18;
                                }
                                {
                                    catch (Throwable var5_7) {
                                        throw var5_7;
                                    }
                                }
                            }
                            finally {
                                if (res != null) {
                                    res.close();
                                }
                            }
                        }
                        catch (IOException | URISyntaxException ex) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINEST, null, ex);
                        }
                    }
                    return null;
                }
            };
            String cachedResponse = (String)cachedResponses.get((Object)hash, (Callable)authorization);
            return callback.executeWithContext(cachedResponse);
        }
        catch (ExecutionException e) {
            LOGGER.log(Level.FINEST, e.getMessage(), e);
            return null;
        }
    }

    private static String getHash(String stringToEncrypt) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(stringToEncrypt.getBytes());
        String encryptedString = new String(messageDigest.digest());
        return encryptedString;
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }

    static {
        rolePrefix = "ROLE_";
    }

    static interface RestEndpointConnectionCallback {
        public Object executeWithContext(String var1) throws Exception;
    }
}

