/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class KeyAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -6354705060521817602L;
    public static final String DEFAULT_URL_PARAM = "authkey";
    private String key;
    private String authKeyParamName;

    public KeyAuthenticationToken(String key, String authKeyParamName, UserDetails user) {
        this(key, authKeyParamName, user, user.getAuthorities());
    }

    public KeyAuthenticationToken(String key, String authKeyParamName, UserDetails user, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.key = key;
        this.setDetails(user);
        this.authKeyParamName = authKeyParamName;
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.key;
    }

    public Object getPrincipal() {
        return ((UserDetails)this.getDetails()).getUsername();
    }

    public String getAuthKeyParamName() {
        return this.authKeyParamName;
    }
}

