/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import com.google.common.util.concurrent.ExecutionError;
import java.io.IOException;
import java.util.SortedSet;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.security.GeoServerRestRoleService;
import org.geoserver.security.GeoServerRestRoleServiceConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.test.web.client.MockRestServiceServer;
import org.springframework.test.web.client.ResponseCreator;
import org.springframework.test.web.client.match.MockRestRequestMatchers;
import org.springframework.test.web.client.response.MockRestResponseCreators;
import org.springframework.web.client.RestTemplate;

public class GeoServerRestRoleServiceTest
extends GeoServerSystemTestSupport {
    public static final String uri = "http://rest.geoserver.org";
    private RestTemplate template;
    private MockRestServiceServer mockServer;

    @Before
    public void setUp() throws Exception {
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "true");
        GeoServerEnvironment.reloadAllowEnvParametrization();
        System.setProperty("test_role_service_base_url", "http://example.com/rest");
        System.setProperty("test_role_service_auth_api_key", "letmein");
        this.template = new RestTemplate();
        this.mockServer = MockRestServiceServer.createServer((RestTemplate)this.template);
        this.mockServer.expect(MockRestRequestMatchers.requestTo((String)"http://rest.geoserver.org/api/roles")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess((String)"{\"groups\": [\"anonymous\", \"test\", \"admin\"]}", (MediaType)MediaType.APPLICATION_JSON));
        this.mockServer.expect(MockRestRequestMatchers.requestTo((String)"http://rest.geoserver.org/api/adminRole")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess((String)"{\"adminRole\": \"admin\"}", (MediaType)MediaType.APPLICATION_JSON));
        this.mockServer.expect(MockRestRequestMatchers.requestTo((String)"http://rest.geoserver.org/api/users/test")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess((String)"{\"users\": [{\"username\": \"test\", \"groups\": [\"test\"]}]}", (MediaType)MediaType.APPLICATION_JSON));
        this.mockServer.expect(MockRestRequestMatchers.requestTo((String)"http://rest.geoserver.org/api/users/test@geoserver.org")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess((String)"{\"users\": [{\"username\": \"test@geoserver.org\", \"groups\": [\"test\"]}]}", (MediaType)MediaType.APPLICATION_JSON));
        this.mockServer.expect(MockRestRequestMatchers.requestTo((String)"http://rest.geoserver.org/api/users/admin")).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess((String)"{\"users\": [{\"username\": \"admin\", \"groups\": [\"admin\"]}]}", (MediaType)MediaType.APPLICATION_JSON));
        this.mockServer.expect(MockRestRequestMatchers.requestTo((String)"http://example.com/api/adminRole")).andExpect(MockRestRequestMatchers.header((String)"Authorization", (String[])new String[]{"ApiKey letmein"})).andRespond((ResponseCreator)MockRestResponseCreators.withSuccess((String)"{\"adminRole\": \"admin\"}", (MediaType)MediaType.APPLICATION_JSON));
    }

    @After
    public void tearDown() {
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
        System.clearProperty("test_role_service_base_url");
        System.clearProperty("test_role_service_auth_api_key");
    }

    @Test
    public void testGeoServerRestRoleService() throws IOException {
        GeoServerRestRoleServiceConfig roleServiceconfig = new GeoServerRestRoleServiceConfig();
        roleServiceconfig.setBaseUrl(uri);
        GeoServerRestRoleService roleService = new GeoServerRestRoleService((SecurityNamedServiceConfig)roleServiceconfig);
        roleService.setRestTemplate(this.template);
        SortedSet roles = roleService.getRoles();
        GeoServerRole adminRole = roleService.getAdminRole();
        SortedSet testUserRoles = roleService.getRolesForUser("test");
        SortedSet testUserEmailRoles = roleService.getRolesForUser("test@geoserver.org");
        SortedSet adminUserRoles = roleService.getRolesForUser("admin");
        Assert.assertNotNull((Object)roles);
        Assert.assertNotNull((Object)adminRole);
        Assert.assertNotNull((Object)testUserRoles);
        Assert.assertNotNull((Object)testUserEmailRoles);
        Assert.assertNotNull((Object)adminUserRoles);
        Assert.assertEquals((long)3L, (long)roles.size());
        Assert.assertEquals((Object)"ROLE_ADMIN", (Object)adminRole.getAuthority());
        Assert.assertEquals((long)testUserEmailRoles.size(), (long)testUserRoles.size());
        Assert.assertFalse((boolean)testUserRoles.contains(GeoServerRole.ADMIN_ROLE));
        Assert.assertFalse((boolean)testUserRoles.contains(adminRole));
        Assert.assertTrue((boolean)adminUserRoles.contains(GeoServerRole.ADMIN_ROLE));
        roleServiceconfig.setBaseUrl("${test_role_service_base_url}");
        roleServiceconfig.setAuthApiKey("${test_role_service_auth_api_key}");
        GeoServerRole adminRole1 = roleService.getAdminRole();
        Assert.assertNotNull((Object)adminRole1);
        Assert.assertEquals((Object)"ROLE_ADMIN", (Object)adminRole1.getAuthority());
        this.mockServer.verify();
    }

    @Test
    public void testGeoServerRestRoleServiceInternalCache() throws IOException, InterruptedException {
        GeoServerRestRoleServiceConfig roleServiceconfig = new GeoServerRestRoleServiceConfig();
        int EXPIRATION = 500;
        roleServiceconfig.setCacheExpirationTime((long)EXPIRATION);
        roleServiceconfig.setBaseUrl(uri);
        GeoServerRestRoleService roleService = new GeoServerRestRoleService((SecurityNamedServiceConfig)roleServiceconfig);
        roleService.setRestTemplate(this.template);
        roleService.getRoles();
        roleService.getAdminRole();
        roleService.getRolesForUser("test");
        Thread.sleep((long)((double)EXPIRATION * 1.5));
        Assert.assertThrows(ExecutionError.class, () -> roleService.getRolesForUser("test@geoserver.org"));
    }
}

