/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.geoserver.security.AbstractAuthenticationKeyMapper;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.PasswordPolicyException;
import org.springframework.util.StringUtils;

public class UserPropertyAuthenticationKeyMapper
extends AbstractAuthenticationKeyMapper {
    private String userPropertyName;

    public String getUserPropertyName() {
        return this.userPropertyName;
    }

    public void setUserPropertyName(String userPropertyName) {
        this.userPropertyName = userPropertyName;
    }

    @Override
    protected void checkPropertiesInternal() throws IOException {
        if (!StringUtils.hasLength((String)this.getUserPropertyName())) {
            throw new IOException("User property name is unset");
        }
    }

    @Override
    public boolean supportsReadOnlyUserGroupService() {
        return false;
    }

    @Override
    public Set<String> getAvailableParameters() {
        return new HashSet<String>(List.of("cacheTtlSeconds"));
    }

    @Override
    public GeoServerUser getUserInternal(String key) throws IOException {
        SortedSet set = this.getUserGroupService().getUsersHavingPropertyValue(this.getUserPropertyName(), key);
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() > 1) {
            StringBuilder buff = new StringBuilder();
            for (GeoServerUser user : set) {
                buff.append(user.getUsername()).append(",");
            }
            buff.setLength(buff.length() - 1);
            throw new IOException("More than one user have auth key: " + key + ". Problematic users :" + buff.toString());
        }
        GeoServerUser user = (GeoServerUser)set.first();
        if (!user.isEnabled()) {
            LOGGER.info("Found user " + user.getUsername() + " for key " + key + ", but this user is disabled");
            return null;
        }
        return (GeoServerUser)this.getUserGroupService().loadUserByUsername(user.getUsername());
    }

    @Override
    public synchronized int synchronize() throws IOException {
        this.checkProperties();
        GeoServerUserGroupService service = this.getUserGroupService();
        if (!service.canCreateStore()) {
            throw new IOException("Cannot synchronize a read only user group service");
        }
        this.resetUserCache();
        int counter = 0;
        GeoServerUserGroupStore store = service.createStore();
        store.load();
        for (GeoServerUser user : store.getUsers()) {
            String value = user.getProperties().getProperty(this.getUserPropertyName());
            if (StringUtils.hasLength((String)value)) continue;
            user.getProperties().put(this.getUserPropertyName(), this.createAuthKey());
            try {
                store.updateUser(user);
                ++counter;
            }
            catch (PasswordPolicyException e) {
                throw new IOException("Never should reach this point", e);
            }
        }
        store.store();
        return counter;
    }
}

