/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.geoserver.security.AbstractAuthenticationKeyMapper;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.FilterConfigException;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPResponse;
import org.springframework.util.StringUtils;

public class WebServiceAuthenticationKeyMapper
extends AbstractAuthenticationKeyMapper {
    public static final ThreadLocal<String> RECORDED_RESPONSE = new ThreadLocal();
    public static final String AUTH_KEY_WEBSERVICE_PLACEHOLDER_REQUIRED = "AUTH_KEY_WEBSERVICE_PLACEHOLDER_REQUIRED";
    public static final String AUTH_KEY_WEBSERVICE_MALFORMED_REGEX = "AUTH_KEY_WEBSERVICE_MALFORMED_REGEX";
    public static final String AUTH_KEY_WEBSERVICE_WRONG_TIMEOUT = "AUTH_KEY_WEBSERVICE_WRONG_TIMEOUT";
    private String webServiceUrl;
    private String searchUser;
    Pattern searchUserRegex = null;
    int connectTimeout = 5;
    int readTimeout = 10;
    private HTTPClient httpClient = null;

    private HTTPClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HTTPClientFinder.createClient();
        }
        return this.httpClient;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getWebServiceUrl() {
        return this.webServiceUrl;
    }

    public void setWebServiceUrl(String webServiceUrl) {
        this.webServiceUrl = webServiceUrl;
    }

    public String getSearchUser() {
        return this.searchUser;
    }

    public void setSearchUser(String searchUser) {
        this.searchUser = searchUser;
        this.searchUserRegex = Pattern.compile(searchUser);
    }

    public void setHttpClient(HTTPClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    protected void checkPropertiesInternal() throws IOException {
        if (!StringUtils.hasLength((String)this.webServiceUrl)) {
            throw new IOException("Web service url is unset");
        }
        if (StringUtils.hasLength((String)this.searchUser)) {
            try {
                Pattern.compile(this.searchUser);
            }
            catch (PatternSyntaxException e) {
                throw new IOException("Search User regex is malformed");
            }
        }
    }

    @Override
    public boolean supportsReadOnlyUserGroupService() {
        return true;
    }

    @Override
    protected GeoServerUser getUserInternal(String key) throws IOException {
        String responseBody = this.callWebService(key);
        if (responseBody == null) {
            LOGGER.log(Level.WARNING, "Could not find any user associated to webservice url [" + this.webServiceUrl + "] with authkey: " + key);
            RECORDED_RESPONSE.remove();
            return null;
        }
        RECORDED_RESPONSE.set(responseBody);
        if (this.getUserGroupService() != null) {
            String username = null;
            if (this.searchUserRegex == null) {
                username = responseBody;
            } else {
                Matcher matcher = this.searchUserRegex.matcher(responseBody);
                if (matcher.find()) {
                    username = matcher.group(1);
                } else {
                    LOGGER.log(Level.WARNING, "Error in WebServiceAuthenticationKeyMapper, cannot find userName in response");
                }
            }
            if (username != null) {
                return (GeoServerUser)this.getUserGroupService().loadUserByUsername(username);
            }
        }
        LOGGER.log(Level.WARNING, "No User Group Service configured for webservice url [" + this.webServiceUrl + "] with authkey: " + key);
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String callWebService(String key) {
        String url = this.webServiceUrl.replace("{key}", key);
        HTTPClient client = this.getHttpClient();
        client.setConnectTimeout(this.connectTimeout);
        client.setReadTimeout(this.readTimeout);
        try {
            LOGGER.log(Level.FINE, "Issuing request to authkey webservice: " + url);
            HTTPResponse response = client.get(new URL(url));
            try (InputStream responseStream = response.getResponseStream();){
                String string;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseStream));){
                    StringBuilder result = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }
                    LOGGER.log(Level.FINE, "Response received from authkey webservice: " + result.toString());
                    string = result.toString();
                }
                return string;
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Error in WebServiceAuthenticationKeyMapper, web service url is invalid: " + url, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error in WebServiceAuthenticationKeyMapper, error in web service communication", e);
        }
        return null;
    }

    @Override
    public void configureMapper(Map<String, String> mapperParams) {
        super.configureMapper(mapperParams);
        if (mapperParams != null) {
            if (mapperParams.containsKey("webServiceUrl")) {
                this.setWebServiceUrl(mapperParams.get("webServiceUrl"));
            }
            if (mapperParams.containsKey("searchUser")) {
                this.setSearchUser(mapperParams.get("searchUser"));
            }
            if (mapperParams.containsKey("connectTimeout")) {
                try {
                    this.connectTimeout = Integer.parseInt(mapperParams.get("connectTimeout"));
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.SEVERE, "WebServiceAuthenticationKeyMapper connectTimeout wrong format", e);
                }
            }
            if (mapperParams.containsKey("readTimeout")) {
                try {
                    this.readTimeout = Integer.parseInt(mapperParams.get("readTimeout"));
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.SEVERE, "WebServiceAuthenticationKeyMapper readTimeout wrong format", e);
                }
            }
        }
    }

    @Override
    public Set<String> getAvailableParameters() {
        return new HashSet<String>(Arrays.asList("webServiceUrl", "searchUser", "connectTimeout", "readTimeout", "cacheTtlSeconds"));
    }

    @Override
    protected String getDefaultParamValue(String paramName) {
        if (paramName.equalsIgnoreCase("searchUser")) {
            return "^\\s*(.*)\\s*$";
        }
        if (paramName.equalsIgnoreCase("connectTimeout")) {
            return "5";
        }
        if (paramName.equalsIgnoreCase("readTimeout")) {
            return "10";
        }
        if (paramName.equalsIgnoreCase("webServiceUrl")) {
            return "http://host:port/service?authkey={key}";
        }
        return super.getDefaultParamValue(paramName);
    }

    @Override
    public void validateParameter(String paramName, String value) throws FilterConfigException {
        if (value == null) {
            value = "";
        }
        if (paramName.equalsIgnoreCase("searchUser") && !value.isEmpty()) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                throw this.createFilterException(AUTH_KEY_WEBSERVICE_MALFORMED_REGEX, value);
            }
        }
        if (paramName.equalsIgnoreCase("connectTimeout")) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw this.createFilterException(AUTH_KEY_WEBSERVICE_WRONG_TIMEOUT, value);
            }
        }
        if (paramName.equalsIgnoreCase("readTimeout")) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw this.createFilterException(AUTH_KEY_WEBSERVICE_WRONG_TIMEOUT, value);
            }
        }
        if (paramName.equalsIgnoreCase("webServiceUrl") && !value.contains("{key}")) {
            throw this.createFilterException(AUTH_KEY_WEBSERVICE_PLACEHOLDER_REQUIRED, value);
        }
    }

    @Override
    public synchronized int synchronize() throws IOException {
        this.getSecurityManager().getAuthenticationCache().removeAll(this.getAuthenticationFilterName());
        this.resetUserCache();
        return 0;
    }
}

