/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.WebServiceAuthenticationKeyMapper;
import org.geoserver.security.WebServiceBodyResponseUserGroupServiceConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.RoleCalculator;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class WebServiceBodyResponseUserGroupService
extends AbstractGeoServerSecurityService
implements GeoServerUserGroupService {
    static final SortedSet<GeoServerUser> emptyUserSet = Collections.unmodifiableSortedSet(new TreeSet());
    private boolean convertToUpperCase = true;
    private static final String rolePrefix = "ROLE_";
    private static final String groupPrefix = "GROUP_";
    protected Set<UserGroupLoadedListener> listeners = Collections.synchronizedSet(new HashSet());
    protected String passwordEncoderName;
    protected String passwordValidatorName;
    Pattern searchRolesRegex = null;
    protected SortedSet<GeoServerUserGroup> availableGroups = Collections.synchronizedSortedSet(new TreeSet());
    private String roleServiceName;
    private GeoServerRoleService defaultSecurityService;

    public WebServiceBodyResponseUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        this.initializeFromConfig(config);
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        WebServiceBodyResponseUserGroupServiceConfig webServiceBodyConfig = (WebServiceBodyResponseUserGroupServiceConfig)config;
        this.passwordEncoderName = webServiceBodyConfig.getPasswordEncoderName();
        this.passwordValidatorName = webServiceBodyConfig.getPasswordPolicyName();
        if (StringUtils.hasLength((String)webServiceBodyConfig.getSearchRoles())) {
            try {
                this.searchRolesRegex = Pattern.compile(webServiceBodyConfig.getSearchRoles());
            }
            catch (PatternSyntaxException e) {
                throw new IOException("Search Roles regex is malformed");
            }
        }
        if (StringUtils.hasLength((String)webServiceBodyConfig.getAvailableGroups())) {
            for (String role : webServiceBodyConfig.getAvailableGroups().split(",")) {
                this.availableGroups.add(new GeoServerUserGroup(this.convertToUpperCase ? role.trim().toUpperCase() : role.trim()));
            }
        }
        this.roleServiceName = StringUtils.hasLength((String)webServiceBodyConfig.getRoleServiceName()) ? webServiceBodyConfig.getRoleServiceName() : null;
        this.defaultSecurityService = null;
    }

    public boolean canCreateStore() {
        return false;
    }

    public GeoServerUserGroupStore createStore() throws IOException {
        return null;
    }

    public void load() throws IOException {
    }

    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
        this.listeners.remove(listener);
    }

    public GeoServerUser loadUserByUsername(String username, String responseBody) {
        GeoServerUser user = null;
        try {
            if (username == null) {
                throw new UsernameNotFoundException(this.userNotFoundMessage(username));
            }
            user = new GeoServerUser(username);
            user.setAuthorities(this.extractRoles(responseBody));
        }
        catch (IOException e) {
            throw new UsernameNotFoundException(this.userNotFoundMessage(username), (Throwable)e);
        }
        return user;
    }

    private Set<? extends GrantedAuthority> extractRoles(String responseBody) throws IOException {
        RoleCalculator calc;
        HashSet<Object> authorities = new HashSet<Object>();
        Matcher matcher = this.searchRolesRegex.matcher(responseBody);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                for (String roleName : matcher.group(i).split(",")) {
                    authorities.add(this.createAuthorityObject(roleName.trim()));
                }
            }
        }
        if (authorities.isEmpty()) {
            LOGGER.log(Level.WARNING, "Error in WebServiceAuthenticationKeyMapper, cannot find any Role in response adding anonymous role");
            authorities.add(GeoServerRole.ANONYMOUS_ROLE);
        }
        if ((calc = new RoleCalculator((GeoServerUserGroupService)this, this.getDefaultSecurityService())) != null) {
            TreeSet<GeoServerUserGroup> groups = new TreeSet<GeoServerUserGroup>();
            for (GrantedAuthority grantedAuthority : authorities) {
                groups.add(this.createGroupObject(grantedAuthority.getAuthority(), true));
            }
            for (GeoServerUserGroup geoServerUserGroup : groups) {
                if (!geoServerUserGroup.isEnabled()) continue;
                for (GeoServerRole role : calc.calculateRoles(geoServerUserGroup)) {
                    if (authorities.contains(role)) continue;
                    authorities.add(role);
                }
            }
        }
        if (!authorities.isEmpty()) {
            for (GrantedAuthority grantedAuthority : authorities) {
                if (grantedAuthority.equals(GeoServerRole.ADMIN_ROLE) || grantedAuthority.equals(GeoServerRole.GROUP_ADMIN_ROLE) || grantedAuthority.getAuthority().equals(DEFAULT_LOCAL_ADMIN_ROLE) || grantedAuthority.getAuthority().equals(DEFAULT_LOCAL_GROUP_ADMIN_ROLE)) {
                    authorities.clear();
                    authorities.add(GeoServerRole.ADMIN_ROLE);
                    break;
                }
                if (authorities.size() <= 1 || !grantedAuthority.equals(GeoServerRole.ANONYMOUS_ROLE)) continue;
                authorities.remove(grantedAuthority);
                break;
            }
        }
        return Collections.unmodifiableSet(authorities);
    }

    protected String userNotFoundMessage(String username) {
        return "User  " + username + " not found in usergroupservice: " + this.getName();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        String response = WebServiceAuthenticationKeyMapper.RECORDED_RESPONSE.get();
        return this.loadUserByUsername(username, response);
    }

    public GeoServerUserGroup getGroupByGroupname(String groupname) throws IOException {
        for (GeoServerUserGroup group : this.availableGroups) {
            if (!group.getGroupname().equalsIgnoreCase(groupname)) continue;
            return group;
        }
        return new GeoServerUserGroup(this.convertToUpperCase ? groupname.trim().toUpperCase() : groupname.trim());
    }

    public GeoServerUser getUserByUsername(String username) throws IOException {
        return null;
    }

    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        return null;
    }

    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        Object theGroupName;
        Object object = theGroupName = this.convertToUpperCase ? groupname.trim().toUpperCase() : groupname.trim();
        if (!((String)theGroupName).contains(groupPrefix)) {
            if (((String)theGroupName).equals(GeoServerRole.ADMIN_ROLE.getAuthority())) {
                theGroupName = GeoServerRole.GROUP_ADMIN_ROLE.getAuthority().substring(rolePrefix.length());
            } else {
                theGroupName = ((String)theGroupName).substring(rolePrefix.length());
                theGroupName = groupPrefix + (String)theGroupName;
            }
        }
        GeoServerUserGroup group = new GeoServerUserGroup((String)theGroupName);
        group.setEnabled(isEnabled);
        return group;
    }

    protected GrantedAuthority createAuthorityObject(String role) throws IOException {
        return new GeoServerRole(rolePrefix + (this.convertToUpperCase ? role.toUpperCase() : role));
    }

    public SortedSet<GeoServerUser> getUsers() throws IOException {
        return emptyUserSet;
    }

    public SortedSet<GeoServerUserGroup> getUserGroups() throws IOException {
        return this.availableGroups;
    }

    public SortedSet<GeoServerUser> getUsersForGroup(GeoServerUserGroup group) throws IOException {
        return emptyUserSet;
    }

    public SortedSet<GeoServerUserGroup> getGroupsForUser(GeoServerUser user) throws IOException {
        TreeSet<GeoServerUserGroup> groups = new TreeSet<GeoServerUserGroup>();
        if (user.getAuthorities() != null) {
            for (GrantedAuthority authority : user.getAuthorities()) {
                groups.add(this.createGroupObject(authority.getAuthority(), true));
            }
        }
        return Collections.unmodifiableSortedSet(groups);
    }

    public String getPasswordEncoderName() {
        return this.passwordEncoderName;
    }

    public String getPasswordValidatorName() {
        return this.passwordValidatorName;
    }

    public String getRoleServiceName() {
        return this.roleServiceName;
    }

    public void setRoleServiceName(String roleServiceName) {
        this.roleServiceName = roleServiceName;
    }

    public GeoServerRoleService getDefaultSecurityService() {
        if (this.defaultSecurityService == null) {
            if (StringUtils.hasLength((String)this.roleServiceName)) {
                try {
                    for (String roleService : this.securityManager.listRoleServices()) {
                        if (!roleService.equals(this.roleServiceName)) continue;
                        this.defaultSecurityService = this.securityManager.loadRoleService(this.roleServiceName);
                        break;
                    }
                }
                catch (IOException e) {
                    this.defaultSecurityService = null;
                }
            }
            if (this.defaultSecurityService == null) {
                this.defaultSecurityService = this.securityManager.getActiveRoleService();
            }
        }
        return this.defaultSecurityService;
    }

    public void setDefaultSecurityService(GeoServerRoleService defaultSecurityService) {
        this.defaultSecurityService = defaultSecurityService;
    }

    public int getUserCount() throws IOException {
        return 0;
    }

    public int getGroupCount() throws IOException {
        return this.availableGroups.size();
    }

    public SortedSet<GeoServerUser> getUsersHavingProperty(String propname) throws IOException {
        return emptyUserSet;
    }

    public int getUserCountHavingProperty(String propname) throws IOException {
        return 0;
    }

    public SortedSet<GeoServerUser> getUsersNotHavingProperty(String propname) throws IOException {
        return emptyUserSet;
    }

    public int getUserCountNotHavingProperty(String propname) throws IOException {
        return 0;
    }

    public SortedSet<GeoServerUser> getUsersHavingPropertyValue(String propname, String propvalue) throws IOException {
        return emptyUserSet;
    }

    public int getUserCountHavingPropertyValue(String propname, String propvalue) throws IOException {
        return 0;
    }
}

