/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.AuthenticationKeyFilterConfig;
import org.geoserver.security.GeoServerAuthenticationKeyFilter;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.PropertyAuthenticationKeyMapper;
import org.geoserver.security.VariableFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.wms.WMSInfo;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class AuthenticationKeyOWSTest
extends GeoServerSystemTestSupport {
    private static String adminKey;
    private static String citeKey;

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        File security = new File(testData.getDataDirectoryRoot(), "security");
        Properties props = new Properties();
        File layers = new File(security, "layers.properties");
        props = new Properties();
        props.put("mode", "hidden");
        props.put("*.*.r", "NO_ONE");
        props.put("*.*.w", "NO_ONE");
        props.put("sf.*.r", "*");
        props.put("cite.*.r", "cite");
        props.put("cite.*.w", "cite");
        try (FileOutputStream outputFile = new FileOutputStream(layers);){
            props.store(outputFile, "");
        }
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("", "http://www.opengis.net/ogc");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        CiteTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.getSRS().add("EPSG:4326");
        gs.save((ServiceInfo)wms);
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService("default");
        GeoServerUserGroupStore store = service.createStore();
        store.load();
        store.addUser(store.createUserObject("cite", "cite", true));
        store.store();
        GeoServerRoleService rservice = this.getSecurityManager().loadRoleService("default");
        GeoServerRoleStore rstore = rservice.createStore();
        rstore.load();
        GeoServerRole no_one = rstore.createRoleObject("NO_ONE");
        rstore.addRole(no_one);
        GeoServerRole rcite = rstore.createRoleObject("cite");
        rstore.addRole(rcite);
        rstore.associateRoleToUser(rstore.createRoleObject("cite"), "cite");
        rstore.store();
        String authKeyUrlParam = "authkey";
        String filterName = "testAuthKeyFilter1";
        AuthenticationKeyFilterConfig config = new AuthenticationKeyFilterConfig();
        config.setClassName(GeoServerAuthenticationKeyFilter.class.getName());
        config.setName(filterName);
        config.setUserGroupServiceName("default");
        config.setAuthKeyParamName(authKeyUrlParam);
        config.setAuthKeyMapperName("propertyMapper");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        SecurityManagerConfig mconfig = this.getSecurityManager().getSecurityConfig();
        GeoServerSecurityFilterChain filterChain = mconfig.getFilterChain();
        VariableFilterChain chain = (VariableFilterChain)filterChain.getRequestChainByName("default");
        chain.getFilterNames().add(0, filterName);
        this.getSecurityManager().saveSecurityConfig(mconfig);
        GeoServerAuthenticationKeyFilter authKeyFilter = (GeoServerAuthenticationKeyFilter)this.getSecurityManager().loadFilter(filterName);
        PropertyAuthenticationKeyMapper mapper = (PropertyAuthenticationKeyMapper)authKeyFilter.getMapper();
        mapper.synchronize();
        for (Map.Entry<Object, Object> entry : mapper.authKeyProps.entrySet()) {
            if ("admin".equals(entry.getValue())) {
                adminKey = (String)entry.getKey();
            }
            if (!"cite".equals(entry.getValue())) continue;
            citeKey = (String)entry.getKey();
        }
        if (adminKey == null) {
            throw new RuntimeException("Missing admin key");
        }
        if (citeKey == null) {
            throw new RuntimeException("Missing cite key");
        }
    }

    protected List<Filter> getFilters() {
        SecurityManagerConfig mconfig = this.getSecurityManager().getSecurityConfig();
        GeoServerSecurityFilterChain filterChain = mconfig.getFilterChain();
        VariableFilterChain chain = (VariableFilterChain)filterChain.getRequestChainByName("default");
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (String filterName : chain.getCompiledFilterNames()) {
            try {
                result.add((Filter)this.getSecurityManager().loadFilter(filterName));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Test
    public void testAnonymousCapabilities() throws Exception {
        Document doc = this.getAsDOM("wms?request=GetCapabilities&version=1.1.0");
        XpathEngine engine = XMLUnit.newXpathEngine();
        Assert.assertTrue((engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'sf:')]", doc).getLength() > 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'cite:')]", doc).getLength());
        Assert.assertEquals((long)0L, (long)engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'cdf:')]", doc).getLength());
    }

    @Test
    public void testAdminCapabilities() throws Exception {
        Document doc = this.getAsDOM("wms?request=GetCapabilities&version=1.1.0&authkey=" + adminKey);
        XpathEngine engine = XMLUnit.newXpathEngine();
        Assert.assertTrue((engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'sf:')]", doc).getLength() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'cdf:')]", doc).getLength() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'cite:')]", doc).getLength() > 1 ? 1 : 0) != 0);
        String url = engine.evaluate("//GetMap/DCPType/HTTP/Get/OnlineResource/@xlink:href", doc);
        Assert.assertTrue((boolean)url.contains("&authkey=" + adminKey));
    }

    @Test
    public void testCiteCapabilities() throws Exception {
        Document doc = this.getAsDOM("wms?request=GetCapabilities&version=1.1.0&authkey=" + citeKey);
        XpathEngine engine = XMLUnit.newXpathEngine();
        Assert.assertTrue((engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'sf:')]", doc).getLength() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'cite:')]", doc).getLength() > 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)engine.getMatchingNodes("//Layer/Name[starts-with(text(), 'cdf:')]", doc).getLength());
        String url = engine.evaluate("//GetMap/DCPType/HTTP/Get/OnlineResource/@xlink:href", doc);
        Assert.assertTrue((boolean)url.contains("&authkey=" + citeKey));
    }

    @Test
    public void testAnonymousGetFeature() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=" + this.getLayerId(MockData.PONDS));
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)doc.getDocumentElement().getLocalName());
    }

    @Test
    public void testAdminGetFeature() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=" + this.getLayerId(MockData.PONDS) + "&authkey=" + adminKey);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        XpathEngine engine = XMLUnit.newXpathEngine();
        String url = engine.evaluate("//wfs:FeatureCollection/@xsi:schemaLocation", doc);
        Assert.assertTrue((boolean)url.contains("&authkey=" + adminKey));
    }

    @Test
    public void testCiteGetFeature() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=" + this.getLayerId(MockData.PONDS) + "&authkey=" + citeKey);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        XpathEngine engine = XMLUnit.newXpathEngine();
        String url = engine.evaluate("//wfs:FeatureCollection/@xsi:schemaLocation", doc);
        Assert.assertTrue((boolean)url.contains("&authkey=" + citeKey));
    }

    @Test
    public void testCiteGetFeatureCaseInsensitive() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=GetFeature&typeName=" + this.getLayerId(MockData.PONDS) + "&AUTHKEY=" + citeKey);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection)", (Document)doc);
        XpathEngine engine = XMLUnit.newXpathEngine();
        String url = engine.evaluate("//wfs:FeatureCollection/@xsi:schemaLocation", doc);
        Assert.assertTrue((boolean)url.contains("&authkey=" + citeKey));
    }

    @Test
    public void testOpenLayersMapOutput() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("cite/wms?service=WMS&version=1.1.0&request=GetMap&bbox=-2.0,2.0,-1.0,6.0&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&width=300&height=300&srs=EPSG:4326&format=application/openlayers&authkey=" + citeKey);
        byte[] responseContent = this.getBinary(response);
        String htmlDoc = new String(responseContent, StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)htmlDoc, (Matcher)Matchers.containsString((String)("<input type=\"hidden\" id=\"servicePath\" value=\"cite/wms?authkey=" + citeKey + "\"/>")));
    }
}

