/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.geoserver.security.AuthenticationKeyFilterConfigException;
import org.geoserver.security.AuthenticationKeyMapper;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.validation.FilterConfigException;
import org.geotools.util.logging.Logging;
import org.springframework.util.StringUtils;

public abstract class AbstractAuthenticationKeyMapper
implements AuthenticationKeyMapper {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    private String beanName;
    private String userGroupServiceName;
    private String authenticationFilterName;
    private GeoServerSecurityManager securityManager;
    private Map<String, String> parameters = new HashMap<String, String>();
    private final ConcurrentHashMap<String, CacheEntry> userCache = new ConcurrentHashMap();
    private long cacheTtlSeconds = 300L;
    private final ScheduledExecutorService cacheCleanupExecutor = Executors.newSingleThreadScheduledExecutor();

    public AbstractAuthenticationKeyMapper() {
        this.fillDefaultParameters();
        this.startCacheCleanupTask();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public String getUserGroupServiceName() {
        return this.userGroupServiceName;
    }

    @Override
    public void setUserGroupServiceName(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    @Override
    public GeoServerSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    protected GeoServerUserGroupService getUserGroupService() throws IOException {
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(this.getUserGroupServiceName());
        if (service == null) {
            throw new IOException("Unknown user/group service: " + this.getUserGroupServiceName());
        }
        return service;
    }

    protected void checkProperties() throws IOException {
        if (!StringUtils.hasLength((String)this.getUserGroupServiceName())) {
            throw new IOException("User/Group Service Name is unset");
        }
        if (this.getSecurityManager() == null) {
            throw new IOException("Security manager is unset");
        }
        this.checkPropertiesInternal();
    }

    protected abstract void checkPropertiesInternal() throws IOException;

    protected String createAuthKey() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Set<String> getAvailableParameters() {
        return new HashSet<String>();
    }

    @Override
    public void configureMapper(Map<String, String> parameters) {
        this.parameters = parameters;
        this.fillDefaultParameters();
        if (parameters.containsKey("cacheTtlSeconds")) {
            try {
                this.cacheTtlSeconds = Long.parseLong(parameters.get("cacheTtlSeconds"));
            }
            catch (NumberFormatException e) {
                LOGGER.warning("Invalid cacheTtlSeconds value. Using default.");
            }
        }
    }

    private void fillDefaultParameters() {
        for (String paramName : this.getAvailableParameters()) {
            if (this.parameters.containsKey(paramName)) continue;
            this.parameters.put(paramName, this.getDefaultParamValue(paramName));
        }
    }

    protected String getDefaultParamValue(String paramName) {
        return "";
    }

    @Override
    public Map<String, String> getMapperConfiguration() {
        return this.parameters;
    }

    @Override
    public void validateParameter(String paramName, String value) throws FilterConfigException {
    }

    protected AuthenticationKeyFilterConfigException createFilterException(String errorid, Object ... args) {
        return new AuthenticationKeyFilterConfigException(errorid, args);
    }

    public String getAuthenticationFilterName() {
        return this.authenticationFilterName;
    }

    @Override
    public void setAuthenticationFilterName(String authenticationFilterName) {
        this.authenticationFilterName = authenticationFilterName;
    }

    @Override
    public GeoServerUser getUser(String key) throws IOException {
        this.checkProperties();
        CacheEntry entry = this.userCache.get(key);
        if (entry != null && !entry.isExpired()) {
            return entry.getUser();
        }
        GeoServerUser user = this.getUserInternal(key);
        if (key != null && user != null) {
            this.userCache.put(key, new CacheEntry(user, System.currentTimeMillis() + this.cacheTtlSeconds * 1000L));
        }
        return user;
    }

    protected abstract GeoServerUser getUserInternal(String var1) throws IOException;

    public void resetUserCache() {
        this.userCache.clear();
    }

    @Override
    public void setCacheTtlSeconds(long ttlSeconds) {
        this.cacheTtlSeconds = ttlSeconds;
    }

    @Override
    public long getCacheTtlSeconds() {
        return this.cacheTtlSeconds;
    }

    private void startCacheCleanupTask() {
        this.cacheCleanupExecutor.scheduleAtFixedRate(() -> this.userCache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).isExpired()), this.cacheTtlSeconds, this.cacheTtlSeconds, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.cacheCleanupExecutor.shutdownNow();
    }

    private static class CacheEntry {
        private final GeoServerUser user;
        private final long expiryTime;

        CacheEntry(GeoServerUser user, long expiryTime) {
            this.user = user;
            this.expiryTime = expiryTime;
        }

        public GeoServerUser getUser() {
            return this.user;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiryTime;
        }
    }
}

