/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AuthenticationKeyFilterConfig;
import org.geoserver.security.AuthenticationKeyMapper;
import org.geoserver.security.KeyAuthenticationToken;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.AuthenticationCachingFilter;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.util.StringUtils;

public class GeoServerAuthenticationKeyFilter
extends GeoServerSecurityFilter
implements AuthenticationCachingFilter,
GeoServerAuthenticationFilter {
    private String authKeyMapperName;
    private String authKeyParamName;
    private AuthenticationKeyMapper mapper;
    private String userGroupServiceName;
    private boolean allowChallengeAnonymousSessions;
    protected AuthenticationEntryPoint aep;

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.aep = new Http403ForbiddenEntryPoint();
        AuthenticationKeyFilterConfig authConfig = (AuthenticationKeyFilterConfig)config;
        this.setAuthKeyParamName(authConfig.getAuthKeyParamName());
        this.setUserGroupServiceName(authConfig.getUserGroupServiceName());
        this.setAuthKeyMapperName(authConfig.getAuthKeyMapperName());
        this.mapper = (AuthenticationKeyMapper)GeoServerExtensions.bean((String)this.authKeyMapperName);
        this.mapper.setUserGroupServiceName(this.userGroupServiceName);
        this.mapper.setSecurityManager(this.getSecurityManager());
        this.mapper.configureMapper(authConfig.getMapperParameters());
        this.allowChallengeAnonymousSessions = authConfig.isAllowChallengeAnonymousSessions();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String cacheKey = this.authenticateFromCache(this, (HttpServletRequest)request, this.allowChallengeAnonymousSessions);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.allowChallengeAnonymousSessions || authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            this.doAuthenticate((HttpServletRequest)request, (HttpServletResponse)response, cacheKey);
            Authentication postAuthentication = SecurityContextHolder.getContext().getAuthentication();
            if (postAuthentication != null && !(postAuthentication instanceof AnonymousAuthenticationToken) && cacheKey != null && this.cacheAuthentication(postAuthentication, (HttpServletRequest)request)) {
                this.getSecurityManager().getAuthenticationCache().put(this.getName(), cacheKey, postAuthentication);
            }
        }
        request.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.aep);
        chain.doFilter(request, response);
    }

    public String getAuthKeyMapperName() {
        return this.authKeyMapperName;
    }

    public void setAuthKeyMapperName(String authKeyMapperName) {
        this.authKeyMapperName = authKeyMapperName;
    }

    public String getAuthKeyParamName() {
        return this.authKeyParamName;
    }

    public void setAuthKeyParamName(String authKeyParamName) {
        this.authKeyParamName = authKeyParamName;
    }

    public String getUserGroupServiceName() {
        return this.userGroupServiceName;
    }

    public void setUserGroupServiceName(String userGroupServiceName) {
        this.userGroupServiceName = userGroupServiceName;
    }

    protected void doAuthenticate(HttpServletRequest request, HttpServletResponse response, String authKey) throws IOException {
        if (authKey == null) {
            return;
        }
        GeoServerUser user = this.mapper.getUser(authKey);
        if (user == null) {
            return;
        }
        if ("root".equals(user.getUsername())) {
            LOGGER.warning("Authentication key login does accept the root user");
            return;
        }
        LOGGER.log(Level.FINE, "found user: = " + user.getUsername() + ", trying to authenticate");
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        for (GrantedAuthority auth : user.getAuthorities()) {
            roles.add((GeoServerRole)auth);
        }
        if (!roles.contains(GeoServerRole.AUTHENTICATED_ROLE)) {
            roles.add(GeoServerRole.AUTHENTICATED_ROLE);
        }
        KeyAuthenticationToken result = new KeyAuthenticationToken(authKey, this.authKeyParamName, (UserDetails)user, roles);
        SecurityContextHolder.getContext().setAuthentication((Authentication)result);
    }

    public String getAuthKey(HttpServletRequest req) {
        String authKey = this.getAuthKeyParamValue(req);
        if (!StringUtils.hasLength((String)authKey)) {
            return null;
        }
        return authKey;
    }

    private String getAuthKeyParamValue(HttpServletRequest req) {
        String keyParamName = this.getAuthKeyParamName();
        Enumeration a = req.getParameterNames();
        while (a.hasMoreElements()) {
            String paramName = (String)a.nextElement();
            if (!keyParamName.equalsIgnoreCase(paramName)) continue;
            return req.getParameter(paramName);
        }
        return null;
    }

    public String getCacheKey(HttpServletRequest req) {
        return this.getAuthKey(req);
    }

    public boolean applicableForHtml() {
        return true;
    }

    public boolean applicableForServices() {
        return true;
    }

    protected boolean cacheAuthentication(Authentication auth, HttpServletRequest request) {
        return request.getSession(false) == null;
    }

    public AuthenticationKeyMapper getMapper() {
        return this.mapper;
    }
}

