/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AuthenticationKeyFilterConfig;
import org.geoserver.security.AuthenticationKeyFilterConfigValidator;
import org.geoserver.security.AuthenticationKeyMapper;
import org.geoserver.security.GeoServerAuthenticationKeyFilter;
import org.geoserver.security.GeoServerRestRoleService;
import org.geoserver.security.GeoServerRestRoleServiceConfig;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.AbstractFilterProvider;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.validation.SecurityConfigValidator;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class GeoServerAuthenticationKeyProvider
extends AbstractFilterProvider
implements DisposableBean {
    private static final AtomicInteger poolCounter = new AtomicInteger();
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    private final GeoServerSecurityManager securityManager;
    private final ScheduledExecutorService scheduler;
    private final int autoSyncDelaySeconds;

    public GeoServerAuthenticationKeyProvider(GeoServerSecurityManager securityManager, int autoSyncDelaySeconds) {
        this.securityManager = securityManager;
        this.autoSyncDelaySeconds = autoSyncDelaySeconds;
        this.scheduler = Executors.newScheduledThreadPool(1, this.getThreadFactory());
        AuthKeyMapperSyncRunnable authKeyMapperSyncTask = new AuthKeyMapperSyncRunnable();
        this.scheduler.scheduleAtFixedRate(authKeyMapperSyncTask, autoSyncDelaySeconds, autoSyncDelaySeconds, TimeUnit.SECONDS);
    }

    private ThreadFactory getThreadFactory() {
        CustomizableThreadFactory tFactory = new CustomizableThreadFactory(String.format("GeoServerAuthenticationKey-%d-", poolCounter.getAndIncrement()));
        tFactory.setDaemon(true);
        return tFactory;
    }

    public void configure(XStreamPersister xp) {
        super.configure(xp);
        xp.getXStream().alias("authKeyAuthentication", AuthenticationKeyFilterConfig.class);
        xp.getXStream().alias("authKeyRESTRoleService", GeoServerRestRoleServiceConfig.class);
    }

    public Class<? extends GeoServerSecurityFilter> getFilterClass() {
        return GeoServerAuthenticationKeyFilter.class;
    }

    public GeoServerSecurityFilter createFilter(SecurityNamedServiceConfig config) {
        return new GeoServerAuthenticationKeyFilter();
    }

    public SecurityConfigValidator createConfigurationValidator(GeoServerSecurityManager securityManager) {
        return new AuthenticationKeyFilterConfigValidator(securityManager);
    }

    public GeoServerRoleService createRoleService(SecurityNamedServiceConfig config) throws IOException {
        return new GeoServerRestRoleService(config);
    }

    public GeoServerUserGroupService createUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        return super.createUserGroupService(config);
    }

    public Class<? extends GeoServerRoleService> getRoleServiceClass() {
        return GeoServerRestRoleService.class;
    }

    public Class<? extends GeoServerUserGroupService> getUserGroupServiceClass() {
        return super.getUserGroupServiceClass();
    }

    public boolean roleServiceNeedsLockProtection() {
        return false;
    }

    public boolean userGroupServiceNeedsLockProtection() {
        return super.userGroupServiceNeedsLockProtection();
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public int getAutoSyncDelaySeconds() {
        return this.autoSyncDelaySeconds;
    }

    public void destroy() {
        this.scheduler.shutdown();
    }

    class AuthKeyMapperSyncRunnable
    implements Runnable {
        AuthKeyMapperSyncRunnable() {
        }

        @Override
        public void run() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("AuthenticationKey Mapper Sync task running");
            }
            try {
                GeoServerAuthenticationKeyProvider.this.securityManager.listFilters(GeoServerAuthenticationKeyFilter.class).forEach(this::doSync);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("AuthenticationKey Mapper Sync task completed");
            }
        }

        private void doSync(String filter) {
            AuthenticationKeyFilterConfig config = null;
            try {
                config = (AuthenticationKeyFilterConfig)GeoServerAuthenticationKeyProvider.this.securityManager.loadFilterConfig(filter, true);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Authentication key error ", e);
                throw new RuntimeException(e);
            }
            if (config != null && config.isAllowMapperKeysAutoSync()) {
                AuthenticationKeyMapper mapper = (AuthenticationKeyMapper)GeoServerExtensions.bean((String)config.getAuthKeyMapperName());
                mapper.setAuthenticationFilterName(filter);
                mapper.setSecurityManager(GeoServerAuthenticationKeyProvider.this.securityManager);
                mapper.setUserGroupServiceName(config.getUserGroupServiceName());
                int numberOfNewKeys = 0;
                try {
                    numberOfNewKeys = mapper.synchronize();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("AuthenticationKey Mapper Sync task completed with " + numberOfNewKeys + " new keys");
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Authentication key error ", e);
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

