/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import org.geoserver.security.config.BaseSecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;

public class GeoServerRestRoleServiceConfig
extends BaseSecurityNamedServiceConfig
implements SecurityRoleServiceConfig {
    private static final long serialVersionUID = -8380244566532287415L;
    private static final int defaultCacheConcurrencyLevel = 4;
    private static final long defaultCacheMaximumSize = 10000L;
    private static final long defaultCacheExpirationTime = 30000L;
    private String adminGroup;
    private String groupAdminGroup;
    private String baseUrl;
    private String rolesRESTEndpoint = "/api/roles";
    private String adminRoleRESTEndpoint = "/api/adminRole";
    private String usersRESTEndpoint = "/api/users";
    private String rolesJSONPath = "$.groups";
    private String adminRoleJSONPath = "$.adminRole";
    private String usersJSONPath = "$.users[?(@.username=='${username}')].groups";
    private int cacheConcurrencyLevel = 4;
    private long cacheMaximumSize = 10000L;
    private long cacheExpirationTime = 30000L;
    private String authApiKey;

    public String getAdminRoleName() {
        return this.adminGroup;
    }

    public void setAdminRoleName(String adminRoleName) {
        this.adminGroup = adminRoleName;
    }

    public String getGroupAdminRoleName() {
        return this.groupAdminGroup;
    }

    public void setGroupAdminRoleName(String adminRoleName) {
        this.groupAdminGroup = adminRoleName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getRolesRESTEndpoint() {
        return this.rolesRESTEndpoint;
    }

    public void setRolesRESTEndpoint(String rolesRESTEndpoint) {
        this.rolesRESTEndpoint = rolesRESTEndpoint;
    }

    public String getAdminRoleRESTEndpoint() {
        return this.adminRoleRESTEndpoint;
    }

    public void setAdminRoleRESTEndpoint(String adminRoleRESTEndpoint) {
        this.adminRoleRESTEndpoint = adminRoleRESTEndpoint;
    }

    public String getUsersRESTEndpoint() {
        return this.usersRESTEndpoint;
    }

    public void setUsersRESTEndpoint(String usersRESTEndpoint) {
        this.usersRESTEndpoint = usersRESTEndpoint;
    }

    public String getRolesJSONPath() {
        return this.rolesJSONPath;
    }

    public void setRolesJSONPath(String rolesJSONPath) {
        this.rolesJSONPath = rolesJSONPath;
    }

    public String getAdminRoleJSONPath() {
        return this.adminRoleJSONPath;
    }

    public void setAdminRoleJSONPath(String adminRoleJSONPath) {
        this.adminRoleJSONPath = adminRoleJSONPath;
    }

    public String getUsersJSONPath() {
        return this.usersJSONPath;
    }

    public void setUsersJSONPath(String usersJSONPath) {
        this.usersJSONPath = usersJSONPath;
    }

    public int getCacheConcurrencyLevel() {
        if (this.cacheConcurrencyLevel > 1) {
            return this.cacheConcurrencyLevel;
        }
        return 4;
    }

    public void setCacheConcurrencyLevel(int cacheConcurrencyLevel) {
        this.cacheConcurrencyLevel = cacheConcurrencyLevel;
    }

    public long getCacheMaximumSize() {
        if (this.cacheMaximumSize > 0L) {
            return this.cacheMaximumSize;
        }
        return 10000L;
    }

    public void setCacheMaximumSize(long cacheMaximumSize) {
        this.cacheMaximumSize = cacheMaximumSize;
    }

    public void setCacheExpirationTime(long cacheExpirationTime) {
        this.cacheExpirationTime = cacheExpirationTime;
    }

    public long getCacheExpirationTime() {
        if (this.cacheExpirationTime > 0L) {
            return this.cacheExpirationTime;
        }
        return 30000L;
    }

    public String getAuthApiKey() {
        return this.authApiKey;
    }

    public void setAuthApiKey(String authApiKey) {
        this.authApiKey = authApiKey;
    }
}

