/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.geoserver.platform.resource.Files;
import org.geoserver.security.AbstractAuthenticationKeyMapper;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.PropertyFileWatcher;
import org.geoserver.security.impl.GeoServerUser;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.StringUtils;

public class PropertyAuthenticationKeyMapper
extends AbstractAuthenticationKeyMapper {
    public static final String AUTHKEYS_FILE = "authkeys.properties";
    PropertyFileWatcher fileWatcher;
    Properties authKeyProps;

    @Override
    public boolean supportsReadOnlyUserGroupService() {
        return true;
    }

    @Override
    public Set<String> getAvailableParameters() {
        return new HashSet<String>(List.of("cacheTtlSeconds"));
    }

    @Override
    public synchronized GeoServerUser getUserInternal(String key) throws IOException {
        String userName;
        if (this.authKeyProps == null) {
            this.synchronize();
        }
        if (this.fileWatcher.isStale()) {
            this.authKeyProps = this.fileWatcher.getProperties();
        }
        if (!StringUtils.hasLength((String)(userName = this.authKeyProps.getProperty(key)))) {
            LOGGER.warning("Cannot find user for auth key: " + key);
            return null;
        }
        GeoServerUser theUser = null;
        try {
            theUser = (GeoServerUser)this.getUserGroupService().loadUserByUsername(userName);
        }
        catch (UsernameNotFoundException ex) {
            LOGGER.warning("Cannot find user: " + userName + " in user/group service: " + this.getUserGroupServiceName());
            return null;
        }
        if (!theUser.isEnabled()) {
            LOGGER.info("Found user " + theUser.getUsername() + " for key " + key + ", but this user is disabled");
            return null;
        }
        return theUser;
    }

    @Override
    protected void checkPropertiesInternal() throws IOException {
    }

    @Override
    public synchronized int synchronize() throws IOException {
        this.checkProperties();
        File propFile = new File(this.getSecurityManager().userGroup().dir(), this.getUserGroupServiceName());
        propFile = new File(propFile, AUTHKEYS_FILE);
        File backupFile = new File(this.getSecurityManager().userGroup().dir(), this.getUserGroupServiceName());
        backupFile = new File(backupFile, "authkeys.properties.backup");
        if (backupFile.exists()) {
            throw new IOException("The file: " + backupFile.getCanonicalPath() + " has to be removed first");
        }
        this.resetUserCache();
        this.authKeyProps = new Properties();
        Properties oldProps = new Properties();
        if (propFile.exists()) {
            FileUtils.copyFile((File)propFile, (File)backupFile);
            try (FileInputStream inputFile = new FileInputStream(backupFile);){
                oldProps.load(inputFile);
            }
        }
        HashMap<Object, Object> reverseMap = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : oldProps.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        GeoServerUserGroupService service = this.getUserGroupService();
        int counter = 0;
        for (GeoServerUser user : service.getUsers()) {
            if (reverseMap.containsKey(user.getUsername())) {
                this.authKeyProps.put(reverseMap.get(user.getUsername()), user.getUsername());
                continue;
            }
            this.authKeyProps.put(this.createAuthKey(), user.getUsername());
            ++counter;
        }
        try (FileOutputStream outputFile = new FileOutputStream(propFile, false);){
            this.authKeyProps.store(outputFile, "Format is authkey=username");
        }
        if (backupFile.exists()) {
            backupFile.delete();
        }
        this.fileWatcher = new PropertyFileWatcher(Files.asResource((File)propFile));
        return counter;
    }
}

