/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AuthenticationKeyFilterConfig;
import org.geoserver.security.AuthenticationKeyMapper;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.web.AuthenticationKeyMapperChoice;
import org.geoserver.security.web.auth.AuthenticationFilterPanel;
import org.geoserver.security.web.usergroup.UserGroupServiceChoice;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.HelpLink;
import org.geotools.util.logging.Logging;

public class AuthenticationKeyFilterPanel
extends AuthenticationFilterPanel<AuthenticationKeyFilterConfig> {
    private static final long serialVersionUID = 1L;
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    GeoServerDialog dialog = (GeoServerDialog)this.get("dialog");
    IModel<AuthenticationKeyFilterConfig> model;

    public AuthenticationKeyFilterPanel(String id, IModel<AuthenticationKeyFilterConfig> model) {
        super(id, model);
        this.model = model;
        this.add(new Component[]{new HelpLink("authKeyParametersHelp", (Component)this).setDialog(this.dialog)});
        this.add(new Component[]{new TextField("authKeyParamName")});
        this.add(new Component[]{new CheckBox("allowMapperKeysAutoSync")});
        this.add(new Component[]{new CheckBox("allowChallengeAnonymousSessions")});
        Map<String, String> parameters = ((AuthenticationKeyFilterConfig)((Object)model.getObject())).getMapperParameters();
        final ParamsPanel paramsPanel = this.createParamsPanel("authKeyMapperParamsPanel", ((AuthenticationKeyFilterConfig)((Object)model.getObject())).getAuthKeyMapperName(), parameters);
        AuthenticationKeyMapperChoice authenticationKeyMapperChoice = new AuthenticationKeyMapperChoice("authKeyMapperName");
        authenticationKeyMapperChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                String newSelection = (String)this.getFormComponent().getConvertedInput();
                Map<String, String> parameters = AuthenticationKeyFilterPanel.this.getMapperParameters(newSelection);
                ((AuthenticationKeyFilterConfig)((Object)AuthenticationKeyFilterPanel.this.model.getObject())).setMapperParameters(parameters);
                paramsPanel.updateParameters(newSelection, parameters);
                target.add(new Component[]{paramsPanel});
            }
        }});
        this.add(new Component[]{authenticationKeyMapperChoice});
        this.add(new Component[]{new UserGroupServiceChoice("userGroupServiceName")});
        this.add(new Component[]{new WebMarkupContainer("authKeyMapperParamsContainer").add(new Component[]{paramsPanel}).setOutputMarkupId(true)});
        this.add(new Component[]{new AjaxSubmitLink("synchronize"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    AuthenticationKeyFilterConfig config = (AuthenticationKeyFilterConfig)((Object)AuthenticationKeyFilterPanel.this.model.getObject());
                    AuthenticationKeyFilterPanel.this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
                    AuthenticationKeyMapper mapper = (AuthenticationKeyMapper)GeoServerExtensions.bean((String)config.getAuthKeyMapperName());
                    mapper.setSecurityManager(AuthenticationKeyFilterPanel.this.getSecurityManager());
                    mapper.setUserGroupServiceName(config.getUserGroupServiceName());
                    int numberOfNewKeys = mapper.synchronize();
                    this.info((Serializable)new StringResourceModel("synchronizeSuccessful", (Component)AuthenticationKeyFilterPanel.this).setParameters(new Object[]{numberOfNewKeys}).getObject());
                }
                catch (Exception e) {
                    try {
                        this.error(e);
                        LOGGER.log(Level.WARNING, "Authentication key error ", e);
                    }
                    catch (Throwable throwable) {
                        target.add(new Component[]{this.getPage().get("topFeedback")});
                        throw throwable;
                    }
                    target.add(new Component[]{this.getPage().get("topFeedback")});
                }
                target.add(new Component[]{this.getPage().get("topFeedback")});
            }
        }.setDefaultFormProcessing(true)});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String css = " ul.horizontal div {\n    display:inline;\n  }";
        response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)css, (String)"org-geoserver-security-web-AuthenticationKeyFilterPanel"));
    }

    private ParamsPanel createParamsPanel(String id, String authKeyMapperName, Map<String, String> parameters) {
        ParamsPanel paramsPanel = new ParamsPanel(id, authKeyMapperName, parameters);
        paramsPanel.setOutputMarkupId(true);
        return paramsPanel;
    }

    private Map<String, String> getMapperParameters(String authKeyMapperName) {
        AuthenticationKeyMapper mapper;
        if (authKeyMapperName != null && (mapper = (AuthenticationKeyMapper)GeoServerExtensions.bean((String)authKeyMapperName)) != null) {
            return mapper.getMapperConfiguration();
        }
        return new HashMap<String, String>();
    }

    class ParamsPanel
    extends FormComponentPanel<Serializable> {
        public ParamsPanel(String id, String authMapperName, Map<String, String> parameters) {
            super(id, (IModel)new Model());
            this.updateParameters(authMapperName, parameters);
        }

        private void updateParameters(final String authMapperName, final Map<String, String> parameters) {
            this.removeAll();
            this.add(new Component[]{new ListView<String>("parametersList", (IModel)new Model(new ArrayList<String>(parameters.keySet()))){

                protected void populateItem(ListItem<String> item) {
                    String labelKey = "AuthenticationKeyFilterPanel." + authMapperName + "." + (String)item.getModel().getObject();
                    item.add(new Component[]{new Label("parameterName", (IModel)new StringResourceModel(labelKey, (Component)this, null))});
                    item.add(new Component[]{new TextField("parameterField", (IModel)new MapModel(parameters, (String)item.getModel().getObject()))});
                }
            }});
        }

        public void resetModel() {
        }
    }
}

