/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.flow.ControlFlowCallback;
import org.geoserver.flow.ControlFlowConfigurator;
import org.geoserver.flow.DefaultFlowControllerProvider;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.BasicOWSController;
import org.geoserver.flow.controller.SimpleThreadBlocker;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.HttpServletBean;

public class ControlFlowCallbackTest {
    @Test
    public void testBasicFunctionality() throws IOException, ServletException {
        final ControlFlowCallback callback = new ControlFlowCallback();
        TestingConfigurator tc = new TestingConfigurator();
        final CountingController controller = new CountingController(1, 0L);
        tc.controllers.add(controller);
        callback.provider = new DefaultFlowControllerProvider((ControlFlowConfigurator)tc);
        callback.doFilter(null, null, new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                callback.operationDispatched(null, null);
                Assert.assertEquals((long)1L, (long)controller.requestIncomingCalls);
                Assert.assertEquals((long)0L, (long)controller.requestCompleteCalls);
            }
        });
        Assert.assertEquals((long)1L, (long)controller.requestIncomingCalls);
        Assert.assertEquals((long)1L, (long)controller.requestCompleteCalls);
    }

    @Test
    public void testTimeout() {
        ControlFlowCallback callback = new ControlFlowCallback();
        TestingConfigurator tc = new TestingConfigurator();
        tc.timeout = 300L;
        CountingController c1 = new CountingController(2, 200L);
        CountingController c2 = new CountingController(1, 200L);
        tc.controllers.add(c1);
        tc.controllers.add(c2);
        callback.provider = new DefaultFlowControllerProvider((ControlFlowConfigurator)tc);
        try {
            callback.operationDispatched(null, null);
            Assert.fail((String)"A HTTP 503 should have been raised!");
        }
        catch (HttpErrorCodeException e) {
            Assert.assertEquals((long)503L, (long)e.getErrorCode());
        }
        Assert.assertEquals((long)1L, (long)c1.requestIncomingCalls);
        Assert.assertEquals((long)0L, (long)c1.requestCompleteCalls);
        Assert.assertEquals((long)1L, (long)c2.requestIncomingCalls);
        Assert.assertEquals((long)0L, (long)c1.requestCompleteCalls);
        callback.finished(null);
    }

    @Test
    public void testDelayHeader() {
        ControlFlowCallback callback = new ControlFlowCallback();
        TestingConfigurator tc = new TestingConfigurator();
        tc.timeout = Integer.MAX_VALUE;
        CountingController cc = new CountingController(2, 50L);
        tc.controllers.add(cc);
        callback.provider = new DefaultFlowControllerProvider((ControlFlowConfigurator)tc);
        Request request = new Request();
        MockHttpServletResponse httpResponse = new MockHttpServletResponse();
        request.setHttpResponse((HttpServletResponse)httpResponse);
        callback.operationDispatched(request, null);
        callback.finished(null);
        String delayHeader = httpResponse.getHeader("X-Control-flow-delay-ms");
        Assert.assertNotNull((Object)delayHeader);
        long delay = Long.parseLong(delayHeader);
        Assert.assertTrue((String)("Delay should be greater than 50 " + delay), (delay >= 50L ? 1 : 0) != 0);
    }

    @Test
    public void testFailBeforeOperationDispatch() {
        ControlFlowCallback callback = new ControlFlowCallback();
        callback.init((Request)null);
        callback.finished(null);
        Assert.assertEquals((long)0L, (long)callback.getRunningRequests());
        Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
    }

    @Test
    public void testRequestReplaced() {
        ControlFlowCallback callback = new ControlFlowCallback();
        TestingConfigurator tc = new TestingConfigurator();
        BasicOWSController controller = new BasicOWSController("GWC", 1, (ThreadBlocker)new SimpleThreadBlocker(1));
        tc.controllers.add((FlowController)controller);
        callback.provider = new DefaultFlowControllerProvider((ControlFlowConfigurator)tc);
        Request r1 = new Request();
        r1.setService("GWC");
        MockHttpServletResponse httpResponse = new MockHttpServletResponse();
        r1.setHttpResponse((HttpServletResponse)httpResponse);
        callback.operationDispatched(r1, null);
        Assert.assertEquals((long)1L, (long)callback.getRunningRequests());
        Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
        Request r2 = new Request(r1);
        r2.setService("WMS");
        callback.operationDispatched(r2, null);
        Assert.assertEquals((long)1L, (long)callback.getRunningRequests());
        Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
        callback.finished(r2);
        Assert.assertEquals((long)1L, (long)callback.getRunningRequests());
        Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
        callback.finished(r2);
        Assert.assertEquals((long)0L, (long)callback.getRunningRequests());
        Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
    }

    @Test
    public void testFinishedNotCalled() throws IOException, ServletException {
        final ControlFlowCallback callback = new ControlFlowCallback();
        TestingConfigurator tc = new TestingConfigurator();
        final BasicOWSController controller = new BasicOWSController("GWC", 1, (ThreadBlocker)new SimpleThreadBlocker(1));
        tc.controllers.add((FlowController)controller);
        callback.provider = new DefaultFlowControllerProvider((ControlFlowConfigurator)tc);
        final Request r1 = new Request();
        r1.setService("GWC");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest();
        httpRequest.setMethod("GET");
        MockHttpServletResponse httpResponse = new MockHttpServletResponse();
        r1.setHttpRequest((HttpServletRequest)httpRequest);
        r1.setHttpResponse((HttpServletResponse)httpResponse);
        final AtomicBoolean servletCalled = new AtomicBoolean(false);
        MockFilterChain filterChain = new MockFilterChain((Servlet)new HttpServletBean(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                servletCalled.set(true);
                callback.operationDispatched(r1, null);
                Assert.assertEquals((long)1L, (long)callback.getRunningRequests());
                Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
                Assert.assertEquals((long)1L, (long)controller.getRequestsInQueue());
            }
        }, new Filter[]{callback});
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        Assert.assertTrue((boolean)servletCalled.get());
        Assert.assertEquals((long)0L, (long)callback.getRunningRequests());
        Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
        Assert.assertEquals((long)0L, (long)controller.getRequestsInQueue());
    }

    @Test
    public void testFailNestedRequestParse() throws IOException, ServletException {
        final ControlFlowCallback callback = new ControlFlowCallback();
        TestingConfigurator tc = new TestingConfigurator();
        final BasicOWSController controller = new BasicOWSController("GWC", 1, (ThreadBlocker)new SimpleThreadBlocker(1));
        tc.controllers.add((FlowController)controller);
        callback.provider = new DefaultFlowControllerProvider((ControlFlowConfigurator)tc);
        final Request r1 = new Request();
        r1.setService("GWC");
        MockHttpServletRequest httpRequest = new MockHttpServletRequest();
        httpRequest.setMethod("GET");
        MockHttpServletResponse httpResponse = new MockHttpServletResponse();
        r1.setHttpRequest((HttpServletRequest)httpRequest);
        r1.setHttpResponse((HttpServletResponse)httpResponse);
        final AtomicBoolean servletCalled = new AtomicBoolean(false);
        MockFilterChain filterChain = new MockFilterChain((Servlet)new HttpServletBean(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                servletCalled.set(true);
                callback.operationDispatched(r1, null);
                Assert.assertEquals((long)1L, (long)callback.getRunningRequests());
                Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
                Request r2 = new Request(r1);
                callback.operationDispatched(r2, null);
                Assert.assertEquals((long)1L, (long)callback.getRunningRequests());
                Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
                Assert.assertEquals((long)1L, (long)controller.getRequestsInQueue());
            }
        }, new Filter[]{callback});
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        Assert.assertTrue((boolean)servletCalled.get());
        Assert.assertEquals((long)0L, (long)callback.getRunningRequests());
        Assert.assertEquals((long)0L, (long)callback.getBlockedRequests());
        Assert.assertEquals((long)0L, (long)controller.getRequestsInQueue());
    }

    static class CountingController
    implements FlowController {
        int priority;
        long delay;
        int requestCompleteCalls;
        int requestIncomingCalls;

        public CountingController(int priority, long delay) {
            this.priority = priority;
            this.delay = delay;
        }

        public int getPriority() {
            return this.priority;
        }

        public void requestComplete(Request request) {
            ++this.requestCompleteCalls;
        }

        public boolean requestIncoming(Request request, long timeout) {
            ++this.requestIncomingCalls;
            if (this.delay > 0L) {
                if (timeout > this.delay) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("This is unexpected");
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
    }

    static class TestingConfigurator
    implements ControlFlowConfigurator {
        List<FlowController> controllers = new ArrayList<FlowController>();
        long timeout;
        boolean stale = true;

        TestingConfigurator() {
        }

        public Collection<FlowController> buildFlowControllers() throws Exception {
            this.stale = false;
            return this.controllers;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public boolean isStale() {
            return this.stale;
        }
    }
}

