/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.util.concurrent.CountDownLatch;
import org.geoserver.flow.FlowController;
import org.geoserver.flow.controller.AbstractFlowControllerTest;
import org.geoserver.flow.controller.FlowControllerTestingThread;
import org.geoserver.flow.controller.GlobalFlowController;
import org.geoserver.flow.controller.SimpleThreadBlocker;
import org.geoserver.flow.controller.ThreadBlocker;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;

public class GlobalFlowControllerTest
extends AbstractFlowControllerTest {
    @Test
    public void testPriority() {
        GlobalFlowController controller = new GlobalFlowController(1, (ThreadBlocker)new SimpleThreadBlocker(1));
        Assert.assertEquals((long)1L, (long)controller.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleDelay() throws Exception {
        GlobalFlowController controller = new GlobalFlowController(1, (ThreadBlocker)new SimpleThreadBlocker(1));
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(new Request(), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(new Request(), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        FlowControllerTestingThread t3 = new FlowControllerTestingThread(new Request(), 0L, Long.MAX_VALUE, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            t3.start();
            this.waitBlocked(t3, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.PROCESSING), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t2.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t3.state));
            t1.interrupt();
            this.waitTerminated(t1, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.STARTED), (Object)((Object)t3.state));
            t2.interrupt();
            this.waitTerminated(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t2.state));
            this.waitState(FlowControllerTestingThread.ThreadState.PROCESSING, t3, 60000L);
            t3.interrupt();
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
            this.waitAndKill(t3, 60000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() {
        GlobalFlowController controller = new GlobalFlowController(1, (ThreadBlocker)new SimpleThreadBlocker(1));
        CountDownLatch latch = new CountDownLatch(1);
        FlowControllerTestingThread t1 = new FlowControllerTestingThread(new Request(), 100L, 400L, new FlowController[]{controller});
        t1.setWaitLatch(latch);
        FlowControllerTestingThread t2 = new FlowControllerTestingThread(new Request(), 100L, 400L, new FlowController[]{controller});
        try {
            t1.start();
            this.waitBlocked(t1, 60000L);
            t2.start();
            this.waitBlocked(t2, 60000L);
            latch.countDown();
            this.waitTerminated(t1, 60000L);
            this.waitTerminated(t2, 60000L);
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.COMPLETE), (Object)((Object)t1.state));
            Assert.assertEquals((Object)((Object)FlowControllerTestingThread.ThreadState.TIMED_OUT), (Object)((Object)t2.state));
        }
        finally {
            this.waitAndKill(t1, 60000L);
            this.waitAndKill(t2, 60000L);
        }
    }
}

