/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import com.google.common.base.Predicate;
import javax.servlet.http.Cookie;
import org.geoserver.flow.controller.AbstractFlowControllerTest;
import org.geoserver.flow.controller.CookieKeyGenerator;
import org.geoserver.flow.controller.IpKeyGenerator;
import org.geoserver.flow.controller.KeyGenerator;
import org.geoserver.flow.controller.OWSRequestMatcher;
import org.geoserver.flow.controller.RateFlowController;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class RateFlowControllerTest
extends AbstractFlowControllerTest {
    @Test
    public void testCookieRateControl() {
        RateFlowController controller = new RateFlowController((Predicate)new OWSRequestMatcher(), 2, Long.MAX_VALUE, 1000L, (KeyGenerator)new CookieKeyGenerator());
        Request firstRequest = this.buildCookieRequest(null);
        Assert.assertTrue((boolean)controller.requestIncoming(firstRequest, Integer.MAX_VALUE));
        this.checkHeaders(firstRequest, "Any OGC request", 2, 1);
        Cookie cookie = ((MockHttpServletResponse)firstRequest.getHttpResponse()).getCookies()[0];
        String cookieValue = cookie.getValue();
        Request request = this.buildCookieRequest(cookieValue);
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        this.checkHeaders(request, "Any OGC request", 2, 0);
        long start = System.currentTimeMillis();
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        long end = System.currentTimeMillis();
        long delay = end - start;
        Assert.assertTrue((String)("Request was not delayed enough: " + delay), (delay >= 1000L ? 1 : 0) != 0);
        this.checkHeaders(request, "Any OGC request", 2, 0);
        Assert.assertFalse((boolean)controller.requestIncoming(request, 500L));
        this.checkHeaders(request, "Any OGC request", 2, 0);
    }

    private void checkHeaders(Request request, String context, int limit, int remaining) {
        MockHttpServletResponse response = (MockHttpServletResponse)request.getHttpResponse();
        Assert.assertEquals((Object)context, (Object)response.getHeader("X-Rate-Limit-Context"));
        Assert.assertEquals((Object)String.valueOf(limit), (Object)response.getHeader("X-Rate-Limit-Limit"));
        Assert.assertEquals((Object)String.valueOf(remaining), (Object)response.getHeader("X-Rate-Limit-Remaining"));
    }

    @Test
    public void testCookie429() {
        RateFlowController controller = new RateFlowController((Predicate)new OWSRequestMatcher(), 2, Long.MAX_VALUE, 0L, (KeyGenerator)new CookieKeyGenerator());
        Request firstRequest = this.buildCookieRequest(null);
        Assert.assertTrue((boolean)controller.requestIncoming(firstRequest, Integer.MAX_VALUE));
        Cookie cookie = ((MockHttpServletResponse)firstRequest.getHttpResponse()).getCookies()[0];
        String cookieValue = cookie.getValue();
        Request request = this.buildCookieRequest(cookieValue);
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        try {
            Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        }
        catch (HttpErrorCodeException e) {
            Assert.assertEquals((long)429L, (long)e.getErrorCode());
        }
    }

    @Test
    public void testIpRateControl() {
        RateFlowController controller = new RateFlowController((Predicate)new OWSRequestMatcher(), 2, Long.MAX_VALUE, 1000L, (KeyGenerator)new IpKeyGenerator());
        Request request = this.buildIpRequest("127.0.0.1", "");
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        long start = System.currentTimeMillis();
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        long end = System.currentTimeMillis();
        long delay = end - start;
        Assert.assertTrue((String)("Request was not delayed enough: " + delay), (delay >= 1000L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)controller.requestIncoming(request, 500L));
    }

    @Test
    public void testIp429() {
        RateFlowController controller = new RateFlowController((Predicate)new OWSRequestMatcher(), 2, Long.MAX_VALUE, 0L, (KeyGenerator)new IpKeyGenerator());
        Request request = this.buildIpRequest("127.0.0.1", "");
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        try {
            Assert.assertTrue((boolean)controller.requestIncoming(request, Integer.MAX_VALUE));
        }
        catch (HttpErrorCodeException e) {
            Assert.assertEquals((long)429L, (long)e.getErrorCode());
        }
    }
}

