/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.geoserver.flow.controller.IpBlacklistFilter;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class IpBlacklistFilterTest {
    @Test
    public void testFilterIp() throws IOException, ServletException {
        Properties props = new Properties();
        props.put("ip.blacklist", "192.168.1.8,192.168.1.10");
        IpBlacklistFilter filter = new IpBlacklistFilter(props);
        Assert.assertNotNull((Object)filter);
        TestServlet testServlet = new TestServlet();
        MockFilterChain filterChain = new MockFilterChain((Servlet)testServlet, new Filter[]{filter});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("192.168.1.8");
        MockHttpServletResponse response = new MockHttpServletResponse();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertFalse((boolean)testServlet.wasServiceCalled());
        testServlet.reset();
        filterChain.reset();
        request = new MockHttpServletRequest();
        request.setRemoteAddr("192.168.1.9");
        response = new MockHttpServletResponse();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertTrue((boolean)testServlet.wasServiceCalled());
        testServlet.reset();
        filterChain.reset();
        request = new MockHttpServletRequest();
        request.setRemoteAddr("192.168.1.10");
        response = new MockHttpServletResponse();
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertFalse((boolean)testServlet.wasServiceCalled());
        testServlet.reset();
        filterChain.reset();
    }

    static class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private boolean serviceCalled = false;

        TestServlet() {
        }

        public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.serviceCalled = true;
        }

        public void reset() {
            this.serviceCalled = false;
        }

        public boolean wasServiceCalled() {
            return this.serviceCalled;
        }
    }
}

