/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import org.geoserver.flow.controller.AbstractFlowControllerTest;
import org.geoserver.flow.controller.OWSRequestMatcher;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;

public class OWSRequestMatcherTest
extends AbstractFlowControllerTest {
    @Test
    public void testMatchService() {
        OWSRequestMatcher controller = new OWSRequestMatcher("WMS");
        Assert.assertFalse((boolean)controller.apply(this.buildRequest("WFS", "GetFeature", "GML")));
        Assert.assertTrue((boolean)controller.apply(this.buildRequest("WMS", "GetMap", "image/png")));
        Assert.assertTrue((boolean)controller.apply(this.buildRequest("WMS", "GetFeatureInfo", "image/png")));
    }

    @Test
    public void testMatchServiceRequest() {
        OWSRequestMatcher controller = new OWSRequestMatcher("WMS", "GetMap");
        Assert.assertFalse((boolean)controller.apply(this.buildRequest("WFS", "GetFeature", "GML")));
        Assert.assertTrue((boolean)controller.apply(this.buildRequest("WMS", "GETMAP", "image/png")));
        Assert.assertFalse((boolean)controller.apply(this.buildRequest("WMS", "GetFeatureInfo", "image/png")));
    }

    @Test
    public void testMatchServiceRequestOutputFormat() {
        OWSRequestMatcher controller = new OWSRequestMatcher("WMS", "GetMap", "image/png");
        Assert.assertFalse((boolean)controller.apply(this.buildRequest("WFS", "GetFeature", "GML")));
        Assert.assertTrue((boolean)controller.apply(this.buildRequest("WMS", "GETMAP", "image/png")));
        Assert.assertFalse((boolean)controller.apply(this.buildRequest("WMS", "GETMAP", "application/pdf")));
        Assert.assertFalse((boolean)controller.apply(this.buildRequest("WMS", "GetFeatureInfo", "image/png")));
    }

    Request buildRequest(String service, String request, String outputFormat) {
        Request r = new Request();
        r.setService(service);
        r.setRequest(request);
        r.setOutputFormat(outputFormat);
        return r;
    }
}

