/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.rmi.server.UID;
import javax.servlet.http.Cookie;
import org.geoserver.flow.controller.KeyGenerator;
import org.geoserver.ows.Request;

public class CookieKeyGenerator
implements KeyGenerator {
    static String COOKIE_NAME = "GS_FLOW_CONTROL";
    static String COOKIE_PREFIX = "GS_CFLOW_";

    @Override
    public String getUserKey(Request request) {
        Cookie idCookie = null;
        Cookie[] cookies = request.getHttpRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(COOKIE_NAME)) continue;
                idCookie = cookie;
                break;
            }
        }
        if (idCookie == null) {
            idCookie = new Cookie(COOKIE_NAME, COOKIE_PREFIX + new UID().toString());
        }
        request.getHttpResponse().addCookie(idCookie);
        return idCookie.getValue();
    }
}

