/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.flow.controller;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.flow.controller.IpFlowController;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;

public class IpBlacklistFilter
implements GeoServerFilter {
    static final Logger LOGGER = Logging.getLogger(IpBlacklistFilter.class);
    static final String PROPERTYFILENAME = "controlflow.properties";
    static final String BLPROPERTY = "ip.blacklist";
    static final String WLPROPERTY = "ip.whitelist";
    private Set<String> blackListedAddresses;
    private Set<String> whiteListedAddresses;
    private final PropertyFileWatcher configFile;

    public IpBlacklistFilter(Properties props) {
        this.blackListedAddresses = this.loadConfiguration(props, BLPROPERTY);
        this.whiteListedAddresses = this.loadConfiguration(props, WLPROPERTY);
        this.configFile = null;
    }

    public IpBlacklistFilter() {
        try {
            GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            Resource resource = loader.get(PROPERTYFILENAME);
            this.configFile = new PropertyFileWatcher(resource);
            this.blackListedAddresses = this.reloadConfiguration(BLPROPERTY);
            this.whiteListedAddresses = this.reloadConfiguration(WLPROPERTY);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isBlackListed(httpRequest) && response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(403, "This IP has been blocked. Please contact the server administrator");
            return;
        }
        chain.doFilter(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBlackListed(HttpServletRequest httpRequest) throws IOException {
        if (this.configFile != null && this.configFile.isStale()) {
            PropertyFileWatcher propertyFileWatcher = this.configFile;
            synchronized (propertyFileWatcher) {
                if (this.configFile.isStale()) {
                    this.blackListedAddresses = this.reloadConfiguration(BLPROPERTY);
                    this.whiteListedAddresses = this.reloadConfiguration(WLPROPERTY);
                }
            }
        }
        if (this.blackListedAddresses.isEmpty()) {
            return false;
        }
        String incomingIp = IpFlowController.getRemoteAddr(httpRequest);
        boolean blocked = false;
        for (String blackListRole : this.blackListedAddresses) {
            if (!incomingIp.matches(blackListRole)) continue;
            blocked = true;
            break;
        }
        if (blocked && !this.whiteListedAddresses.isEmpty()) {
            for (String whiteListRole : this.whiteListedAddresses) {
                if (!incomingIp.matches(whiteListRole)) continue;
                blocked = false;
                break;
            }
        }
        return blocked;
    }

    private Set<String> reloadConfiguration(String property) throws IOException {
        Properties props = this.configFile.getProperties();
        if (props == null) {
            return Collections.emptySet();
        }
        return this.loadConfiguration(props, property);
    }

    private Set<String> loadConfiguration(Properties props, String property) {
        String rawList = props.getProperty(property);
        if (null == rawList) {
            return Collections.emptySet();
        }
        HashSet<String> ipAddresses = new HashSet<String>();
        for (String ip : rawList.split(",")) {
            ipAddresses.add(ip.trim().replaceAll("\\*", "(.{0,1}[0-9]+.{0,1}){0,4}"));
        }
        return ipAddresses;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

