/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.community.css.web;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleType;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ModuleStatus;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.style.ResourceLocator;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.styling.css.CssParser;
import org.geotools.styling.css.CssTranslator;
import org.geotools.styling.css.Stylesheet;
import org.geotools.styling.zoom.ZoomContextFinder;
import org.geotools.util.Version;
import org.geotools.util.factory.GeoTools;
import org.xml.sax.EntityResolver;

public class CssHandler
extends StyleHandler
implements ModuleStatus {
    public static final String FORMAT = "css";
    public static final String MIME_TYPE = "application/vnd.geoserver.geocss+css";
    static final Map<StyleType, String> TEMPLATES = new HashMap<StyleType, String>();
    private final List<ZoomContextFinder> zoomContextFinders;
    private SLDHandler sldHandler;

    protected CssHandler(GeoServerExtensions extensions, SLDHandler sldHandler) {
        super("CSS", FORMAT);
        this.sldHandler = sldHandler;
        this.zoomContextFinders = GeoServerExtensions.extensions(ZoomContextFinder.class);
    }

    public String getStyle(StyleType type, Color color, String colorName, String layerName) {
        String template = TEMPLATES.get(type);
        String colorCode = Integer.toHexString(color.getRGB());
        colorCode = colorCode.substring(2, colorCode.length());
        return template.replace("${colorName}", colorName).replace("${colorCode}", "#" + colorCode).replace("${layerName}", layerName);
    }

    public String mimeType(Version version) {
        return MIME_TYPE;
    }

    public StyledLayerDescriptor parse(Object input, Version version, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        if (input instanceof File) {
            File cssFile = (File)input;
            input = new FileSystemResourceStore(cssFile.getParentFile()).get(cssFile.getName());
        }
        if (input instanceof Resource) {
            Resource cssResource = (Resource)input;
            Resource sldResource = cssResource.parent().get(FilenameUtils.getBaseName((String)cssResource.name()) + ".sld");
            if (sldResource.getType() != Resource.Type.UNDEFINED && sldResource.lastmodified() > cssResource.lastmodified()) {
                return this.sldHandler.parse((Object)sldResource, SLDHandler.VERSION_10, resourceLocator, entityResolver);
            }
            try (Reader reader = this.toReader(input);){
                StyledLayerDescriptor sld = this.convertToSLD(reader);
                try (OutputStream fos = sldResource.out();){
                    this.sldHandler.encode(sld, SLDHandler.VERSION_10, true, fos);
                }
                StyledLayerDescriptor styledLayerDescriptor = this.sldHandler.parse((Object)sldResource, SLDHandler.VERSION_10, resourceLocator, entityResolver);
                return styledLayerDescriptor;
            }
        }
        try (Reader unusedReader = this.toReader(input);){
            StyledLayerDescriptor styledLayerDescriptor = this.convertToSLD(this.toReader(input));
            return styledLayerDescriptor;
        }
    }

    StyledLayerDescriptor convertToSLD(String css) throws IOException {
        return this.convertToSLD(new StringReader(css));
    }

    private StyledLayerDescriptor convertToSLD(Reader cssReader) throws IOException {
        Stylesheet styleSheet = CssParser.parse((String)IOUtils.toString((Reader)cssReader));
        CssTranslator translator = new CssTranslator();
        translator.setZoomContextFinders(this.zoomContextFinders);
        StyledLayerDescriptor sld = translator.translateMultilayer(styleSheet);
        return sld;
    }

    public void encode(StyledLayerDescriptor sld, Version version, boolean pretty, OutputStream output) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<Exception> validate(Object input, Version version, EntityResolver entityResolver) throws IOException {
        List<Exception> list;
        block8: {
            Reader unusedReader = this.toReader(input);
            try {
                this.convertToSLD(this.toReader(input));
                list = Collections.emptyList();
                if (unusedReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (unusedReader != null) {
                        try {
                            unusedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return List.of(e);
                }
            }
            unusedReader.close();
        }
        return list;
    }

    public String getCodeMirrorEditMode() {
        return "text/geocss";
    }

    public URL getSpecification(Version version) throws MalformedURLException {
        return new URL("https://docs.geoserver.org/latest/en/user/styling/css/index.html");
    }

    public String getFileExtension() {
        return FORMAT;
    }

    public String getModule() {
        return "gs-css";
    }

    public Optional<String> getComponent() {
        return Optional.of("GeoServer CSS Styling");
    }

    public Optional<String> getVersion() {
        Version v = GeoTools.getVersion(CssParser.class);
        if (v == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(v.toString());
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Optional<String> getMessage() {
        return Optional.of("CSS Styling");
    }

    public Optional<String> getDocumentation() {
        return Optional.of("https://docs.geoserver.org/latest/en/user/styling/css/index.html");
    }

    static {
        try {
            TEMPLATES.put(StyleType.POINT, IOUtils.toString((InputStream)CssHandler.class.getResourceAsStream("template_point.css"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.POLYGON, IOUtils.toString((InputStream)CssHandler.class.getResourceAsStream("template_polygon.css"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.LINE, IOUtils.toString((InputStream)CssHandler.class.getResourceAsStream("template_line.css"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.RASTER, IOUtils.toString((InputStream)CssHandler.class.getResourceAsStream("template_raster.css"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.GENERIC, IOUtils.toString((InputStream)CssHandler.class.getResourceAsStream("template_generic.css"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading up the css style templates", e);
        }
    }
}

