/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.integration;

import java.util.Set;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.geofence.core.model.LayerAttribute;
import org.geoserver.geofence.core.model.LayerDetails;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.LayerType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.wms.WMSTestSupport;
import org.junit.Before;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeofenceWMSTestSupport
extends WMSTestSupport {
    protected RuleAdminService ruleService;

    @Before
    public void before() {
        this.ruleService = (RuleAdminService)applicationContext.getBean("ruleAdminService");
    }

    static long addRule(GrantType access, String username, String roleName, String service, String request, String workspace, String layer, long priority, RuleAdminService ruleService) {
        Rule rule = new Rule();
        rule.setAccess(access);
        rule.setUsername(username);
        rule.setRolename(roleName);
        rule.setService(service);
        rule.setRequest(request);
        rule.setWorkspace(workspace);
        rule.setLayer(layer);
        rule.setPriority(priority);
        return ruleService.insert(rule);
    }

    long addRule(GrantType access, String username, String roleName, String service, String request, String subfield, String workspace, String layer, long priority) {
        Rule rule = new Rule();
        rule.setAccess(access);
        rule.setUsername(username);
        rule.setRolename(roleName);
        rule.setService(service);
        rule.setRequest(request);
        rule.setSubfield(subfield);
        rule.setWorkspace(workspace);
        rule.setLayer(layer);
        rule.setPriority(priority);
        return this.ruleService.insert(rule);
    }

    static void addRuleLimits(long ruleId, CatalogMode mode, String allowedArea, Integer srid, RuleAdminService ruleService) throws ParseException {
        GeofenceWMSTestSupport.addRuleLimits(ruleId, mode, allowedArea, srid, null, ruleService);
    }

    static void addRuleLimits(long ruleId, CatalogMode mode, String allowedArea, Integer srid, SpatialFilterType spatialFilterType, RuleAdminService ruleService) throws ParseException {
        RuleLimits limits = new RuleLimits();
        limits.setCatalogMode(mode);
        MultiPolygon allowedAreaGeom = (MultiPolygon)new WKTReader().read(allowedArea);
        if (srid != null) {
            allowedAreaGeom.setSRID(srid.intValue());
        }
        limits.setAllowedArea(allowedAreaGeom);
        if (spatialFilterType == null) {
            spatialFilterType = SpatialFilterType.INTERSECT;
        }
        limits.setSpatialFilterType(spatialFilterType);
        ruleService.setLimits(Long.valueOf(ruleId), limits);
    }

    static void deleteRules(RuleAdminService ruleService, Long ... ids) {
        for (Long id : ids) {
            if (id == null) continue;
            ruleService.delete(id.longValue());
        }
    }

    protected LayerGroupInfo addLakesPlacesLayerGroup(LayerGroupInfo.Mode mode, String name) throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(this.getCatalog(), name, mode, null);
        this.logout();
        return group;
    }

    protected void removeLayerGroup(LayerGroupInfo ... groups) {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        for (LayerGroupInfo group : groups) {
            if (group == null) continue;
            this.getCatalog().remove(group);
        }
        this.logout();
    }

    static void addLayerDetails(RuleAdminService ruleService, Long ruleId, Set<String> allowedStyles, Set<LayerAttribute> attributes, CatalogMode mode, String cqlRead, String cqlWrite, LayerType layerType) throws ParseException {
        LayerDetails details = new LayerDetails();
        details.setType(layerType);
        details.setAttributes(attributes);
        details.setAllowedStyles(allowedStyles);
        details.setCatalogMode(mode);
        details.setCqlFilterWrite(cqlWrite);
        details.setCqlFilterRead(cqlRead);
        ruleService.setDetails(ruleId, details);
    }
}

