/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.geofence.core.model.LayerDetails;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.LayerType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.server.web.GeofenceRulePage;
import org.geoserver.geofence.server.web.GeofenceRulesModel;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layergroup.LayerGroupBaseTest;
import org.junit.Assert;
import org.junit.Test;

public class GeofenceRulePageTest
extends LayerGroupBaseTest {
    protected void onSetUp(SystemTestData testData) throws Exception {
        this.login();
        super.onSetUp(testData);
    }

    @Test
    public void testAddLayerGroupRule() {
        GeofenceRulesModel model = new GeofenceRulesModel();
        ShortRule shortRule = model.newRule();
        shortRule.setAccess(GrantType.LIMIT);
        tester.startPage((Page)new GeofenceRulePage(shortRule, model));
        tester.assertRenderedPage(GeofenceRulePage.class);
        FormTester ft = tester.newFormTester("form");
        Form form = ft.getForm();
        DropDownChoice layer = (DropDownChoice)form.get("tabs:panel:layer");
        Assert.assertFalse((boolean)layer.getChoices().isEmpty());
        ft.select("tabs:panel:layer", 0);
        ft.select("tabs:panel:catalogMode", 0);
        ft.select("tabs:panel:spatialFilterType", 1);
        ft = tester.newFormTester("form");
        ft.setValue("tabs:panel:allowedArea", "SRID=4326;POLYGON((30 10, 40 40, 20 40, 10 20, 30 10))");
        tester.clickLink("form:tabs:tabs-container:tabs:1:link");
        ft.submit("save");
        tester.assertNoErrorMessage();
        RuleAdminService adminService = (RuleAdminService)GeoServerApplication.get().getBean("ruleAdminService");
        ShortRule rule = adminService.getRuleByPriority(0L);
        Assert.assertEquals((Object)"lakes", (Object)rule.getLayer());
        Assert.assertNotNull((Object)rule.getAccess().name());
        Rule fullRule = adminService.get(rule.getId().longValue());
        RuleLimits limits = fullRule.getRuleLimits();
        Assert.assertEquals((Object)CatalogMode.HIDE, (Object)limits.getCatalogMode());
        Assert.assertEquals((Object)SpatialFilterType.CLIP, (Object)limits.getSpatialFilterType());
        Assert.assertNotNull((Object)limits.getAllowedArea());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerTypeIsAutomaticallySet() {
        RuleAdminService adminService = (RuleAdminService)GeoServerApplication.get().getBean("ruleAdminService");
        Rule rule = new Rule();
        rule.setPriority(9999L);
        rule.setWorkspace("cite");
        rule.setLayer("BasicPolygons");
        rule.setAccess(GrantType.ALLOW);
        long ruleId = adminService.insert(rule);
        LayerDetails layerDetails = new LayerDetails();
        adminService.setDetails(Long.valueOf(ruleId), layerDetails);
        GeofenceRulesModel model = new GeofenceRulesModel();
        ShortRule ruleModel = new ShortRule(rule);
        try {
            this.login();
            tester.startPage((Page)new GeofenceRulePage(ruleModel, model));
            tester.clickLink("form:tabs:tabs-container:tabs:1:link");
            FormTester ft = tester.newFormTester("form");
            ft.setValue("tabs:panel:layerDetailsCheck", true);
            tester.executeAjaxEvent("form:tabs:panel:layerDetailsCheck", "change");
            tester.assertModelValue("form:tabs:panel:layerDetailsContainer:layerType", (Object)LayerType.VECTOR);
            Component availableStyles = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:allowedStyles");
            Component defaultStyle = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:defaultStyle");
            Component cqlFilterRead = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:cqlFilterRead");
            Component cqlFilterWrite = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:cqlFilterWrite");
            Component allowedArea = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:allowedArea");
            Assert.assertTrue((boolean)availableStyles.isEnabled());
            Assert.assertTrue((boolean)defaultStyle.isEnabled());
            Assert.assertTrue((boolean)cqlFilterRead.isEnabled());
            Assert.assertTrue((boolean)cqlFilterWrite.isEnabled());
            Assert.assertTrue((boolean)allowedArea.isEnabled());
            DropDownChoice spatialFilterType = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:spatialFilterType");
            Assert.assertTrue((boolean)spatialFilterType.isEnabled());
            Assert.assertEquals((Object)SpatialFilterType.INTERSECT, (Object)spatialFilterType.getModelObject());
        }
        finally {
            this.deleteRule(ruleId);
            this.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerTypeIsAutomaticallySet2() {
        RuleAdminService adminService = (RuleAdminService)GeoServerApplication.get().getBean("ruleAdminService");
        Rule rule = new Rule();
        rule.setPriority(9999L);
        rule.setLayer("lakes");
        rule.setAccess(GrantType.ALLOW);
        long ruleId = adminService.insert(rule);
        LayerDetails layerDetails = new LayerDetails();
        adminService.setDetails(Long.valueOf(ruleId), layerDetails);
        GeofenceRulesModel model = new GeofenceRulesModel();
        ShortRule ruleModel = new ShortRule(rule);
        try {
            this.login();
            tester.startPage((Page)new GeofenceRulePage(ruleModel, model));
            tester.clickLink("form:tabs:tabs-container:tabs:1:link");
            FormTester ft = tester.newFormTester("form");
            ft.setValue("tabs:panel:layerDetailsCheck", true);
            tester.executeAjaxEvent("form:tabs:panel:layerDetailsCheck", "change");
            tester.assertModelValue("form:tabs:panel:layerDetailsContainer:layerType", (Object)LayerType.LAYERGROUP);
            Component availableStyles = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:allowedStyles");
            Component defaultStyle = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:defaultStyle");
            Component cqlFilterRead = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:cqlFilterRead");
            Component cqlFilterWrite = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:cqlFilterWrite");
            Component allowedArea = tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:allowedArea");
            Assert.assertFalse((boolean)availableStyles.isEnabled());
            Assert.assertFalse((boolean)defaultStyle.isEnabled());
            Assert.assertFalse((boolean)cqlFilterRead.isEnabled());
            Assert.assertFalse((boolean)cqlFilterWrite.isEnabled());
            Assert.assertTrue((boolean)allowedArea.isEnabled());
            DropDownChoice spatialFilterType = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:tabs:panel:layerDetailsContainer:spatialFilterType");
            Assert.assertTrue((boolean)spatialFilterType.isEnabled());
            Assert.assertEquals((Object)SpatialFilterType.INTERSECT, (Object)spatialFilterType.getModelObject());
        }
        finally {
            this.deleteRule(ruleId);
            this.logout();
        }
    }

    private void deleteRule(Long id) {
        if (id != null) {
            RuleAdminService adminService = (RuleAdminService)GeoServerApplication.get().getBean("ruleAdminService");
            adminService.delete(id.longValue());
        }
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        GeofenceRulePageTest.testData = new SystemTestData();
        try {
            if (System.getProperty("IS_GEOFENCE_AVAILABLE") != null) {
                System.clearProperty("IS_GEOFENCE_AVAILABLE");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not remove System ENV variable {IS_GEOFENCE_AVAILABLE}", e);
        }
    }
}

