/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest;

import java.util.UUID;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.geofence.core.dao.DuplicateKeyException;
import org.geoserver.geofence.core.model.AdminRule;
import org.geoserver.geofence.core.model.enums.AdminGrantType;
import org.geoserver.geofence.server.rest.AdminRulesRestController;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRule;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRuleList;
import org.geoserver.geofence.services.AdminRuleAdminService;
import org.geoserver.geofence.services.dto.ShortAdminRule;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class AdminRulesRestControllerTest
extends GeofenceBaseTest {
    protected AdminRulesRestController controller;
    protected AdminRuleAdminService adminService;

    @Before
    public void initGeoFenceControllers() {
        this.controller = (AdminRulesRestController)applicationContext.getBean("adminRulesRestController");
        this.adminService = (AdminRuleAdminService)applicationContext.getBean("adminRuleAdminService");
    }

    @Test
    public void testInsertUpdateDelete() {
        JaxbAdminRule rule = new JaxbAdminRule();
        rule.setPriority(Long.valueOf(5L));
        rule.setUserName("test_user");
        rule.setRoleName("test_role");
        rule.setWorkspace("workspace");
        rule.setAccess(AdminGrantType.ADMIN.name());
        long id = (Long)this.controller.insert(rule).getBody();
        AdminRule realRule = this.adminService.get(id);
        Assert.assertEquals((long)rule.getPriority(), (long)realRule.getPriority());
        Assert.assertEquals((Object)rule.getUserName(), (Object)realRule.getUsername());
        Assert.assertEquals((Object)rule.getRoleName(), (Object)realRule.getRolename());
        Assert.assertEquals((Object)rule.getWorkspace(), (Object)realRule.getWorkspace());
        Assert.assertEquals((Object)rule.getAccess(), (Object)realRule.getAccess().name());
        JaxbAdminRule ruleMods = new JaxbAdminRule();
        ruleMods.setRoleName("acrobaat");
        this.controller.update(Long.valueOf(id), ruleMods);
        realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getUserName(), (Object)realRule.getUsername());
        Assert.assertEquals((Object)ruleMods.getRoleName(), (Object)realRule.getRolename());
        JaxbAdminRule rule2 = new JaxbAdminRule();
        rule2.setPriority(Long.valueOf(5L));
        rule2.setAccess(AdminGrantType.USER.name());
        long id2 = (Long)this.controller.insert(rule2).getBody();
        realRule = this.adminService.get(id);
        Assert.assertEquals((long)6L, (long)realRule.getPriority());
        JaxbAdminRule rule2Mods = new JaxbAdminRule();
        rule2Mods.setPriority(Long.valueOf(3L));
        this.controller.update(Long.valueOf(id2), rule2Mods);
        realRule = this.adminService.get(id2);
        Assert.assertEquals((long)3L, (long)realRule.getPriority());
        rule2Mods = new JaxbAdminRule();
        rule2Mods.setPriority(Long.valueOf(6L));
        this.controller.update(Long.valueOf(id2), rule2Mods);
        realRule = this.adminService.get(id2);
        Assert.assertEquals((long)6L, (long)realRule.getPriority());
        realRule = this.adminService.get(id);
        Assert.assertEquals((long)7L, (long)realRule.getPriority());
        this.controller.delete(Long.valueOf(id));
        boolean notfound = false;
        try {
            this.adminService.get(id);
        }
        catch (NotFoundServiceEx e) {
            notfound = true;
        }
        Assert.assertTrue((boolean)notfound);
        boolean conflict = false;
        try {
            this.controller.insert(rule2);
        }
        catch (DuplicateKeyException e) {
            conflict = true;
        }
        Assert.assertTrue((boolean)conflict);
    }

    @Test
    public void testMovingRules() {
        String prefix = UUID.randomUUID().toString();
        this.adminService.insert(new AdminRule(5L, prefix + "-user5", prefix + "-role1", null, null, null, AdminGrantType.ADMIN));
        this.adminService.insert(new AdminRule(2L, prefix + "-user2", prefix + "-role1", null, null, null, AdminGrantType.ADMIN));
        this.adminService.insert(new AdminRule(1L, prefix + "-user1", prefix + "-role1", null, null, null, AdminGrantType.ADMIN));
        this.adminService.insert(new AdminRule(4L, prefix + "-user4", prefix + "-role2", null, null, null, AdminGrantType.ADMIN));
        this.adminService.insert(new AdminRule(3L, prefix + "-user3", prefix + "-role2", null, null, null, AdminGrantType.ADMIN));
        this.adminService.insert(new AdminRule(6L, prefix + "-user6", prefix + "-role6", null, null, null, AdminGrantType.ADMIN));
        JaxbAdminRuleList originalRules = this.controller.get(Integer.valueOf(0), Integer.valueOf(6), false, null, null, null, null, null, null);
        this.validateRules(originalRules, prefix, "user1", "user2", "user3", "user4", "user5", "user6");
        this.validateRules(0, prefix, "user1", "user2");
        this.validateRules(0, 1L, 2L);
        this.validateRules(1, prefix, "user3", "user4");
        this.validateRules(1, 3L, 4L);
        this.validateRules(2, prefix, "user5", "user6");
        this.validateRules(2, 5L, 6L);
        ResponseEntity result = this.controller.move(7, ((JaxbAdminRule)originalRules.getRules().get(0)).getId() + "," + ((JaxbAdminRule)originalRules.getRules().get(1)).getId());
        this.validateResult((ResponseEntity<JaxbAdminRuleList>)result, HttpStatus.OK, 2);
        this.validateRules((JaxbAdminRuleList)result.getBody(), prefix, "user1", "user2");
        this.validateRules((JaxbAdminRuleList)result.getBody(), 7L, 8L);
        this.validateRules(0, prefix, "user3", "user4");
        this.validateRules(0, 3L, 4L);
        this.validateRules(1, prefix, "user5", "user6");
        this.validateRules(1, 5L, 6L);
        this.validateRules(2, prefix, "user1", "user2");
        this.validateRules(2, 7L, 8L);
        result = this.controller.move(7, ((JaxbAdminRule)originalRules.getRules().get(2)).getId() + "," + ((JaxbAdminRule)originalRules.getRules().get(3)).getId());
        this.validateResult((ResponseEntity<JaxbAdminRuleList>)result, HttpStatus.OK, 2);
        this.validateRules((JaxbAdminRuleList)result.getBody(), prefix, "user3", "user4");
        this.validateRules((JaxbAdminRuleList)result.getBody(), 7L, 8L);
        this.validateRules(0, prefix, "user5", "user6");
        this.validateRules(0, 5L, 6L);
        this.validateRules(1, prefix, "user3", "user4");
        this.validateRules(1, 7L, 8L);
        this.validateRules(2, prefix, "user1", "user2");
        this.validateRules(2, 9L, 10L);
        result = this.controller.move(5, String.valueOf(((JaxbAdminRule)originalRules.getRules().get(0)).getId()));
        this.validateResult((ResponseEntity<JaxbAdminRuleList>)result, HttpStatus.OK, 1);
        this.validateRules((JaxbAdminRuleList)result.getBody(), prefix, "user1");
        this.validateRules((JaxbAdminRuleList)result.getBody(), 5L);
        this.validateRules(0, prefix, "user1", "user5");
        this.validateRules(0, 5L, 6L);
        this.validateRules(1, prefix, "user6", "user3");
        this.validateRules(1, 7L, 8L);
        this.validateRules(2, prefix, "user4", "user2");
        this.validateRules(2, 9L, 11L);
        result = this.controller.move(6, ((JaxbAdminRule)originalRules.getRules().get(1)).getId() + "," + ((JaxbAdminRule)originalRules.getRules().get(2)).getId());
        this.validateResult((ResponseEntity<JaxbAdminRuleList>)result, HttpStatus.OK, 2);
        this.validateRules((JaxbAdminRuleList)result.getBody(), prefix, "user3", "user2");
        this.validateRules((JaxbAdminRuleList)result.getBody(), 6L, 7L);
        this.validateRules(0, prefix, "user1", "user3");
        this.validateRules(0, 5L, 6L);
        this.validateRules(1, prefix, "user2", "user5");
        this.validateRules(1, 7L, 8L);
        this.validateRules(2, prefix, "user6", "user4");
        this.validateRules(2, 9L, 11L);
    }

    @Test
    public void testAdminRulesXMLPayload() throws Exception {
        this.adminService.getAll().stream().mapToLong(ShortAdminRule::getId).peek(id -> LOGGER.warning("deleting " + id)).forEach(arg_0 -> ((AdminRuleAdminService)this.adminService).delete(arg_0));
        String prefix = UUID.randomUUID().toString();
        String username = prefix + "-user";
        String rolename = prefix + "-role";
        long id2 = this.adminService.insert(new AdminRule(5L, username, rolename, null, null, "cite", AdminGrantType.ADMIN));
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><AdminRules count=\"1\"><AdminRule id=\"" + id2 + "\"><access>ADMIN</access><priority>5</priority><roleName>" + rolename + "</roleName><userName>" + username + "</userName><workspace>cite</workspace></AdminRule></AdminRules>";
        String response = super.getAsString("/rest/geofence/adminrules");
        XMLAssert.assertXMLEqual((String)expected, (String)response);
    }

    private void validateResult(ResponseEntity<JaxbAdminRuleList> result, HttpStatus expectedHttpStatus, int rules) {
        MatcherAssert.assertThat(result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getStatusCode(), (Matcher)CoreMatchers.is((Object)expectedHttpStatus));
        if (rules > 0) {
            MatcherAssert.assertThat((Object)((JaxbAdminRuleList)result.getBody()), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)((JaxbAdminRuleList)result.getBody()).getRules().size(), (Matcher)CoreMatchers.is((Object)rules));
        } else {
            MatcherAssert.assertThat((Object)((JaxbAdminRuleList)result.getBody()), (Matcher)CoreMatchers.nullValue());
        }
    }

    private void validateRules(int page, String prefix, String ... expectedUsers) {
        JaxbAdminRuleList rules = this.controller.get(Integer.valueOf(page), Integer.valueOf(2), false, null, null, null, null, null, null);
        this.validateRules(rules, prefix, expectedUsers);
    }

    private void validateRules(JaxbAdminRuleList rules, String prefix, String ... expectedUsers) {
        MatcherAssert.assertThat((Object)rules, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules().size(), (Matcher)CoreMatchers.is((Object)expectedUsers.length));
        for (int i = 0; i < expectedUsers.length; ++i) {
            MatcherAssert.assertThat((Object)((JaxbAdminRule)rules.getRules().get(i)).getUserName(), (Matcher)CoreMatchers.is((Object)(prefix + "-" + expectedUsers[i])));
        }
    }

    private void validateRules(int page, long ... expectedPriorities) {
        JaxbAdminRuleList rules = this.controller.get(Integer.valueOf(page), Integer.valueOf(2), false, null, null, null, null, null, null);
        this.validateRules(rules, expectedPriorities);
    }

    private void validateRules(JaxbAdminRuleList rules, long ... expectedPriorities) {
        MatcherAssert.assertThat((Object)rules, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules().size(), (Matcher)CoreMatchers.is((Object)expectedPriorities.length));
        for (int i = 0; i < expectedPriorities.length; ++i) {
            MatcherAssert.assertThat((Object)((JaxbAdminRule)rules.getRules().get(i)).getPriority(), (Matcher)CoreMatchers.is((Object)expectedPriorities[i]));
        }
    }
}

