/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.server.rest.xml.JaxbRule;
import org.geoserver.geofence.server.rest.xml.JaxbRuleList;
import org.geoserver.geofence.server.rest.xml.MultiPolygonAdapter;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.geofence.services.exception.BadRequestServiceEx;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.catalog.SequentialExecutionController;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/geofence"})
public class RulesRestController
extends RestBaseController
implements SequentialExecutionController {
    private RuleAdminService adminService;

    @Autowired
    public RulesRestController(RuleAdminService adminService) {
        this.adminService = adminService;
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
        XStream xs = persister.getXStream();
        xs.alias("Rule", JaxbRule.class);
        xs.allowTypes(new Class[]{JaxbRule.class, MultiPolygonAdapter.class});
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return JaxbRule.class.isAssignableFrom(methodParameter.getParameterType());
    }

    @ExceptionHandler(value={NotFoundServiceEx.class})
    public void ruleNotFound(NotFoundServiceEx exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404, exception.getMessage());
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public void rule(DuplicateKeyException exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(409, exception.getMessage());
    }

    @ExceptionHandler(value={BadRequestServiceEx.class})
    public void badRequest(BadRequestServiceEx exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(400, exception.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public void messageNotReadableException(HttpMessageNotReadableException exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(400, exception.getMessage());
    }

    @RequestMapping(value={"/rules"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    public JaxbRuleList get(@RequestParam(value="page", required=false) Integer page, @RequestParam(value="entries", required=false) Integer entries, @RequestParam(value="full", required=false, defaultValue="false") boolean full, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="userAny", required=false) Boolean userDefault, @RequestParam(value="roleName", required=false) String roleName, @RequestParam(value="roleAny", required=false) Boolean roleDefault, @RequestParam(value="instanceId", required=false) Long instanceId, @RequestParam(value="instanceName", required=false) String instanceName, @RequestParam(value="instanceAny", required=false) Boolean instanceDefault, @RequestParam(value="ipAddress", required=false) String ipAddress, @RequestParam(value="ipAddressAny", required=false) Boolean ipAddressDefault, @RequestParam(value="date", required=false) String date, @RequestParam(value="dateAny", required=false) Boolean dateDefault, @RequestParam(value="service", required=false) String serviceName, @RequestParam(value="serviceAny", required=false) Boolean serviceDefault, @RequestParam(value="request", required=false) String requestName, @RequestParam(value="requestAny", required=false) Boolean requestDefault, @RequestParam(value="subfield", required=false) String subfield, @RequestParam(value="subfieldAny", required=false) Boolean subfieldDefault, @RequestParam(value="workspace", required=false) String workspace, @RequestParam(value="workspaceAny", required=false) Boolean workspaceDefault, @RequestParam(value="layer", required=false) String layer, @RequestParam(value="layerAny", required=false) Boolean layerDefault) {
        RuleFilter filter = this.buildFilter(userName, userDefault, roleName, roleDefault, instanceId, instanceName, instanceDefault, ipAddress, ipAddressDefault, date, dateDefault, serviceName, serviceDefault, requestName, requestDefault, subfield, subfieldDefault, workspace, workspaceDefault, layer, layerDefault);
        return new JaxbRuleList(this.adminService.getListFull(filter, page, entries));
    }

    @RequestMapping(value={"/rules/id/{id}"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    public JaxbRule get(@PathVariable(value="id") Long id) {
        return new JaxbRule(this.adminService.get(id.longValue()));
    }

    @RequestMapping(value={"/rules/count"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    public JaxbRuleList count(@RequestParam(value="userName", required=false) String userName, @RequestParam(value="userAny", required=false) Boolean userDefault, @RequestParam(value="roleName", required=false) String roleName, @RequestParam(value="roleAny", required=false) Boolean roleDefault, @RequestParam(value="instanceId", required=false) Long instanceId, @RequestParam(value="instanceName", required=false) String instanceName, @RequestParam(value="instanceAny", required=false) Boolean instanceDefault, @RequestParam(value="ipAddress", required=false) String ipAddress, @RequestParam(value="ipAddressAny", required=false) Boolean ipAddressDefault, @RequestParam(value="date", required=false) String date, @RequestParam(value="dateAny", required=false) Boolean dateDefault, @RequestParam(value="service", required=false) String serviceName, @RequestParam(value="serviceAny", required=false) Boolean serviceDefault, @RequestParam(value="request", required=false) String requestName, @RequestParam(value="requestAny", required=false) Boolean requestDefault, @RequestParam(value="subfield", required=false) String subfield, @RequestParam(value="subfieldAny", required=false) Boolean subfieldDefault, @RequestParam(value="workspace", required=false) String workspace, @RequestParam(value="workspaceAny", required=false) Boolean workspaceDefault, @RequestParam(value="layer", required=false) String layer, @RequestParam(value="layerAny", required=false) Boolean layerDefault) {
        RuleFilter filter = this.buildFilter(userName, userDefault, roleName, roleDefault, instanceId, instanceName, instanceDefault, ipAddress, ipAddressDefault, date, dateDefault, serviceName, serviceDefault, requestName, requestDefault, subfield, subfieldDefault, workspace, workspaceDefault, layer, layerDefault);
        return new JaxbRuleList(this.adminService.count(filter));
    }

    @RequestMapping(value={"/rules"}, method={RequestMethod.POST}, consumes={"text/xml", "application/xml", "application/json", "text/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public String insert(@RequestBody(required=true) JaxbRule rule) {
        long priority;
        long l = priority = rule.getPriority() == null ? 0L : rule.getPriority();
        if (this.adminService.getRuleByPriority(priority) != null) {
            this.adminService.shift(priority, 1L);
        }
        Long id = this.adminService.insert(rule.toRule());
        if (rule.getLimits() != null && rule.getAccess().equals("LIMIT")) {
            this.adminService.setLimits(id, rule.getLimits().toRuleLimits(null));
        }
        if (rule.getLayerDetails() != null && !rule.getAccess().equals("LIMIT")) {
            this.adminService.setDetails(id, rule.getLayerDetails().toLayerDetails(null));
        }
        return String.valueOf(id);
    }

    @RequestMapping(value={"/rules/id/{id}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void update(@PathVariable(value="id") Long id, @RequestBody JaxbRule rule) {
        ShortRule priorityRule;
        if (rule.getPriority() != null && (priorityRule = this.adminService.getRuleByPriority(rule.getPriority().longValue())) != null && !Objects.equals(priorityRule.getId(), id)) {
            this.adminService.shift(rule.getPriority().longValue(), 1L);
        }
        Rule theRule = this.adminService.get(id.longValue());
        this.adminService.update(rule.toRule(theRule));
        if (rule.getLimits() != null) {
            this.adminService.setLimits(id, rule.getLimits().toRuleLimits(theRule.getRuleLimits()));
        }
        if (rule.getLayerDetails() != null) {
            this.adminService.setDetails(id, rule.getLayerDetails().toLayerDetails(theRule.getLayerDetails()));
        }
    }

    @RequestMapping(value={"/rules/id/{id}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearAndUpdate(@PathVariable(value="id") Long id, @RequestBody JaxbRule rule) {
        ShortRule priorityRule;
        if (rule.getPriority() != null && (priorityRule = this.adminService.getRuleByPriority(rule.getPriority().longValue())) != null && !Objects.equals(priorityRule.getId(), id)) {
            this.adminService.shift(rule.getPriority().longValue(), 1L);
        }
        Rule theRule = new Rule();
        theRule.setId(id);
        this.adminService.update(rule.toRule(theRule));
        if (rule.getLimits() != null) {
            this.adminService.setLimits(id, rule.getLimits().toRuleLimits(null));
        } else {
            this.adminService.setLimits(id, null);
        }
        if (rule.getLayerDetails() != null) {
            this.adminService.setDetails(id, rule.getLayerDetails().toLayerDetails(null));
        } else {
            this.adminService.setDetails(id, null);
        }
    }

    @RequestMapping(value={"/rules/id/{id}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void delete(@PathVariable(value="id") Long id) {
        this.adminService.delete(id.longValue());
    }

    protected RuleFilter buildFilter(String userName, Boolean userDefault, String roleName, Boolean groupDefault, Long instanceId, String instanceName, Boolean instanceDefault, String ipAddress, Boolean ipAddressDefault, String date, Boolean dateDefault, String serviceName, Boolean serviceDefault, String requestName, Boolean requestDefault, String subfield, Boolean subfieldDefault, String workspace, Boolean workspaceDefault, String layer, Boolean layerDefault) {
        RuleFilter filter = new RuleFilter(RuleFilter.SpecialFilterType.ANY, true);
        this.setFilter(filter.getUser(), userName, userDefault);
        this.setFilter(filter.getRole(), roleName, groupDefault);
        this.setFilter(filter.getInstance(), instanceId, instanceName, instanceDefault);
        this.setFilter(filter.getSourceAddress(), ipAddress, ipAddressDefault);
        this.setFilter(filter.getDate(), date, dateDefault);
        this.setFilter(filter.getService(), serviceName, serviceDefault);
        this.setFilter(filter.getRequest(), requestName, requestDefault);
        this.setFilter(filter.getSubfield(), subfield, subfieldDefault);
        this.setFilter(filter.getWorkspace(), workspace, workspaceDefault);
        this.setFilter(filter.getLayer(), layer, layerDefault);
        return filter;
    }

    private void setFilter(RuleFilter.IdNameFilter filter, Long id, String name, Boolean includeDefault) {
        if (id != null && name != null) {
            throw new IllegalArgumentException("Id and name can't be both defined (id:" + id + " name:" + name + ")");
        }
        if (id != null) {
            filter.setId(id);
            if (includeDefault != null) {
                filter.setIncludeDefault(includeDefault.booleanValue());
            }
        } else if (name != null) {
            filter.setName(name);
            if (includeDefault != null) {
                filter.setIncludeDefault(includeDefault.booleanValue());
            }
        } else if (includeDefault != null && includeDefault.booleanValue()) {
            filter.setType(RuleFilter.SpecialFilterType.DEFAULT);
        } else {
            filter.setType(RuleFilter.SpecialFilterType.ANY);
        }
    }

    private void setFilter(RuleFilter.TextFilter filter, String name, Boolean includeDefault) {
        if (name != null) {
            filter.setText(name);
            if (includeDefault != null) {
                filter.setIncludeDefault(includeDefault.booleanValue());
            }
        } else if (includeDefault != null && includeDefault.booleanValue()) {
            filter.setType(RuleFilter.SpecialFilterType.DEFAULT);
        } else {
            filter.setType(RuleFilter.SpecialFilterType.ANY);
        }
    }

    @RequestMapping(value={"/rules/move"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    public ResponseEntity<JaxbRuleList> move(@RequestParam(value="targetPriority", required=true) int targetPriority, @RequestParam(value="rulesIds", required=true) String rulesIds) {
        List<Rule> rules = this.findRules(rulesIds);
        if (rules.isEmpty()) {
            return ResponseEntity.ok().build();
        }
        this.adminService.shift((long)targetPriority, (long)rules.size());
        long priority = targetPriority;
        for (Rule rule : rules) {
            rule.setPriority(priority);
            this.adminService.update(rule);
            ++priority;
        }
        return ResponseEntity.ok((Object)new JaxbRuleList(rules));
    }

    private List<Rule> findRules(String rulesIds) {
        return Arrays.stream(rulesIds.split(",")).map(ruleId -> {
            try {
                return Long.parseLong(ruleId);
            }
            catch (NumberFormatException exception) {
                throw new InvalidRulesIds();
            }
        }).map(ruleId -> this.adminService.get(ruleId.longValue())).filter(rule -> rule != null).sorted((ruleA, ruleB) -> Long.compare(ruleA.getPriority(), ruleB.getPriority())).collect(Collectors.toList());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST, reason="Invalid rules ids")
    private class InvalidRulesIds
    extends RuntimeException {
        private static final long serialVersionUID = -5682676569555830473L;

        private InvalidRulesIds() {
        }
    }
}

