/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.geofence.core.model.LayerAttribute;
import org.geoserver.geofence.core.model.LayerDetails;
import org.geoserver.geofence.core.model.RuleLimits;
import org.geoserver.geofence.core.model.enums.AccessType;
import org.geoserver.geofence.core.model.enums.CatalogMode;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.core.model.enums.LayerType;
import org.geoserver.geofence.core.model.enums.SpatialFilterType;
import org.geoserver.geofence.server.web.GeofenceRulesModel;
import org.geoserver.geofence.server.web.GeofenceServerPage;
import org.geoserver.geofence.server.web.LayerAttributeModel;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.platform.exception.GeoServerRuntimException;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleChoiceRenderer;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.springframework.dao.DuplicateKeyException;

public class GeofenceRulePage
extends GeoServerSecuredPage {
    private static final Logger LOGGER = Logging.getLogger(GeofenceRulePage.class);
    private static final long serialVersionUID = 3800195664060319256L;
    final CompoundPropertyModel<RuleFormData> ruleFormModel;
    final Form<RuleFormData> form;
    final TabbedPanel<AbstractTab> tabbedPanel;

    public GeofenceRulePage(ShortRule rule, final GeofenceRulesModel rules) {
        LayerDetails layerDetails;
        RuleFormData ruleFormData = new RuleFormData();
        ruleFormData.rule = rule;
        RuleLimits ruleLimits = rules.getRulesLimits(rule.getId());
        if (ruleLimits != null) {
            ruleFormData.allowedArea = this.getAllowedAreaAsString(ruleLimits.getAllowedArea());
            ruleFormData.catalogMode = ruleLimits.getCatalogMode();
            ruleFormData.spatialFilterType = ruleLimits.getSpatialFilterType();
        }
        if ((layerDetails = rules.getDetails(rule.getId())) != null) {
            ruleFormData.layerDetailsCheck = true;
            ruleFormData.layerDetails.allowedArea = this.getAllowedAreaAsString(layerDetails.getArea());
            ruleFormData.layerDetails.spatialFilterType = layerDetails.getSpatialFilterType();
            ruleFormData.layerDetails.catalogMode = layerDetails.getCatalogMode();
            ruleFormData.layerDetails.cqlFilterRead = layerDetails.getCqlFilterRead();
            ruleFormData.layerDetails.cqlFilterWrite = layerDetails.getCqlFilterWrite();
            ruleFormData.layerDetails.defaultStyle = layerDetails.getDefaultStyle();
            ruleFormData.layerDetails.layerType = layerDetails.getType();
            ruleFormData.layerDetails.allowedStyles.addAll(layerDetails.getAllowedStyles());
            ruleFormData.layerDetails.attributes.addAll(layerDetails.getAttributes());
        }
        this.ruleFormModel = new CompoundPropertyModel((Object)ruleFormData);
        this.form = new Form("form", this.ruleFormModel);
        this.add(new Component[]{this.form});
        ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new AbstractTab((IModel)new ResourceModel("general")){
            private static final long serialVersionUID = 446471321863431295L;

            public Panel getPanel(String panelId) {
                return new GeneralPanel(panelId);
            }
        });
        tabs.add(new AbstractTab((IModel)new ResourceModel("details")){
            private static final long serialVersionUID = 446471321863431295L;

            public Panel getPanel(String panelId) {
                return new LayerDetailsPanel(panelId);
            }
        });
        Component[] componentArray = new Component[1];
        this.tabbedPanel = new TabbedPanel<AbstractTab>("tabs", tabs){
            private static final long serialVersionUID = 2194590643994737914L;

            protected WebMarkupContainer newLink(String linkId, final int index) {
                return new SubmitLink(linkId){
                    private static final long serialVersionUID = 4072507303411443283L;

                    public void onSubmit() {
                        this.setSelectedTab(index);
                    }
                };
            }
        };
        componentArray[0] = this.tabbedPanel;
        this.form.add(componentArray);
        this.form.add(new Component[]{new SubmitLink("save"){
            private static final long serialVersionUID = 3735176778941168701L;

            public void onSubmit() {
                RuleFormData ruleFormData = (RuleFormData)this.getForm().getModelObject();
                try {
                    rules.save(ruleFormData.rule);
                    if (ruleFormData.rule.getAccess().equals((Object)GrantType.LIMIT)) {
                        rules.save(ruleFormData.rule.getId(), GeofenceRulePage.this.parseAllowedArea(ruleFormData.allowedArea), ruleFormData.spatialFilterType, ruleFormData.catalogMode);
                    }
                    if (ruleFormData.layerDetailsCheck) {
                        LayerDetails layerDetails = new LayerDetails();
                        layerDetails.setArea(GeofenceRulePage.this.parseAllowedArea(ruleFormData.layerDetails.allowedArea));
                        layerDetails.setAttributes(new HashSet<LayerAttribute>(ruleFormData.layerDetails.attributes));
                        layerDetails.setAllowedStyles(ruleFormData.layerDetails.allowedStyles);
                        layerDetails.setCatalogMode(ruleFormData.layerDetails.catalogMode);
                        layerDetails.setSpatialFilterType(ruleFormData.layerDetails.spatialFilterType);
                        layerDetails.setCqlFilterRead(ruleFormData.layerDetails.cqlFilterRead);
                        layerDetails.setCqlFilterWrite(ruleFormData.layerDetails.cqlFilterWrite);
                        layerDetails.setDefaultStyle(ruleFormData.layerDetails.defaultStyle);
                        layerDetails.setType(ruleFormData.layerDetails.layerType);
                        rules.save(ruleFormData.rule.getId(), layerDetails);
                    } else {
                        rules.save(ruleFormData.rule.getId(), null);
                    }
                    GeofenceRulePage.this.doReturn(GeofenceServerPage.class);
                }
                catch (DuplicateKeyException e) {
                    this.error((Serializable)((Object)new ResourceModel("GeofenceRulePage.duplicate").getObject()));
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }});
        this.form.add(new Component[]{new BookmarkablePageLink("cancel", GeofenceServerPage.class)});
    }

    private String getAllowedAreaAsString(MultiPolygon multiPolygon) {
        if (multiPolygon == null) {
            return "";
        }
        return "SRID=" + multiPolygon.getSRID() + ";" + multiPolygon.toText();
    }

    private MultiPolygon parseAllowedArea(String allowedArea) {
        Geometry geometry;
        Integer srid;
        if (allowedArea == null || allowedArea.isEmpty()) {
            return null;
        }
        String[] allowedAreaParts = allowedArea.split(";");
        if (allowedAreaParts.length != 2) {
            throw new GeoServerRuntimException(String.format("Invalid allowed area '%s' expecting SRID=<CODE>;<WKT>.", allowedArea));
        }
        try {
            srid = Integer.valueOf(allowedAreaParts[0].split("=")[1]);
            geometry = new WKTReader().read(allowedAreaParts[1]);
        }
        catch (Exception exception) {
            String message = String.format("Error parsing SRID '%s' or WKT geometry '%s' expecting SRID=<CODE>;<WKT>.", allowedAreaParts[0], allowedAreaParts[1]);
            LOGGER.log(Level.WARNING, message, exception);
            throw new GeoServerRuntimException(message, (Throwable)exception);
        }
        MultiPolygon multiPolygon = this.castToMultiPolygon(geometry);
        multiPolygon.setSRID(srid.intValue());
        return multiPolygon;
    }

    private MultiPolygon castToMultiPolygon(Geometry geometry) {
        if (geometry instanceof MultiPolygon) {
            return (MultiPolygon)geometry;
        }
        if (geometry instanceof Polygon) {
            return new MultiPolygon(new Polygon[]{(Polygon)geometry}, new GeometryFactory());
        }
        throw new GeoServerRuntimException(String.format("Invalid geometry of type '%s' expect a Polygon or MultiPolygon.", geometry.getClass().getSimpleName()));
    }

    protected List<String> getWorkspaceNames() {
        TreeSet<String> resultSet = new TreeSet<String>();
        for (WorkspaceInfo ws : this.getCatalog().getFacade().getWorkspaces()) {
            resultSet.add(ws.getName());
        }
        return new ArrayList<String>(resultSet);
    }

    protected List<String> getLayerNames(String workspaceName) {
        ArrayList<String> resultSet = new ArrayList<String>();
        if (workspaceName != null) {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            try (CloseableIterator it = this.getCatalog().getFacade().list(ResourceInfo.class, Predicates.equal((String)"store.workspace.name", (Object)workspaceName), null, null, new SortBy[]{ff.sort("name", SortOrder.ASCENDING)});){
                while (it.hasNext()) {
                    resultSet.add(((ResourceInfo)it.next()).getName());
                }
            }
        }
        return resultSet;
    }

    protected List<String> getLayerGroupNames(String workspaceName) {
        ArrayList<String> resultSet = new ArrayList<String>();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        CatalogFacade facade = this.getCatalog().getFacade();
        SortBy sort = ff.sort("name", SortOrder.ASCENDING);
        Filter wsFilter = workspaceName != null ? Predicates.equal((String)"workspace.name", (Object)workspaceName) : Predicates.isNull((String)"workspace");
        try (CloseableIterator it = facade.list(LayerGroupInfo.class, wsFilter, null, null, new SortBy[]{sort});){
            it.forEachRemaining(lg -> resultSet.add(lg.getName()));
        }
        return resultSet;
    }

    List<String> getLayersAndLayerGroups(String workspace) {
        List<String> layers = this.getLayerNames(workspace);
        List<String> layerGroups = this.getLayerGroupNames(workspace);
        layers.addAll(layerGroups);
        return layers;
    }

    protected List<String> getServiceNames() {
        TreeSet<String> resultSet = new TreeSet<String>();
        for (Service ows : GeoServerExtensions.extensions(Service.class)) {
            resultSet.add(ows.getId().toUpperCase());
        }
        return new ArrayList<String>(resultSet);
    }

    protected List<String> getOperationNames(String serviceName) {
        TreeSet resultSet = new TreeSet();
        boolean flag = true;
        if (serviceName != null) {
            for (Service ows : GeoServerExtensions.extensions(Service.class)) {
                if (!serviceName.equalsIgnoreCase(ows.getId()) || !flag) continue;
                flag = false;
                resultSet.addAll(ows.getOperations());
            }
        }
        return new ArrayList<String>(resultSet);
    }

    protected List<String> getRoleNames() {
        TreeSet<String> resultSet = new TreeSet<String>();
        try {
            for (GeoServerRole role : this.securityManager().getRolesForAccessControl()) {
                resultSet.add(role.getAuthority());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return new ArrayList<String>(resultSet);
    }

    protected List<String> getUserNames(String roleName) {
        TreeSet<String> resultSet = new TreeSet<String>();
        GeoServerSecurityManager securityManager = this.securityManager();
        try {
            if (roleName == null) {
                for (String serviceName : securityManager.listUserGroupServices()) {
                    for (GeoServerUser user : securityManager.loadUserGroupService(serviceName).getUsers()) {
                        resultSet.add(user.getUsername());
                    }
                }
            } else {
                for (String serviceName : securityManager.listRoleServices()) {
                    GeoServerRoleService roleService = securityManager.loadRoleService(serviceName);
                    GeoServerRole role = roleService.getRoleByName(roleName);
                    if (role == null) continue;
                    resultSet.addAll(roleService.getUserNamesForRole(role));
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        return new ArrayList<String>(resultSet);
    }

    protected GeoServerSecurityManager securityManager() {
        return GeoServerApplication.get().getSecurityManager();
    }

    LayerType setLayerType(PublishedInfo info, LayerDetailsFormData layerDetails) {
        switch (info.getType()) {
            case VECTOR: 
            case REMOTE: {
                layerDetails.layerType = LayerType.VECTOR;
                break;
            }
            case RASTER: 
            case WMS: 
            case WMTS: {
                layerDetails.layerType = LayerType.RASTER;
                break;
            }
            case GROUP: {
                layerDetails.layerType = LayerType.LAYERGROUP;
            }
        }
        return layerDetails.layerType;
    }

    private boolean isFilterAndStylesEnabled(LayerDetailsFormData detailsFormData) {
        if (detailsFormData == null) {
            return false;
        }
        return this.isFilterAndStylesEnabled(detailsFormData.layerType);
    }

    private boolean isFilterAndStylesEnabled(LayerType layerType) {
        return layerType != null && !layerType.equals((Object)LayerType.LAYERGROUP);
    }

    private boolean isRasterType(LayerDetailsFormData detailsFormData) {
        if (detailsFormData == null) {
            return false;
        }
        return this.isRasterType(detailsFormData.layerType);
    }

    private boolean isRasterType(LayerType layerType) {
        return layerType != null && layerType.equals((Object)LayerType.RASTER);
    }

    private ArrayList<String> getStyles() {
        ArrayList<String> styleNames = new ArrayList<String>();
        for (StyleInfo si : this.getCatalog().getStyles()) {
            styleNames.add(si.getName());
        }
        return styleNames;
    }

    protected class DropDownChoiceWrapperPanel<T>
    extends Panel {
        private static final long serialVersionUID = 5677425055959281304L;

        public DropDownChoiceWrapperPanel(String id, IModel<T> model, List<? extends T> list, ChoiceRenderer<T> renderer) {
            super(id, model);
            this.add(new Component[]{new DropDownChoice("innerComponent", model, list, renderer).setRequired(true)});
        }
    }

    protected class CaseConversionRenderer
    extends ChoiceRenderer<String> {
        private static final long serialVersionUID = 4238195087731806209L;

        protected CaseConversionRenderer() {
        }

        public Object getDisplayValue(String object) {
            return object;
        }

        public String getIdValue(String object, int index) {
            return object.toUpperCase();
        }
    }

    protected class CatalogModeRenderer
    extends ChoiceRenderer<CatalogMode> {
        private static final long serialVersionUID = -7478943956804313995L;

        protected CatalogModeRenderer() {
        }

        public Object getDisplayValue(CatalogMode object) {
            return new ParamResourceModel(object.name(), (Component)GeofenceRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(CatalogMode object, int index) {
            return object.name();
        }
    }

    protected class SpatialFilterTypeRendered
    extends ChoiceRenderer<SpatialFilterType> {
        private static final long serialVersionUID = -7478943956804313995L;

        protected SpatialFilterTypeRendered() {
        }

        public Object getDisplayValue(SpatialFilterType object) {
            return new ParamResourceModel(object.name(), (Component)GeofenceRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(CatalogMode object, int index) {
            return object.name();
        }
    }

    protected class AccessTypeRenderer
    extends ChoiceRenderer<AccessType> {
        private static final long serialVersionUID = -7478943956804313995L;

        protected AccessTypeRenderer() {
        }

        public Object getDisplayValue(AccessType object) {
            return new ParamResourceModel(object.name(), (Component)GeofenceRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(AccessType object, int index) {
            return object.name();
        }
    }

    protected class GrantTypeRenderer
    extends ChoiceRenderer<GrantType> {
        private static final long serialVersionUID = -7478943956804313995L;

        protected GrantTypeRenderer() {
        }

        public Object getDisplayValue(GrantType object) {
            return new ParamResourceModel(object.name(), (Component)GeofenceRulePage.this.getPage(), new Object[0]).getObject();
        }

        public String getIdValue(GrantType object, int index) {
            return object.name();
        }
    }

    protected class LayerDetailsPanel
    extends Panel {
        private static final long serialVersionUID = 2996490022169801394L;

        public LayerDetailsPanel(String id) {
            super(id);
            final CheckBox layerDetailsCheck = new CheckBox("layerDetailsCheck", GeofenceRulePage.this.ruleFormModel.bind("layerDetailsCheck"));
            layerDetailsCheck.setOutputMarkupId(true);
            layerDetailsCheck.setEnabled(((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).rule.getLayer() != null && ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).rule.getAccess().equals((Object)GrantType.ALLOW));
            this.add(new Component[]{layerDetailsCheck});
            final WebMarkupContainer container = new WebMarkupContainer("layerDetailsContainer");
            this.add(new Component[]{container});
            container.setVisible(((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetailsCheck);
            container.setOutputMarkupId(true);
            container.setOutputMarkupPlaceholderTag(true);
            layerDetailsCheck.add(new Behavior[]{new OnChangeAjaxBehavior(){
                private static final long serialVersionUID = 8280700310745922486L;

                protected void onUpdate(AjaxRequestTarget target) {
                    container.setVisible(((Boolean)layerDetailsCheck.getConvertedInput()).booleanValue());
                    target.add(new Component[]{container});
                    RuleFormData rule = (RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject();
                    if (((Boolean)layerDetailsCheck.getConvertedInput()).booleanValue()) {
                        Filter layerFilter = Predicates.equal((String)"name", (Object)rule.rule.getLayer());
                        PublishedInfo info = (PublishedInfo)GeofenceRulePage.this.getCatalog().get(PublishedInfo.class, layerFilter);
                        LayerDetailsFormData layerDetailsFormData = rule.layerDetails;
                        LayerType layerType = layerDetailsFormData.layerType;
                        if (layerType == null) {
                            layerType = GeofenceRulePage.this.setLayerType(info, rule.layerDetails);
                        }
                        boolean enableFiltersAndStyles = GeofenceRulePage.this.isFilterAndStylesEnabled(layerType);
                        Component readFilter = container.get("cqlFilterRead");
                        readFilter.setEnabled(enableFiltersAndStyles);
                        Component writeFilter = container.get("cqlFilterWrite");
                        writeFilter.setEnabled(enableFiltersAndStyles);
                        Component defaultStyles = container.get("defaultStyle");
                        defaultStyles.setEnabled(enableFiltersAndStyles);
                        Component allowedStyles = container.get("allowedStyles");
                        allowedStyles.setEnabled(enableFiltersAndStyles);
                        boolean isRaster = GeofenceRulePage.this.isRasterType(layerType);
                        DropDownChoice spatialFilterType = (DropDownChoice)container.get("spatialFilterType");
                        if (isRaster) {
                            spatialFilterType.setModelObject((Object)SpatialFilterType.CLIP);
                            spatialFilterType.setEnabled(false);
                        } else {
                            spatialFilterType.setEnabled(true);
                            spatialFilterType.setModelObject((Object)SpatialFilterType.INTERSECT);
                        }
                        target.add(new Component[]{readFilter, writeFilter, defaultStyles, allowedStyles, spatialFilterType});
                    }
                }
            }});
            Label layerTypeLabel = new Label("layerType", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.layerType"));
            container.add(new Component[]{layerTypeLabel});
            LayerDetailsFormData layerDetailsFormData = GeofenceRulePage.this.ruleFormModel.getObject() != null ? ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetails : null;
            boolean enableFilterAndStyles = GeofenceRulePage.this.isFilterAndStylesEnabled(layerDetailsFormData);
            DropDownChoice defaultStyle = new DropDownChoice("defaultStyle", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.defaultStyle"), GeofenceRulePage.this.getStyles());
            defaultStyle.setOutputMarkupId(true);
            defaultStyle.setEnabled(enableFilterAndStyles);
            container.add(new Component[]{defaultStyle});
            Palette<String> allowedStyles = new Palette<String>("allowedStyles", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.allowedStyles"), (IModel)new Model(GeofenceRulePage.this.getStyles()), (IChoiceRenderer)new SimpleChoiceRenderer(), 10, false){
                private static final long serialVersionUID = 4843969600809421536L;

                public Component newSelectedHeader(String componentId) {
                    return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.selectedHeader"));
                }

                public Component newAvailableHeader(String componentId) {
                    return new Label(componentId, (IModel)new ResourceModel("ExtraStylesPalette.availableHeader"));
                }
            };
            allowedStyles.setOutputMarkupId(true);
            allowedStyles.setEnabled(enableFilterAndStyles);
            container.add(new Component[]{allowedStyles});
            allowedStyles.add(new Behavior[]{new DefaultTheme()});
            TextArea cqlFilterRead = new TextArea("cqlFilterRead", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.cqlFilterRead"));
            cqlFilterRead.setOutputMarkupId(true);
            cqlFilterRead.setEnabled(enableFilterAndStyles);
            container.add(new Component[]{cqlFilterRead});
            TextArea cqlFilterWrite = new TextArea("cqlFilterWrite", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.cqlFilterWrite"));
            cqlFilterWrite.setOutputMarkupId(true);
            cqlFilterWrite.setEnabled(enableFilterAndStyles);
            container.add(new Component[]{cqlFilterWrite});
            TextArea allowedArea = new TextArea("allowedArea", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.allowedArea"));
            container.add(new Component[]{allowedArea});
            DropDownChoice spatialFilterTypeChoice = new DropDownChoice("spatialFilterType", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.spatialFilterType"), Arrays.asList(SpatialFilterType.values()), (IChoiceRenderer)new SpatialFilterTypeRendered());
            boolean isRaster = GeofenceRulePage.this.isRasterType(layerDetailsFormData);
            if (isRaster) {
                spatialFilterTypeChoice.setModelObject((Object)SpatialFilterType.CLIP);
                spatialFilterTypeChoice.setEnabled(false);
            } else {
                spatialFilterTypeChoice.setEnabled(true);
            }
            spatialFilterTypeChoice.setOutputMarkupId(true);
            spatialFilterTypeChoice.setOutputMarkupPlaceholderTag(true);
            container.add(new Component[]{spatialFilterTypeChoice});
            container.add(new Component[]{new DropDownChoice("catalogMode", GeofenceRulePage.this.ruleFormModel.bind("layerDetails.catalogMode"), Arrays.asList(CatalogMode.values()), (IChoiceRenderer)new CatalogModeRenderer())});
            Label layerAttsLabel = new Label("layerAttributesLabel", (IModel)new ResourceModel("layerAttributes", "Layer Attributes"));
            container.add(new Component[]{layerAttsLabel});
            Component[] componentArray = new Component[1];
            GeoServerTablePanel<LayerAttribute> layerAttsTable = new GeoServerTablePanel<LayerAttribute>("layerAttributes", (GeoServerDataProvider)new LayerAttributeModel(((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetails.attributes), true){
                private static final long serialVersionUID = -2001227609501100452L;

                protected Component getComponentForProperty(String id, IModel<LayerAttribute> itemModel, GeoServerDataProvider.Property<LayerAttribute> property) {
                    if (LayerAttributeModel.ACCESS.equals(property)) {
                        return new DropDownChoiceWrapperPanel<AccessType>(id, property.getModel(itemModel), Arrays.asList(AccessType.values()), new AccessTypeRenderer());
                    }
                    return null;
                }
            };
            componentArray[0] = layerAttsTable;
            container.add(componentArray);
            layerAttsTable.setFilterVisible(false);
            layerAttsTable.setPageable(false);
            layerAttsTable.setSortable(false);
            layerAttsTable.setSelectable(false);
            layerAttsTable.setOutputMarkupId(true);
            layerAttsLabel.setVisible(!((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetails.attributes.isEmpty());
            layerAttsTable.setVisible(!((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetails.attributes.isEmpty());
        }
    }

    protected class GeneralPanel
    extends Panel {
        private static final long serialVersionUID = 8124810941260273620L;
        protected DropDownChoice<String> userChoice;
        protected DropDownChoice<String> roleChoice;
        protected DropDownChoice<String> serviceChoice;
        protected DropDownChoice<String> requestChoice;
        protected DropDownChoice<String> workspaceChoice;
        protected DropDownChoice<String> layerChoice;
        protected DropDownChoice<String> accessChoice;
        protected TextField<String> subfield;
        protected TextField<String> validAfter;
        protected TextField<String> validBefore;
        protected DropDownChoice<GrantType> grantTypeChoice;
        protected DropDownChoice<CatalogMode> catalogModeChoice;
        protected DropDownChoice<SpatialFilterType> spatialFilterTypeChoice;
        protected TextArea<String> allowedArea;
        protected Label allowedAreaLabel;
        protected Label spatialFilterTypeLabel;
        protected Label catalogModeChoiceLabel;

        public GeneralPanel(String id) {
            super(id);
            this.add(new Component[]{new TextField("priority", GeofenceRulePage.this.ruleFormModel.bind("rule.priority")).setRequired(true)});
            Component[] componentArray = new Component[1];
            this.roleChoice = new DropDownChoice("roleName", GeofenceRulePage.this.ruleFormModel.bind("rule.roleName"), GeofenceRulePage.this.getRoleNames());
            componentArray[0] = this.roleChoice;
            this.add(componentArray);
            this.roleChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){
                private static final long serialVersionUID = -2880886409750911044L;

                protected void onUpdate(AjaxRequestTarget target) {
                    GeneralPanel.this.userChoice.setChoices(GeofenceRulePage.this.getUserNames((String)GeneralPanel.this.roleChoice.getConvertedInput()));
                    ((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.setUserName(null);
                    GeneralPanel.this.userChoice.modelChanged();
                    target.add(new Component[]{GeneralPanel.this.userChoice});
                }
            }});
            this.roleChoice.setNullValid(true);
            Component[] componentArray2 = new Component[1];
            this.userChoice = new DropDownChoice("userName", GeofenceRulePage.this.ruleFormModel.bind("rule.userName"), GeofenceRulePage.this.getUserNames(((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).rule.getRoleName()));
            componentArray2[0] = this.userChoice;
            this.add(componentArray2);
            this.userChoice.setOutputMarkupId(true);
            this.userChoice.setNullValid(true);
            Component[] componentArray3 = new Component[1];
            this.serviceChoice = new DropDownChoice("service", GeofenceRulePage.this.ruleFormModel.bind("rule.service"), GeofenceRulePage.this.getServiceNames());
            componentArray3[0] = this.serviceChoice;
            this.add(componentArray3);
            this.serviceChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){
                private static final long serialVersionUID = -5925784823433092831L;

                protected void onUpdate(AjaxRequestTarget target) {
                    GeneralPanel.this.requestChoice.setChoices(GeofenceRulePage.this.getOperationNames((String)GeneralPanel.this.serviceChoice.getConvertedInput()));
                    ((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.setRequest(null);
                    GeneralPanel.this.requestChoice.modelChanged();
                    target.add(new Component[]{GeneralPanel.this.requestChoice});
                }
            }});
            this.serviceChoice.setNullValid(true);
            Component[] componentArray4 = new Component[1];
            this.requestChoice = new DropDownChoice("request", GeofenceRulePage.this.ruleFormModel.bind("rule.request"), GeofenceRulePage.this.getOperationNames(((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).rule.getService()), (IChoiceRenderer)new CaseConversionRenderer());
            componentArray4[0] = this.requestChoice;
            this.add(componentArray4);
            this.requestChoice.setOutputMarkupId(true);
            this.requestChoice.setNullValid(true);
            Component[] componentArray5 = new Component[1];
            this.subfield = new TextField("subfield", GeofenceRulePage.this.ruleFormModel.bind("rule.subfield"));
            componentArray5[0] = this.subfield;
            this.add(componentArray5);
            this.subfield.setOutputMarkupId(true);
            this.subfield.setOutputMarkupPlaceholderTag(true);
            Component[] componentArray6 = new Component[1];
            this.validAfter = new TextField("validAfter", GeofenceRulePage.this.ruleFormModel.bind("rule.validAfter"));
            componentArray6[0] = this.validAfter;
            this.add(componentArray6);
            this.validAfter.setOutputMarkupId(true);
            this.validAfter.setOutputMarkupPlaceholderTag(true);
            Component[] componentArray7 = new Component[1];
            this.validBefore = new TextField("validBefore", GeofenceRulePage.this.ruleFormModel.bind("rule.validBefore"));
            componentArray7[0] = this.validBefore;
            this.add(componentArray7);
            this.validBefore.setOutputMarkupId(true);
            this.validBefore.setOutputMarkupPlaceholderTag(true);
            Component[] componentArray8 = new Component[1];
            this.workspaceChoice = new DropDownChoice("workspace", GeofenceRulePage.this.ruleFormModel.bind("rule.workspace"), GeofenceRulePage.this.getWorkspaceNames());
            componentArray8[0] = this.workspaceChoice;
            this.add(componentArray8);
            this.workspaceChoice.add(new Behavior[]{new OnChangeAjaxBehavior(){
                private static final long serialVersionUID = 732177308220189475L;

                protected void onUpdate(AjaxRequestTarget target) {
                    GeneralPanel.this.layerChoice.setChoices(GeofenceRulePage.this.getLayersAndLayerGroups((String)GeneralPanel.this.workspaceChoice.getConvertedInput()));
                    ((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.setLayer(null);
                    GeneralPanel.this.layerChoice.modelChanged();
                    target.add(new Component[]{GeneralPanel.this.layerChoice});
                }
            }});
            this.workspaceChoice.setNullValid(true);
            Component[] componentArray9 = new Component[1];
            this.layerChoice = new DropDownChoice("layer", GeofenceRulePage.this.ruleFormModel.bind("rule.layer"), GeofenceRulePage.this.getLayersAndLayerGroups(((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).rule.getWorkspace()));
            componentArray9[0] = this.layerChoice;
            this.add(componentArray9);
            this.layerChoice.setOutputMarkupId(true);
            this.layerChoice.setNullValid(true);
            this.layerChoice.add(new Behavior[]{new LayerChoiceOnChange()});
            this.add(new Component[]{new TextField("addressRange", GeofenceRulePage.this.ruleFormModel.bind("rule.addressRange"))});
            Component[] componentArray10 = new Component[1];
            this.grantTypeChoice = new DropDownChoice("access", GeofenceRulePage.this.ruleFormModel.bind("rule.access"), Arrays.asList(GrantType.values()), (IChoiceRenderer)new GrantTypeRenderer());
            componentArray10[0] = this.grantTypeChoice;
            this.add(componentArray10);
            this.grantTypeChoice.setRequired(true);
            this.grantTypeChoice.add(new Behavior[]{new GrantTypeOnChange()});
            boolean isLimit = ((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.getAccess() != null && ((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.getAccess().equals((Object)GrantType.LIMIT);
            Component[] componentArray11 = new Component[1];
            this.allowedAreaLabel = new Label("allowedAreaLabel", (IModel)new ResourceModel("allowedArea", "Allow area"));
            componentArray11[0] = this.allowedAreaLabel;
            this.add(componentArray11);
            this.allowedAreaLabel.setVisible(isLimit);
            this.allowedAreaLabel.setOutputMarkupId(true);
            this.allowedAreaLabel.setOutputMarkupPlaceholderTag(true);
            Component[] componentArray12 = new Component[1];
            this.allowedArea = new TextArea("allowedArea", GeofenceRulePage.this.ruleFormModel.bind("allowedArea"));
            componentArray12[0] = this.allowedArea;
            this.add(componentArray12);
            this.allowedArea.setVisible(isLimit);
            this.allowedArea.setOutputMarkupId(true);
            this.allowedArea.setOutputMarkupPlaceholderTag(true);
            this.spatialFilterTypeLabel = new Label("spatialFilterTypeLabel", (IModel)new ResourceModel("spatialFilterType", "Spatial Filter Type"));
            this.spatialFilterTypeLabel.setVisible(isLimit);
            this.spatialFilterTypeLabel.setOutputMarkupId(true);
            this.spatialFilterTypeLabel.setOutputMarkupPlaceholderTag(true);
            this.spatialFilterTypeChoice = new DropDownChoice("spatialFilterType", GeofenceRulePage.this.ruleFormModel.bind("spatialFilterType"), Arrays.asList(SpatialFilterType.values()), (IChoiceRenderer)new SpatialFilterTypeRendered());
            this.spatialFilterTypeChoice.setVisible(isLimit);
            this.spatialFilterTypeChoice.setOutputMarkupId(true);
            this.spatialFilterTypeChoice.setOutputMarkupPlaceholderTag(true);
            this.add(new Component[]{this.spatialFilterTypeLabel});
            this.add(new Component[]{this.spatialFilterTypeChoice});
            Component[] componentArray13 = new Component[1];
            this.catalogModeChoiceLabel = new Label("catalogModeLabel", (IModel)new ResourceModel("catalogMode", "Catalog Mode"));
            componentArray13[0] = this.catalogModeChoiceLabel;
            this.add(componentArray13);
            this.catalogModeChoiceLabel.setVisible(((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.getAccess() != null && ((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.getAccess().equals((Object)GrantType.LIMIT));
            this.catalogModeChoiceLabel.setOutputMarkupId(true);
            this.catalogModeChoiceLabel.setOutputMarkupPlaceholderTag(true);
            Component[] componentArray14 = new Component[1];
            this.catalogModeChoice = new DropDownChoice("catalogMode", GeofenceRulePage.this.ruleFormModel.bind("catalogMode"), Arrays.asList(CatalogMode.values()), (IChoiceRenderer)new CatalogModeRenderer());
            componentArray14[0] = this.catalogModeChoice;
            this.add(componentArray14);
            this.catalogModeChoice.setVisible(((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.getAccess() != null && ((RuleFormData)GeofenceRulePage.this.form.getModelObject()).rule.getAccess().equals((Object)GrantType.LIMIT));
            this.catalogModeChoice.setOutputMarkupId(true);
            this.catalogModeChoice.setOutputMarkupPlaceholderTag(true);
        }

        private class GrantTypeOnChange
        extends OnChangeAjaxBehavior {
            private static final long serialVersionUID = -4302901248019983282L;

            private GrantTypeOnChange() {
            }

            protected void onUpdate(AjaxRequestTarget target) {
                boolean isLimit = ((GrantType)GeneralPanel.this.grantTypeChoice.getConvertedInput()).equals((Object)GrantType.LIMIT);
                GeneralPanel.this.allowedAreaLabel.setVisible(isLimit);
                GeneralPanel.this.allowedArea.setVisible(isLimit);
                GeneralPanel.this.spatialFilterTypeLabel.setVisible(isLimit);
                GeneralPanel.this.spatialFilterTypeChoice.setVisible(isLimit);
                GeneralPanel.this.catalogModeChoice.setVisible(isLimit);
                GeneralPanel.this.catalogModeChoiceLabel.setVisible(isLimit);
                target.add(new Component[]{GeneralPanel.this.allowedAreaLabel});
                target.add(new Component[]{GeneralPanel.this.allowedArea});
                target.add(new Component[]{GeneralPanel.this.spatialFilterTypeLabel});
                target.add(new Component[]{GeneralPanel.this.spatialFilterTypeChoice});
                target.add(new Component[]{GeneralPanel.this.catalogModeChoice});
                target.add(new Component[]{GeneralPanel.this.catalogModeChoiceLabel});
                ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetailsCheck = ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetailsCheck && GeneralPanel.this.grantTypeChoice.getConvertedInput() != null && ((GrantType)GeneralPanel.this.grantTypeChoice.getConvertedInput()).equals((Object)GrantType.ALLOW) && GeneralPanel.this.layerChoice.getConvertedInput() != null && !((String)GeneralPanel.this.layerChoice.getConvertedInput()).isEmpty();
            }
        }

        private class LayerChoiceOnChange
        extends OnChangeAjaxBehavior {
            private static final long serialVersionUID = 8434775615039939193L;

            private LayerChoiceOnChange() {
            }

            protected void onUpdate(AjaxRequestTarget target) {
                ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetailsCheck = ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetailsCheck && GrantType.ALLOW.equals(GeneralPanel.this.grantTypeChoice.getConvertedInput()) && GeneralPanel.this.layerChoice.getConvertedInput() != null;
                ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetails.attributes.clear();
                if (GeneralPanel.this.layerChoice.getConvertedInput() != null) {
                    ResourceInfo resource;
                    PublishedInfo info = (PublishedInfo)GeofenceRulePage.this.getCatalog().get(PublishedInfo.class, Predicates.equal((String)"name", (Object)GeneralPanel.this.layerChoice.getConvertedInput()));
                    LayerDetailsFormData layerDetails = ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetails;
                    LayerType layerType = GeofenceRulePage.this.setLayerType(info, layerDetails);
                    ResourceInfo resourceInfo = resource = info instanceof LayerInfo ? ((LayerInfo)info).getResource() : null;
                    if (layerType != null && layerType.equals((Object)LayerType.RASTER)) {
                        GeneralPanel.this.spatialFilterTypeChoice.setModelObject((Object)SpatialFilterType.CLIP);
                        GeneralPanel.this.spatialFilterTypeChoice.setEnabled(false);
                    } else {
                        GeneralPanel.this.spatialFilterTypeChoice.setEnabled(true);
                    }
                    target.add(new Component[]{GeneralPanel.this.spatialFilterTypeLabel, GeneralPanel.this.spatialFilterTypeChoice});
                    if (resource instanceof FeatureTypeInfo) {
                        FeatureTypeInfo fti = (FeatureTypeInfo)resource;
                        try {
                            for (AttributeTypeInfo ati : fti.attributes()) {
                                LayerAttribute attribute = new LayerAttribute(ati.getName(), ati.getBinding() == null ? null : ati.getBinding().getName(), AccessType.NONE);
                                ((RuleFormData)GeofenceRulePage.this.ruleFormModel.getObject()).layerDetails.attributes.add(attribute);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Could not fetch attributes.", e);
                        }
                    }
                }
            }
        }
    }

    private class RuleFormData
    implements Serializable {
        private static final long serialVersionUID = 3800199348340468123L;
        ShortRule rule;
        String allowedArea;
        SpatialFilterType spatialFilterType;
        CatalogMode catalogMode;
        boolean layerDetailsCheck;
        LayerDetailsFormData layerDetails;

        private RuleFormData() {
            this.layerDetails = new LayerDetailsFormData();
        }
    }

    private class LayerDetailsFormData
    implements Serializable {
        private static final long serialVersionUID = 3800199348340468123L;
        LayerType layerType;
        String defaultStyle;
        String cqlFilterRead;
        String cqlFilterWrite;
        String allowedArea;
        CatalogMode catalogMode;
        SpatialFilterType spatialFilterType;
        Set<String> allowedStyles = new HashSet<String>();
        List<LayerAttribute> attributes = new ArrayList<LayerAttribute>();

        private LayerDetailsFormData() {
        }
    }
}

