/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.web;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.geoserver.geofence.server.web.GeofenceAdminRulePage;
import org.geoserver.geofence.server.web.GeofenceAdminRulesModel;
import org.geoserver.geofence.services.dto.ShortAdminRule;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDNDBehavior;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ImageAjaxLink;
import org.geoserver.web.wicket.ParamResourceModel;
import wicketdnd.DragSource;
import wicketdnd.DropTarget;
import wicketdnd.Location;
import wicketdnd.Operation;
import wicketdnd.Transfer;
import wicketdnd.theme.WebTheme;

public class GeofenceServerAdminPage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = -4321944040817919546L;
    private GeofenceAdminRulesModel rulesModel;
    private GeoServerTablePanel<ShortAdminRule> rulesPanel;
    private AjaxLink<Object> remove;

    public GeofenceServerAdminPage() {
        this.add(new Component[]{new AjaxLink<Object>("addNew"){
            private static final long serialVersionUID = -4136656891019857299L;

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((IRequestablePage)new GeofenceAdminRulePage(GeofenceServerAdminPage.this.rulesModel.newRule(), GeofenceServerAdminPage.this.rulesModel));
            }
        }});
        Component[] componentArray = new Component[1];
        this.remove = new AjaxLink<Object>("removeSelected"){
            private static final long serialVersionUID = 2421854498051377608L;

            public void onClick(AjaxRequestTarget target) {
                GeofenceServerAdminPage.this.rulesModel.remove(GeofenceServerAdminPage.this.rulesPanel.getSelection());
                target.add(new Component[]{GeofenceServerAdminPage.this.rulesPanel});
            }
        };
        componentArray[0] = this.remove;
        this.add(componentArray);
        this.remove.setOutputMarkupId(true);
        this.remove.setEnabled(false);
        Component[] componentArray2 = new Component[1];
        this.rulesModel = new GeofenceAdminRulesModel();
        this.rulesPanel = new GeoServerTablePanel<ShortAdminRule>("rulesPanel", (GeoServerDataProvider)this.rulesModel, true){
            private static final long serialVersionUID = -9041215145551707243L;

            protected Component getComponentForProperty(String id, IModel<ShortAdminRule> itemModel, GeoServerDataProvider.Property<ShortAdminRule> property) {
                if (property == GeofenceAdminRulesModel.BUTTONS) {
                    return new ButtonPanel(id, (ShortAdminRule)itemModel.getObject());
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                GeofenceServerAdminPage.this.remove.setEnabled(!GeofenceServerAdminPage.this.rulesPanel.getSelection().isEmpty());
                target.add(new Component[]{GeofenceServerAdminPage.this.remove});
            }
        };
        componentArray2[0] = this.rulesPanel;
        this.add(componentArray2);
        this.rulesPanel.add(new Behavior[]{new WebTheme()});
        this.rulesPanel.add(new Behavior[]{new DragSource(new Operation[]{Operation.MOVE}).drag("tr")});
        this.rulesPanel.add(new Behavior[]{new DropTarget(new Operation[]{Operation.MOVE}){
            private static final long serialVersionUID = -2153630274380471165L;

            public void onDrop(AjaxRequestTarget target, Transfer transfer, Location location) {
                if (location == null || !(location.getComponent().getDefaultModel().getObject() instanceof ShortAdminRule)) {
                    return;
                }
                ShortAdminRule movedRule = (ShortAdminRule)transfer.getData();
                ShortAdminRule targetRule = (ShortAdminRule)location.getComponent().getDefaultModel().getObject();
                if (movedRule.getId().equals(targetRule.getId())) {
                    return;
                }
                if (movedRule.getPriority() < targetRule.getPriority()) {
                    movedRule.setPriority(targetRule.getPriority() + 1L);
                } else {
                    movedRule.setPriority(targetRule.getPriority());
                }
                GeofenceServerAdminPage.this.rulesModel.save(movedRule);
                GeofenceServerAdminPage.this.doReturn(GeofenceServerAdminPage.class);
            }
        }.dropCenter("tr")});
        this.rulesPanel.add(new Behavior[]{new GeoServerDNDBehavior()});
        this.rulesPanel.setOutputMarkupId(true);
    }

    private class ButtonPanel
    extends Panel {
        private static final long serialVersionUID = -3702358364804495550L;
        private ImageAjaxLink<Object> upLink;
        private ImageAjaxLink<Object> downLink;

        public ButtonPanel(String id, final ShortAdminRule rule) {
            super(id);
            this.setOutputMarkupId(true);
            this.upLink = new ImageAjaxLink<Object>("up", new PackageResourceReference(((Object)((Object)this)).getClass(), "img/arrow_up.png")){
                private static final long serialVersionUID = -8179503447106596760L;

                protected void onClick(AjaxRequestTarget target) {
                    GeofenceServerAdminPage.this.rulesModel.moveUp(rule);
                    target.add(new Component[]{GeofenceServerAdminPage.this.rulesPanel});
                }

                protected void onComponentTag(ComponentTag tag) {
                    if (GeofenceServerAdminPage.this.rulesModel.canUp(rule)) {
                        tag.put("class", (CharSequence)"visibility-visible");
                    } else {
                        tag.put("class", (CharSequence)"visibility-hidden");
                    }
                }
            };
            this.upLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("GeofenceServerAdminPage.up", this.upLink, new Object[0]))});
            this.upLink.setOutputMarkupId(true);
            this.add(new Component[]{this.upLink});
            this.downLink = new ImageAjaxLink<Object>("down", new PackageResourceReference(((Object)((Object)this)).getClass(), "img/arrow_down.png")){
                private static final long serialVersionUID = 4640187752303674221L;

                protected void onClick(AjaxRequestTarget target) {
                    GeofenceServerAdminPage.this.rulesModel.moveDown(rule);
                    target.add(new Component[]{GeofenceServerAdminPage.this.rulesPanel});
                }

                protected void onComponentTag(ComponentTag tag) {
                    if (GeofenceServerAdminPage.this.rulesModel.canDown(rule)) {
                        tag.put("class", (CharSequence)"visibility-visible");
                    } else {
                        tag.put("class", (CharSequence)"visibility-hidden");
                    }
                }
            };
            this.downLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("GeofenceServerAdminPage.down", this.downLink, new Object[0]))});
            this.downLink.setOutputMarkupId(true);
            this.add(new Component[]{this.downLink});
            ImageAjaxLink<Object> editLink = new ImageAjaxLink<Object>("edit", new PackageResourceReference(((Object)((Object)this)).getClass(), "img/edit.png")){
                private static final long serialVersionUID = 4640187752303674221L;

                protected void onClick(AjaxRequestTarget target) {
                    this.setResponsePage((IRequestablePage)new GeofenceAdminRulePage(rule, GeofenceServerAdminPage.this.rulesModel));
                }
            };
            editLink.getImage().add(new Behavior[]{new AttributeModifier("alt", (IModel)new ParamResourceModel("GeofenceServerAdminPage.edit", (Component)editLink, new Object[0]))});
            editLink.setOutputMarkupId(true);
            this.add(new Component[]{editLink});
        }
    }
}

