/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamPersisterInitializer;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.geofence.core.dao.DuplicateKeyException;
import org.geoserver.geofence.core.model.IPAddressRange;
import org.geoserver.geofence.core.model.LayerAttribute;
import org.geoserver.geofence.core.model.Rule;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.server.rest.RulesRestController;
import org.geoserver.geofence.server.rest.xml.JaxbRule;
import org.geoserver.geofence.server.rest.xml.JaxbRuleList;
import org.geoserver.geofence.server.xstream.GeoFenceServerXStreamInitializer;
import org.geoserver.geofence.services.RuleAdminService;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geoserver.geofence.services.exception.NotFoundServiceEx;
import org.geotools.gml3.bindings.GML3MockData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletResponse;

public class RulesRestControllerTest
extends GeofenceBaseTest {
    protected RulesRestController controller;
    protected RuleAdminService adminService;

    @Before
    public void initGeoFenceControllers() {
        this.controller = (RulesRestController)applicationContext.getBean("rulesRestController");
        this.adminService = (RuleAdminService)applicationContext.getBean("ruleAdminService");
    }

    @Test
    public void testInsertUpdateDelete() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(5L));
        rule.setUserName("pippo");
        rule.setRoleName("clown");
        rule.setAddressRange("127.0.0.1/32");
        rule.setService("wfs");
        rule.setRequest("getFeature");
        rule.setSubfield("subfield");
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("ALLOW");
        long id = this.prepareGeoFenceTestRules(rule);
        Rule realRule = this.adminService.get(id);
        Assert.assertEquals((long)rule.getPriority(), (long)realRule.getPriority());
        Assert.assertEquals((Object)rule.getUserName(), (Object)realRule.getUsername());
        Assert.assertEquals((Object)rule.getRoleName(), (Object)realRule.getRolename());
        Assert.assertEquals((Object)rule.getAddressRange(), (Object)realRule.getAddressRange().getCidrSignature());
        Assert.assertEquals((Object)rule.getService().toUpperCase(), (Object)realRule.getService().toUpperCase());
        Assert.assertEquals((Object)rule.getRequest().toUpperCase(), (Object)realRule.getRequest().toUpperCase());
        Assert.assertEquals((Object)rule.getSubfield().toUpperCase(), (Object)realRule.getSubfield().toUpperCase());
        Assert.assertEquals((Object)rule.getWorkspace(), (Object)realRule.getWorkspace());
        Assert.assertEquals((Object)rule.getLayer(), (Object)realRule.getLayer());
        Assert.assertEquals((Object)rule.getAccess(), (Object)realRule.getAccess().toString());
        JaxbRule ruleMods = new JaxbRule();
        ruleMods.setRoleName("acrobaat");
        this.controller.update(Long.valueOf(id), ruleMods);
        realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getUserName(), (Object)realRule.getUsername());
        Assert.assertEquals((Object)ruleMods.getRoleName(), (Object)realRule.getRolename());
        JaxbRule rule2 = new JaxbRule();
        rule2.setPriority(Long.valueOf(5L));
        rule2.setAccess("DENY");
        long id2 = Long.parseLong(this.controller.insert(rule2));
        realRule = this.adminService.get(id);
        Assert.assertEquals((long)6L, (long)realRule.getPriority());
        JaxbRule rule2Mods = new JaxbRule();
        rule2Mods.setPriority(Long.valueOf(3L));
        this.controller.update(Long.valueOf(id2), rule2Mods);
        realRule = this.adminService.get(id2);
        Assert.assertEquals((long)3L, (long)realRule.getPriority());
        rule2Mods = new JaxbRule();
        rule2Mods.setPriority(Long.valueOf(6L));
        this.controller.update(Long.valueOf(id2), rule2Mods);
        realRule = this.adminService.get(id2);
        Assert.assertEquals((long)6L, (long)realRule.getPriority());
        realRule = this.adminService.get(id);
        Assert.assertEquals((long)7L, (long)realRule.getPriority());
        this.controller.delete(Long.valueOf(id));
        boolean notfound = false;
        try {
            this.adminService.get(id);
        }
        catch (NotFoundServiceEx e) {
            notfound = true;
        }
        Assert.assertTrue((boolean)notfound);
        boolean conflict = false;
        try {
            this.controller.insert(rule2);
        }
        catch (DuplicateKeyException e) {
            conflict = true;
        }
        Assert.assertTrue((boolean)conflict);
    }

    @Test
    public void testLimits() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(5L));
        rule.setUserName("pippo");
        rule.setRoleName("clown");
        rule.setAddressRange("127.0.0.1/32");
        rule.setService("wfs");
        rule.setRequest("getFeature");
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("LIMIT");
        rule.setLimits(new JaxbRule.Limits());
        rule.getLimits().setAllowedArea(GML3MockData.multiPolygon());
        rule.getLimits().setCatalogMode("MIXED");
        long id = this.prepareGeoFenceTestRules(rule);
        Rule realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getLimits().getCatalogMode(), (Object)realRule.getRuleLimits().getCatalogMode().toString());
        try {
            String allowedArea = rule.getLimits().getAllowedArea();
            Geometry multiPolygon = new WKTReader().read(allowedArea.split(";")[1]);
            multiPolygon.setSRID(4326);
            Assert.assertEquals((Object)multiPolygon, (Object)realRule.getRuleLimits().getAllowedArea());
        }
        catch (ParseException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        rule.getLimits().setCatalogMode("HIDE");
        this.controller.update(Long.valueOf(id), rule);
        realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getLimits().getCatalogMode(), (Object)realRule.getRuleLimits().getCatalogMode().toString());
        rule.setLimits(null);
        this.controller.clearAndUpdate(Long.valueOf(id), rule);
        realRule = this.adminService.get(id);
        Assert.assertNull((Object)realRule.getRuleLimits());
    }

    @Test
    public void testLayerDetails() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(5L));
        rule.setUserName("pippo");
        rule.setRoleName("clown");
        rule.setAddressRange("127.0.0.1/32");
        rule.setService("wfs");
        rule.setRequest("getFeature");
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("ALLOW");
        rule.setLayerDetails(new JaxbRule.LayerDetails());
        rule.getLayerDetails().setAllowedArea(GML3MockData.multiPolygon());
        rule.getLayerDetails().getAllowedStyles().add("style1");
        rule.getLayerDetails().getAllowedStyles().add("style2");
        JaxbRule.LayerAttribute att = new JaxbRule.LayerAttribute();
        att.setName("layerAttribute1");
        att.setAccessType("READONLY");
        att.setDataType("dataType");
        rule.getLayerDetails().getAttributes().add(att);
        att = new JaxbRule.LayerAttribute();
        att.setName("layerAttribute2");
        att.setAccessType("READONLY");
        att.setDataType("dataType2");
        rule.getLayerDetails().getAttributes().add(att);
        rule.getLayerDetails().setCatalogMode("MIXED");
        rule.getLayerDetails().setCqlFilterRead("myFilterRead");
        rule.getLayerDetails().setCqlFilterWrite("myFilterWrite");
        rule.getLayerDetails().setDefaultStyle("myDefaultStyle");
        rule.getLayerDetails().setLayerType("VECTOR");
        long id = this.prepareGeoFenceTestRules(rule);
        Rule realRule = this.adminService.get(id);
        try {
            String allowedArea = rule.getLayerDetails().getAllowedArea();
            Geometry multiPolygon = new WKTReader().read(allowedArea.split(";")[1]);
            multiPolygon.setSRID(4326);
            Assert.assertEquals((Object)multiPolygon, (Object)realRule.getLayerDetails().getArea());
        }
        catch (ParseException e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        Assert.assertEquals((Object)rule.getLayerDetails().getCatalogMode(), (Object)realRule.getLayerDetails().getCatalogMode().toString());
        Assert.assertEquals((Object)rule.getLayerDetails().getAllowedStyles(), (Object)realRule.getLayerDetails().getAllowedStyles());
        Assert.assertEquals((long)2L, (long)realRule.getLayerDetails().getAttributes().size());
        for (LayerAttribute la : realRule.getLayerDetails().getAttributes()) {
            if (!la.getName().equals("layerAttribute2")) continue;
            Assert.assertEquals((Object)"READONLY", (Object)la.getAccess().toString());
        }
        Assert.assertEquals((Object)rule.getLayerDetails().getCqlFilterRead(), (Object)realRule.getLayerDetails().getCqlFilterRead());
        Assert.assertEquals((Object)rule.getLayerDetails().getCqlFilterWrite(), (Object)realRule.getLayerDetails().getCqlFilterWrite());
        Assert.assertEquals((Object)rule.getLayerDetails().getDefaultStyle(), (Object)realRule.getLayerDetails().getDefaultStyle());
        Assert.assertEquals((Object)rule.getLayerDetails().getLayerType(), (Object)realRule.getLayerDetails().getType().toString());
        rule.getLayerDetails().setDefaultStyle("myDefaultStyle2");
        rule.getLayerDetails().getAttributes().clear();
        att = new JaxbRule.LayerAttribute();
        att.setName("layerAttribute2");
        att.setAccessType("READWRITE");
        att.setDataType("dataType");
        rule.getLayerDetails().getAttributes().add(att);
        att = new JaxbRule.LayerAttribute();
        att.setName("layerAttribute3");
        att.setAccessType("READWRITE");
        att.setDataType("dataType");
        rule.getLayerDetails().getAttributes().add(att);
        rule.getLayerDetails().getAllowedStyles().clear();
        rule.getLayerDetails().getAllowedStyles().add("style3");
        this.controller.update(Long.valueOf(id), rule);
        realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getLayerDetails().getDefaultStyle(), (Object)realRule.getLayerDetails().getDefaultStyle());
        Assert.assertEquals((long)1L, (long)realRule.getLayerDetails().getAllowedStyles().size());
        Assert.assertEquals((long)2L, (long)realRule.getLayerDetails().getAttributes().size());
        for (LayerAttribute la : realRule.getLayerDetails().getAttributes()) {
            if (!la.getName().equals("layerAttribute2")) continue;
            Assert.assertEquals((Object)"READWRITE", (Object)la.getAccess().toString());
        }
        this.controller.clearAndUpdate(Long.valueOf(id), rule);
        realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getLayerDetails().getAllowedStyles(), (Object)realRule.getLayerDetails().getAllowedStyles());
        Assert.assertEquals((long)2L, (long)realRule.getLayerDetails().getAttributes().size());
    }

    @Test
    public void testMovingRules() {
        String prefix = UUID.randomUUID().toString();
        this.adminService.insert(new Rule(5L, GrantType.ALLOW).setUsername(prefix + "-user5").setRolename(prefix + "-role1"));
        this.adminService.insert(new Rule(2L, GrantType.ALLOW).setUsername(prefix + "-user2").setRolename(prefix + "-role1"));
        this.adminService.insert(new Rule(1L, GrantType.ALLOW).setUsername(prefix + "-user1").setRolename(prefix + "-role1"));
        this.adminService.insert(new Rule(4L, GrantType.ALLOW).setUsername(prefix + "-user4").setRolename(prefix + "-role2"));
        this.adminService.insert(new Rule(3L, GrantType.ALLOW).setUsername(prefix + "-user3").setRolename(prefix + "-role2"));
        this.adminService.insert(new Rule(6L, GrantType.ALLOW).setUsername(prefix + "-user6").setRolename(prefix + "-role6"));
        JaxbRuleList originalRules = this.controller.get(Integer.valueOf(0), Integer.valueOf(6), false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.validateRules(originalRules, prefix, "user1", "user2", "user3", "user4", "user5", "user6");
        this.validateRules(0, prefix, "user1", "user2");
        this.validateRules(0, 1L, 2L);
        this.validateRules(1, prefix, "user3", "user4");
        this.validateRules(1, 3L, 4L);
        this.validateRules(2, prefix, "user5", "user6");
        this.validateRules(2, 5L, 6L);
        ResponseEntity result = this.controller.move(7, ((JaxbRule)originalRules.getRules().get(0)).getId() + "," + ((JaxbRule)originalRules.getRules().get(1)).getId());
        this.validateResult((ResponseEntity<JaxbRuleList>)result, HttpStatus.OK, 2);
        this.validateRules((JaxbRuleList)result.getBody(), prefix, "user1", "user2");
        this.validateRules((JaxbRuleList)result.getBody(), 7L, 8L);
        this.validateRules(0, prefix, "user3", "user4");
        this.validateRules(0, 3L, 4L);
        this.validateRules(1, prefix, "user5", "user6");
        this.validateRules(1, 5L, 6L);
        this.validateRules(2, prefix, "user1", "user2");
        this.validateRules(2, 7L, 8L);
        result = this.controller.move(7, ((JaxbRule)originalRules.getRules().get(2)).getId() + "," + ((JaxbRule)originalRules.getRules().get(3)).getId());
        this.validateResult((ResponseEntity<JaxbRuleList>)result, HttpStatus.OK, 2);
        this.validateRules((JaxbRuleList)result.getBody(), prefix, "user3", "user4");
        this.validateRules((JaxbRuleList)result.getBody(), 7L, 8L);
        this.validateRules(0, prefix, "user5", "user6");
        this.validateRules(0, 5L, 6L);
        this.validateRules(1, prefix, "user3", "user4");
        this.validateRules(1, 7L, 8L);
        this.validateRules(2, prefix, "user1", "user2");
        this.validateRules(2, 9L, 10L);
        result = this.controller.move(5, String.valueOf(((JaxbRule)originalRules.getRules().get(0)).getId()));
        this.validateResult((ResponseEntity<JaxbRuleList>)result, HttpStatus.OK, 1);
        this.validateRules((JaxbRuleList)result.getBody(), prefix, "user1");
        this.validateRules((JaxbRuleList)result.getBody(), 5L);
        this.validateRules(0, prefix, "user1", "user5");
        this.validateRules(0, 5L, 6L);
        this.validateRules(1, prefix, "user6", "user3");
        this.validateRules(1, 7L, 8L);
        this.validateRules(2, prefix, "user4", "user2");
        this.validateRules(2, 9L, 11L);
        result = this.controller.move(6, ((JaxbRule)originalRules.getRules().get(1)).getId() + "," + ((JaxbRule)originalRules.getRules().get(2)).getId());
        this.validateResult((ResponseEntity<JaxbRuleList>)result, HttpStatus.OK, 2);
        this.validateRules((JaxbRuleList)result.getBody(), prefix, "user3", "user2");
        this.validateRules((JaxbRuleList)result.getBody(), 6L, 7L);
        this.validateRules(0, prefix, "user1", "user3");
        this.validateRules(0, 5L, 6L);
        this.validateRules(1, prefix, "user2", "user5");
        this.validateRules(1, 7L, 8L);
        this.validateRules(2, prefix, "user6", "user4");
        this.validateRules(2, 9L, 11L);
    }

    @Test
    public void testRestControllerPaths() throws Exception {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(5L));
        rule.setUserName("pippo");
        rule.setRoleName("clown");
        rule.setAddressRange("127.0.0.1/32");
        rule.setService("wfs");
        rule.setRequest("getFeature");
        rule.setSubfield(null);
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("ALLOW");
        long id = this.prepareGeoFenceTestRules(rule);
        JSONObject json = (JSONObject)this.getAsJSON("/rest/geofence/rules.json", 200);
        Assert.assertNotNull((Object)id);
        Assert.assertEquals((long)1L, (long)json.getInt("count"));
        json = (JSONObject)this.getAsJSON("/rest/geofence/rules.json", 200);
        Assert.assertEquals((long)1L, (long)json.getInt("count"));
        JSONArray jsonRules = json.getJSONArray("rules");
        Assert.assertNotNull((Object)jsonRules);
        Assert.assertEquals((long)1L, (long)jsonRules.size());
        String jsonRuleBody = "{\n  'Rule': {\n    'priority': 0,\n    'userName': null,\n    'roleName': null,\n    'addressRange': null,\n    'workspace': 'geonode',\n    'layer': 'DE_USNG_UTM18',\n    'service': null,\n    'request': null,\n    'subfield': null,\n    'access': 'ALLOW',\n    'limits': null,\n    'layerDetails': {\n      'layerType': 'VECTOR',\n      'defaultStyle': 'DE_USNG_UTM18',\n      'cqlFilterRead': 'Northings >= 100',\n      'cqlFilterWrite': null,\n      'allowedArea': 'SRID=4326;MULTIPOLYGON (((-180 -90, -180 90, 180 90, 180 -90, -180 -90)))',\n      'catalogMode': null,\n      'allowedStyles': [],\n      'attributes': [\n        {\n          'name': 'Eastings',\n          'dataType': 'java.lang.String',\n          'accessType': 'READWRITE'\n        },\n        {\n          'name': 'the_geom',\n          'dataType': 'org.locationtech.jts.geom.MultiPolygon',\n          'accessType': 'READONLY'\n        },\n        {\n          'name': 'GRID1MIL',\n          'dataType': 'java.lang.String',\n          'accessType': 'NONE'\n        },\n        {\n          'name': 'GRID100K',\n          'dataType': 'java.lang.String',\n          'accessType': 'READONLY'\n        },\n        {\n          'name': 'Northings',\n          'dataType': 'java.lang.String',\n          'accessType': 'NONE'\n        },\n        {\n          'name': 'USNG',\n          'dataType': 'java.lang.String',\n          'accessType': 'NONE'\n        }\n      ]\n    }\n  }\n}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/geofence/rules", "{\n  'Rule': {\n    'priority': 0,\n    'userName': null,\n    'roleName': null,\n    'addressRange': null,\n    'workspace': 'geonode',\n    'layer': 'DE_USNG_UTM18',\n    'service': null,\n    'request': null,\n    'subfield': null,\n    'access': 'ALLOW',\n    'limits': null,\n    'layerDetails': {\n      'layerType': 'VECTOR',\n      'defaultStyle': 'DE_USNG_UTM18',\n      'cqlFilterRead': 'Northings >= 100',\n      'cqlFilterWrite': null,\n      'allowedArea': 'SRID=4326;MULTIPOLYGON (((-180 -90, -180 90, 180 90, 180 -90, -180 -90)))',\n      'catalogMode': null,\n      'allowedStyles': [],\n      'attributes': [\n        {\n          'name': 'Eastings',\n          'dataType': 'java.lang.String',\n          'accessType': 'READWRITE'\n        },\n        {\n          'name': 'the_geom',\n          'dataType': 'org.locationtech.jts.geom.MultiPolygon',\n          'accessType': 'READONLY'\n        },\n        {\n          'name': 'GRID1MIL',\n          'dataType': 'java.lang.String',\n          'accessType': 'NONE'\n        },\n        {\n          'name': 'GRID100K',\n          'dataType': 'java.lang.String',\n          'accessType': 'READONLY'\n        },\n        {\n          'name': 'Northings',\n          'dataType': 'java.lang.String',\n          'accessType': 'NONE'\n        },\n        {\n          'name': 'USNG',\n          'dataType': 'java.lang.String',\n          'accessType': 'NONE'\n        }\n      ]\n    }\n  }\n}", "text/json");
        Assert.assertEquals((long)201L, (long)response.getStatus());
        json = (JSONObject)this.getAsJSON("/rest/geofence/rules.json", 200);
        Assert.assertEquals((long)2L, (long)json.getInt("count"));
        jsonRules = json.getJSONArray("rules");
        Assert.assertNotNull((Object)jsonRules);
        Assert.assertEquals((long)2L, (long)jsonRules.size());
        JSONObject jsonRule = null;
        for (Object jsonObj : jsonRules) {
            Assert.assertNotNull(jsonObj);
            Assert.assertTrue((boolean)(jsonObj instanceof JSONObject));
            jsonRule = (JSONObject)jsonObj;
            this.print((JSON)jsonRule);
            if (jsonRule.getString("layer").equals("DE_USNG_UTM18")) {
                Assert.assertEquals((Object)"geonode", (Object)jsonRule.getString("workspace"));
                Assert.assertEquals((Object)"DE_USNG_UTM18", (Object)jsonRule.getString("layer"));
                Assert.assertEquals((Object)"ALLOW", (Object)jsonRule.getString("access"));
                JSONObject layerDetails = jsonRule.getJSONObject("layerDetails");
                Assert.assertNotNull((Object)layerDetails);
                Assert.assertEquals((Object)"VECTOR", (Object)layerDetails.getString("layerType"));
                Assert.assertEquals((Object)"DE_USNG_UTM18", (Object)layerDetails.getString("defaultStyle"));
                Assert.assertEquals((Object)"Northings >= 100", (Object)layerDetails.getString("cqlFilterRead"));
                Assert.assertEquals((Object)"SRID=4326;MULTIPOLYGON (((-180 -90, -180 90, 180 90, 180 -90, -180 -90)))", (Object)layerDetails.getString("allowedArea"));
                break;
            }
            jsonRule = null;
        }
        Assert.assertNotNull(jsonRule);
        json = (JSONObject)this.getAsJSON("/rest/geofence/rules/id/" + jsonRule.getInt("id") + ".json", 200);
        Assert.assertEquals((Object)json.toString(), (Object)jsonRule.toString());
        response = this.deleteAsServletResponse("/rest/geofence/rules/id/" + jsonRule.getInt("id"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        json = (JSONObject)this.getAsJSON("/rest/geofence/rules.json", 200);
        Assert.assertEquals((long)1L, (long)json.getInt("count"));
    }

    @Test
    public void testLimitsSRIDAndSpatialFilterType() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(5L));
        rule.setAccess("LIMIT");
        rule.setLimits(new JaxbRule.Limits());
        MultiPolygon mPoly = GML3MockData.multiPolygon();
        mPoly.setSRID(3003);
        rule.getLimits().setAllowedArea(mPoly);
        rule.getLimits().setSpatialFilterType("CLIP");
        rule.getLimits().setCatalogMode("MIXED");
        long id = this.prepareGeoFenceTestRules(rule);
        Rule realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getLimits().getCatalogMode(), (Object)realRule.getRuleLimits().getCatalogMode().toString());
        Assert.assertEquals((long)realRule.getRuleLimits().getAllowedArea().getSRID(), (long)3003L);
        Assert.assertTrue((boolean)rule.getLimits().getAllowedArea().contains("SRID=3003"));
        Assert.assertEquals((Object)rule.getLimits().getSpatialFilterType(), (Object)realRule.getRuleLimits().getSpatialFilterType().toString());
        rule.getLimits().setSpatialFilterType("INTERSECT");
        this.controller.update(Long.valueOf(id), rule);
        realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getLimits().getSpatialFilterType(), (Object)realRule.getRuleLimits().getSpatialFilterType().toString());
        JaxbRuleList list = this.controller.get(null, null, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        JaxbRule r = (JaxbRule)list.getRules().get(0);
        JaxbRule.Limits limits = r.getLimits();
        Assert.assertEquals((Object)limits.getSpatialFilterType(), (Object)"INTERSECT");
        Assert.assertTrue((boolean)limits.getAllowedArea().contains("SRID"));
    }

    @Test
    public void testLayerDetailSRIDAndSpatialFilterType() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(5L));
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("ALLOW");
        rule.setLayerDetails(new JaxbRule.LayerDetails());
        MultiPolygon multiPolygon = GML3MockData.multiPolygon();
        multiPolygon.setSRID(3002);
        rule.getLayerDetails().setAllowedArea(multiPolygon);
        rule.getLayerDetails().setSpatialFilterType("INTERSECT");
        rule.getLayerDetails().setDefaultStyle("myDefaultStyle");
        rule.getLayerDetails().setLayerType("VECTOR");
        long id = this.prepareGeoFenceTestRules(rule);
        Rule realRule = this.adminService.get(id);
        Assert.assertEquals((long)realRule.getLayerDetails().getArea().getSRID(), (long)3002L);
        Assert.assertTrue((boolean)rule.getLayerDetails().getAllowedArea().contains("SRID=3002"));
        Assert.assertEquals((Object)rule.getLayerDetails().getSpatialFilterType(), (Object)realRule.getLayerDetails().getSpatialFilterType().toString());
        rule.getLayerDetails().setSpatialFilterType("CLIP");
        this.controller.update(Long.valueOf(id), rule);
        realRule = this.adminService.get(id);
        Assert.assertEquals((Object)rule.getLayerDetails().getSpatialFilterType(), (Object)realRule.getLayerDetails().getSpatialFilterType().toString());
        JaxbRuleList list = this.controller.get(null, null, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        JaxbRule r = (JaxbRule)list.getRules().get(0);
        JaxbRule.LayerDetails details = r.getLayerDetails();
        Assert.assertEquals((Object)details.getSpatialFilterType(), (Object)"CLIP");
        Assert.assertTrue((boolean)details.getAllowedArea().contains("SRID"));
    }

    @Test
    public void testGetByIdWithNullLayerTypeAndAllowedArea() {
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(7L));
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("ALLOW");
        rule.setLayerDetails(new JaxbRule.LayerDetails());
        long id = this.prepareGeoFenceTestRules(rule);
        JaxbRule r = this.controller.get(Long.valueOf(id));
        Assert.assertNotNull((Object)r);
        Assert.assertNotNull((Object)r.getLayerDetails());
        Assert.assertNull((Object)r.getLayerDetails().getLayerType());
        JaxbRuleList list = this.controller.get(null, null, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        r = (JaxbRule)list.getRules().get(0);
        Assert.assertNotNull((Object)r);
        Assert.assertNotNull((Object)r.getLayerDetails());
        Assert.assertNull((Object)r.getLayerDetails().getLayerType());
    }

    @Test
    public void testGetByDateRange() {
        this.deleteAllRules();
        this.controller.insert(new JaxbRule(new Rule(10L, GrantType.ALLOW)));
        this.controller.insert(new JaxbRule(new Rule(20L, GrantType.ALLOW).setValidBefore(Date.valueOf("2025-01-10"))));
        this.controller.insert(new JaxbRule(new Rule(30L, GrantType.ALLOW).setValidAfter(Date.valueOf("2025-02-10"))));
        this.controller.insert(new JaxbRule(new Rule(40L, GrantType.ALLOW).setValidAfter(Date.valueOf("2025-03-10")).setValidBefore(Date.valueOf("2025-04-10"))));
        this.assertRules(this.getByDate(null, false), new Integer[]{10, 20, 30, 40});
        this.assertRules(this.getByDate("2025-01-05", true), new Integer[]{10, 20});
        this.assertRules(this.getByDate("2025-01-05", false), new Integer[]{20});
        this.assertRules(this.getByDate("2025-01-15", true), new Integer[]{10});
        this.assertRules(this.getByDate("2025-01-15", false), new Integer[0]);
        this.assertRules(this.getByDate("2025-02-15", true), new Integer[]{10, 30});
        this.assertRules(this.getByDate("2025-03-15", true), new Integer[]{10, 30, 40});
        this.assertRules(this.getByDate("2025-04-15", true), new Integer[]{10, 30});
    }

    private JaxbRuleList getByDate(String date, boolean includeDefault) {
        return this.controller.get(null, null, false, null, null, null, null, null, null, null, null, null, date, Boolean.valueOf(includeDefault), null, null, null, null, null, null, null, null, null, null);
    }

    private void assertRules(JaxbRuleList rules, Integer[] expectedPriorities) {
        Set pri = rules.getRules().stream().map(r -> r.getPriority()).collect(Collectors.toSet());
        Set exp = Arrays.asList(expectedPriorities).stream().map(i -> i.longValue()).collect(Collectors.toSet());
        Assert.assertEquals((String)"Bad rule set returned", exp, pri);
    }

    @Test
    public void testLocalPersisterDeserialization() throws IOException {
        XStreamPersisterFactory xpf = new XStreamPersisterFactory();
        GeoFenceServerXStreamInitializer initializer = new GeoFenceServerXStreamInitializer();
        xpf.addInitializer((XStreamPersisterInitializer)initializer);
        XStreamPersister persister = xpf.createXMLPersister();
        this.controller.configurePersister(persister, null);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Rule><access>LIMIT</access><layer>DE_USNG_UTM18</layer><limits>     <allowedArea>SRID=4326;MULTIPOLYGON (((-75 -90, -75 90, 75 90, 75 -90, -75 -90)))</allowedArea>     <catalogMode>HIDDEN</catalogMode></limits><priority>1</priority><workspace>geonode</workspace></Rule>";
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        JaxbRule rule = (JaxbRule)persister.load((InputStream)bais, JaxbRule.class);
        Assert.assertNotNull((Object)rule);
        Assert.assertEquals((Object)"LIMIT", (Object)rule.getAccess());
        Assert.assertEquals((Object)"DE_USNG_UTM18", (Object)rule.getLayer());
        Assert.assertEquals((Object)"geonode", (Object)rule.getWorkspace());
        Assert.assertEquals((long)1L, (long)rule.getPriority().intValue());
        Assert.assertNotNull((Object)rule.getLimits());
        Assert.assertEquals((Object)"SRID=4326;MULTIPOLYGON (((-75 -90, -75 90, 75 90, 75 -90, -75 -90)))", (Object)rule.getLimits().getAllowedArea());
        Assert.assertEquals((Object)"HIDDEN", (Object)rule.getLimits().getCatalogMode());
    }

    @Test
    public void testRulesXMLPayload() throws Exception {
        this.adminService.getAll().stream().mapToLong(ShortRule::getId).peek(id -> LOGGER.warning("deleting " + id)).forEach(arg_0 -> ((RuleAdminService)this.adminService).delete(arg_0));
        JaxbRule rule = new JaxbRule();
        rule.setPriority(Long.valueOf(7L));
        rule.setWorkspace("workspace");
        rule.setLayer("layer");
        rule.setAccess("ALLOW");
        rule.setRoleName("ROLE_EDITOR");
        rule.setLayerDetails(new JaxbRule.LayerDetails());
        long id2 = this.prepareGeoFenceTestRules(rule);
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Rules count=\"1\"><Rule id=\"" + id2 + "\"><access>ALLOW</access><layer>layer</layer><layerDetails><spatialFilterType>INTERSECT</spatialFilterType></layerDetails><priority>7</priority><roleName>ROLE_EDITOR</roleName><workspace>workspace</workspace></Rule></Rules>";
        String response = super.getAsString("/rest/geofence/rules");
        XMLAssert.assertXMLEqual((String)expected, (String)response);
    }

    @Test
    public void testIpFiltering() {
        IPAddressRange r1 = new IPAddressRange("192.168.0.0/16");
        IPAddressRange r2 = new IPAddressRange("192.168.10.0/24");
        IPAddressRange r3 = new IPAddressRange("10.0.0.0/8");
        this.deleteAllRules();
        this.adminService.insert(new Rule(1L, null, null, null, null, null, null, null, null, null, GrantType.ALLOW));
        this.adminService.insert(new Rule(2L, null, null, null, r1, null, null, null, null, null, GrantType.ALLOW));
        this.adminService.insert(new Rule(3L, null, null, null, r1, "s1", null, null, null, null, GrantType.ALLOW));
        this.adminService.insert(new Rule(4L, null, null, null, r2, "s2", null, null, null, null, GrantType.ALLOW));
        this.adminService.insert(new Rule(5L, null, null, null, r3, null, null, null, null, null, GrantType.ALLOW));
        this.validateRules(this.getByIpService(null, null, null, null), 1L, 2L, 3L, 4L, 5L);
        this.validateRules(this.getByIpService("1.1.1.1", true, null, null), 1L);
        this.validateRules(this.getByIpService("1.1.1.1", false, null, null), new long[0]);
        this.validateRules(this.getByIpService("192.168.1.1", true, null, null), 1L, 2L, 3L);
        this.validateRules(this.getByIpService("192.168.1.1", false, null, null), 2L, 3L);
        this.validateRules(this.getByIpService("192.168.1.1", true, "s2", true), 1L, 2L);
        this.validateRules(this.getByIpService("192.168.1.1", false, null, null), 2L, 3L);
        this.validateRules(this.getByIpService("192.168.10.1", true, null, null), 1L, 2L, 3L, 4L);
    }

    JaxbRuleList getByIpService(String ip, Boolean ipIncludeDefault, String service, Boolean serviceIncludeDefault) {
        return this.controller.get(null, null, false, null, null, null, null, null, null, null, ip, ipIncludeDefault, null, null, service, serviceIncludeDefault, null, null, null, null, null, null, null, null);
    }

    protected long prepareGeoFenceTestRules(JaxbRule rule) {
        this.deleteAllRules();
        return Long.parseLong(this.controller.insert(rule));
    }

    private void deleteAllRules() {
        if (this.adminService.getCountAll() > 0L) {
            for (ShortRule r : this.adminService.getAll()) {
                this.controller.delete(r.getId());
            }
        }
    }

    private void validateResult(ResponseEntity<JaxbRuleList> result, HttpStatus expectedHttpStatus, int rules) {
        MatcherAssert.assertThat(result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getStatusCode(), (Matcher)CoreMatchers.is((Object)expectedHttpStatus));
        if (rules > 0) {
            MatcherAssert.assertThat((Object)((JaxbRuleList)result.getBody()), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)((JaxbRuleList)result.getBody()).getRules().size(), (Matcher)CoreMatchers.is((Object)rules));
        } else {
            MatcherAssert.assertThat((Object)((JaxbRuleList)result.getBody()), (Matcher)CoreMatchers.nullValue());
        }
    }

    private void validateRules(int page, String prefix, String ... expectedUsers) {
        JaxbRuleList rules = this.controller.get(Integer.valueOf(page), Integer.valueOf(2), false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.validateRules(rules, prefix, expectedUsers);
    }

    private void validateRules(JaxbRuleList rules, String prefix, String ... expectedUsers) {
        MatcherAssert.assertThat((Object)rules, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules().size(), (Matcher)CoreMatchers.is((Object)expectedUsers.length));
        for (int i = 0; i < expectedUsers.length; ++i) {
            MatcherAssert.assertThat((Object)((JaxbRule)rules.getRules().get(i)).getUserName(), (Matcher)CoreMatchers.is((Object)(prefix + "-" + expectedUsers[i])));
        }
    }

    private void validateRules(int page, long ... expectedPriorities) {
        JaxbRuleList rules = this.controller.get(Integer.valueOf(page), Integer.valueOf(2), false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.validateRules(rules, expectedPriorities);
    }

    private void validateRules(JaxbRuleList rules, long ... expectedPriorities) {
        MatcherAssert.assertThat((Object)rules, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)rules.getRules().size(), (Matcher)CoreMatchers.is((Object)expectedPriorities.length));
        for (int i = 0; i < expectedPriorities.length; ++i) {
            MatcherAssert.assertThat((Object)((JaxbRule)rules.getRules().get(i)).getPriority(), (Matcher)CoreMatchers.is((Object)expectedPriorities[i]));
        }
    }
}

