/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.server.xstream;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.geofence.server.rest.xml.AbstractPayload;
import org.geoserver.geofence.server.rest.xml.BatchOperation;
import org.geoserver.geofence.server.rest.xml.JaxbAdminRule;
import org.geoserver.geofence.server.rest.xml.JaxbRule;

public class BatchOpXtreamConverter
extends AbstractReflectionConverter {
    public BatchOpXtreamConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return BatchOperation.class.isAssignableFrom(type);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return new BatchOperation();
    }

    public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        BatchOperation operation = (BatchOperation)result;
        String srv = reader.getAttribute("service");
        String type = reader.getAttribute("type");
        String id = reader.getAttribute("id");
        if (!StringUtils.isBlank((CharSequence)srv)) {
            operation.setService(BatchOperation.ServiceName.valueOf(srv));
        }
        if (!StringUtils.isBlank((CharSequence)type)) {
            operation.setType(BatchOperation.TypeName.valueOf(type));
        }
        if (!StringUtils.isBlank((CharSequence)id)) {
            operation.setId(Long.valueOf(id));
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            Object payload = null;
            if (nodeName.equals("Rule")) {
                payload = context.convertAnother((Object)operation, JaxbRule.class);
            } else if (nodeName.equals("AdminRule")) {
                payload = context.convertAnother((Object)operation, JaxbAdminRule.class);
            }
            operation.setPayload((AbstractPayload)payload);
            reader.moveUp();
        }
        return result;
    }
}

