/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import com.google.common.base.Ticker;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.geofence.cache.CacheConfiguration;
import org.geoserver.geofence.cache.CacheManager;
import org.geoserver.geofence.cache.CachedRuleReader;
import org.geoserver.geofence.cache.RuleCacheLoaderFactory;
import org.geoserver.geofence.config.GeoFenceConfigurationManager;
import org.geoserver.geofence.config.GeoFencePropertyPlaceholderConfigurer;
import org.geoserver.geofence.containers.ContainerAccessCacheLoaderFactory;
import org.geoserver.geofence.containers.DefaultContainerAccessResolver;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class CacheReaderTest
extends GeofenceBaseTest {
    static final Logger LOGGER = Logging.getLogger(CacheReaderTest.class);
    private CustomTicker ticker;
    private CacheManager cacheManager;
    private CachedRuleReader cachedRuleReader;
    private GeoFencePropertyPlaceholderConfigurer configurer;
    private RuleReaderService realReader;

    @Before
    public void onInitCachedReader() {
        this.configurer = (GeoFencePropertyPlaceholderConfigurer)applicationContext.getBean("geofence-configurer");
        this.configurer.setLocation((Resource)new UrlResource(((Object)((Object)this)).getClass().getResource("/test-cache-config.properties")));
        this.realReader = (RuleReaderService)applicationContext.getBean("remoteReaderService", RuleReaderService.class);
        this.ticker = new CustomTicker();
        CacheConfiguration config = new CacheConfiguration();
        config.setSize(100L);
        config.setRefreshMilliSec(500L);
        config.setExpireMilliSec(1000L);
        config.setCustomTicker((Ticker)this.ticker);
        if (configManager == null) {
            configManager = (GeoFenceConfigurationManager)applicationContext.getBean("geofenceConfigurationManager");
        }
        Assert.assertNotNull((Object)configManager);
        configManager.setCacheConfiguration(config);
        this.cacheManager = new CacheManager(configManager);
        this.cacheManager.getCacheInitParams().setSize(100L);
        this.cacheManager.getCacheInitParams().setRefreshMilliSec(500L);
        this.cacheManager.getCacheInitParams().setExpireMilliSec(1000L);
        this.cacheManager.getCacheInitParams().setCustomTicker((Ticker)this.ticker);
        this.cachedRuleReader = new CachedRuleReader(this.cacheManager);
        this.cacheManager.setRuleServiceLoaderFactory(new RuleCacheLoaderFactory(this.realReader));
        this.cacheManager.setContainerAccessCacheLoaderFactory(new ContainerAccessCacheLoaderFactory(new DefaultContainerAccessResolver((RuleReaderService)this.cachedRuleReader)));
        this.cacheManager.init();
    }

    @Test
    public void testSize() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Assert.assertEquals((long)0L, (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)0L, (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)0L, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        RuleFilter filter1 = new RuleFilter();
        filter1.setUser("test_1");
        RuleFilter filter2 = new RuleFilter();
        filter2.setUser("test_2");
        RuleFilter filter3 = new RuleFilter();
        filter3.setUser("test_3");
        Assert.assertNotSame((Object)filter1, (Object)filter2);
        int hitExp = 0;
        int missExp = 0;
        int evictExp = 0;
        AccessInfo ai1_1 = this.cachedRuleReader.getAccessInfo(filter1);
        Assert.assertEquals((long)hitExp, (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)(++missExp), (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        this.ticker.setMillisec(1L);
        AccessInfo ai1_2 = this.cachedRuleReader.getAccessInfo(filter1);
        Assert.assertEquals((long)(++hitExp), (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)missExp, (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        Assert.assertEquals((Object)ai1_1, (Object)ai1_2);
        this.ticker.setMillisec(2L);
        this.cachedRuleReader.getAccessInfo(filter2);
        Assert.assertEquals((long)hitExp, (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)(++missExp), (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        this.ticker.setMillisec(3L);
        this.cachedRuleReader.getAccessInfo(filter3);
        Assert.assertEquals((long)hitExp, (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)(++missExp), (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        this.ticker.setMillisec(4L);
        this.cachedRuleReader.getAccessInfo(filter2);
        Assert.assertEquals((long)(++hitExp), (long)this.cacheManager.getRuleCache().stats().hitCount());
        this.ticker.setMillisec(5L);
        this.cachedRuleReader.getAccessInfo(filter3);
        Assert.assertEquals((long)(++hitExp), (long)this.cacheManager.getRuleCache().stats().hitCount());
        this.ticker.setMillisec(6L);
        this.cachedRuleReader.getAccessInfo(filter1);
        Assert.assertEquals((long)(++hitExp), (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)missExp, (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
    }

    @Test
    public void testExpire() throws InterruptedException {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Assert.assertEquals((long)0L, (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)0L, (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)0L, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        RuleFilter filter1 = new RuleFilter();
        filter1.setUser("test_1");
        RuleFilter filter2 = new RuleFilter();
        filter2.setUser("test_2");
        RuleFilter filter3 = new RuleFilter();
        filter3.setUser("test_3");
        int hitExp = 0;
        int missExp = 0;
        int evictExp = 0;
        AccessInfo ai1_1 = this.cachedRuleReader.getAccessInfo(filter1);
        Assert.assertEquals((long)hitExp, (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)(++missExp), (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        this.ticker.setMillisec(1L);
        AccessInfo ai1_2 = this.cachedRuleReader.getAccessInfo(filter1);
        Assert.assertEquals((long)(++hitExp), (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)missExp, (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        Assert.assertEquals((long)1L, (long)this.cacheManager.getRuleCache().stats().loadSuccessCount());
        Assert.assertEquals((Object)ai1_1, (Object)ai1_2);
        this.ticker.setMillisec(600L);
        this.cachedRuleReader.getAccessInfo(filter1);
        Assert.assertEquals((long)(++hitExp), (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)missExp, (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        this.ticker.setMillisec(700L);
        Thread.sleep(500L);
        Assert.assertEquals((long)hitExp, (long)this.cacheManager.getRuleCache().stats().hitCount());
        Assert.assertEquals((long)missExp, (long)this.cacheManager.getRuleCache().stats().missCount());
        Assert.assertEquals((long)evictExp, (long)this.cacheManager.getRuleCache().stats().evictionCount());
        if (2L != this.cacheManager.getRuleCache().stats().loadSuccessCount()) {
            LOGGER.log(Level.SEVERE, "*** Bad successCount check, expected 2, found {0}", this.cacheManager.getRuleCache().stats().loadSuccessCount());
        }
        this.ticker.setMillisec(800L);
        this.cachedRuleReader.getAccessInfo(filter1);
        this.ticker.setMillisec(2000L);
        this.cachedRuleReader.getAccessInfo(filter1);
    }

    static class CustomTicker
    extends Ticker {
        private long nano = 0L;

        CustomTicker() {
        }

        public long read() {
            return this.nano;
        }

        public void setMillisec(long milli) {
            this.nano = milli * 1000000L;
        }
    }
}

