/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.net.URL;
import java.util.Arrays;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.rest.catalog.WMTSLayerTest;
import org.geoserver.security.WMTSAccessLimits;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.NameImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.geotools.referencing.CRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.w3c.dom.Document;

public class GeofenceAccessManager_WMTSLayerTest
extends GeofenceBaseTest {
    private static final String LAYER_NAME = "AMSR2_Snow_Water_Equivalent";
    @Rule
    public TestHttpClientRule clientMocker = new TestHttpClientRule();

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getWorkspaceByName("sf"));
        WMTSStoreInfo wmts = cb.buildWMTSStore("demo");
        wmts.setCapabilitiesURL(this.clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS");
        catalog.add((StoreInfo)wmts);
        this.addWmtsLayer();
        this.logout();
    }

    public void addWmtsLayer() throws Exception {
        String capabilities = this.clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS";
        WMTSLayerInfo wml = (WMTSLayerInfo)catalog.getResourceByName("sf", LAYER_NAME, WMTSLayerInfo.class);
        if (wml == null) {
            wml = catalog.getFactory().createWMTSLayer();
            wml.setName(LAYER_NAME);
            wml.setNativeName("topp:AMSR2_Snow_Water_Equivalent");
            wml.setStore(catalog.getStoreByName("demo", WMTSStoreInfo.class));
            wml.setCatalog(catalog);
            wml.setNamespace(catalog.getNamespaceByPrefix("sf"));
            wml.setSRS("EPSG:4326");
            CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
            wml.setNativeCRS(wgs84);
            wml.setLatLonBoundingBox(new ReferencedEnvelope(-110.0, 0.0, -60.0, 50.0, wgs84));
            wml.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
            catalog.add((ResourceInfo)wml);
            LayerInfo layer = catalog.getFactory().createLayer();
            layer.setResource((ResourceInfo)wml);
            layer.setName(LAYER_NAME);
            layer.setEnabled(true);
            catalog.add(layer);
        }
        MockHttpClient client = new MockHttpClient();
        client.expectGet(new URL(capabilities), (HTTPResponse)new MockHttpResponse(WMTSLayerTest.class.getResource("nasa.getcapa.xml"), "text/xml", new String[0]));
        this.clientMocker.bind((HTTPClient)client, capabilities);
    }

    @After
    public void removeLayer() throws Exception {
        LayerInfo l;
        if (IS_GEOFENCE_AVAILABLE.booleanValue() && (l = catalog.getLayerByName((Name)new NameImpl("sf", LAYER_NAME))) != null) {
            catalog.remove(l);
        }
    }

    @Test
    public void testWmsLimited() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken((Object)"wmsuser", (Object)"wmsuser");
        Request request = new Request();
        request.setService("WFS");
        request.setRequest("GetFeature");
        Dispatcher.REQUEST.set(request);
        this.login("wmsuser", "wmsuser", new String[]{"ROLE_ADMINISTRATOR"});
        LayerInfo wmtsLayer = catalog.getLayerByName("sf:AMSR2_Snow_Water_Equivalent");
        Assert.assertNotNull((Object)wmtsLayer);
        this.logout();
        WMTSAccessLimits limits = (WMTSAccessLimits)accessManager.getAccessLimits((Authentication)user, wmtsLayer);
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)limits.getReadFilter());
        request = new Request();
        request.setService("wms");
        Dispatcher.REQUEST.set(request);
        limits = (WMTSAccessLimits)accessManager.getAccessLimits((Authentication)user, wmtsLayer);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)limits.getReadFilter());
        limits = (WMTSAccessLimits)accessManager.getAccessLimits((Authentication)user, wmtsLayer.getResource());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)limits.getReadFilter());
    }

    @Test
    public void testWmsUnlimited() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken((Object)"admin", (Object)"geoserver", Arrays.asList(new SimpleGrantedAuthority("ROLE_ADMINISTRATOR")));
        Request request = new Request();
        request.setService("WFS");
        request.setRequest("GetFeature");
        Dispatcher.REQUEST.set(request);
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        LayerInfo wmtsLayer = catalog.getLayerByName("sf:AMSR2_Snow_Water_Equivalent");
        Assert.assertNotNull((Object)wmtsLayer);
        this.logout();
        WMTSAccessLimits limits = (WMTSAccessLimits)accessManager.getAccessLimits((Authentication)user, wmtsLayer);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)limits.getReadFilter());
        request = new Request();
        request.setService("wms");
        Dispatcher.REQUEST.set(request);
        limits = (WMTSAccessLimits)accessManager.getAccessLimits((Authentication)user, wmtsLayer);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)limits.getReadFilter());
        limits = (WMTSAccessLimits)accessManager.getAccessLimits((Authentication)user, wmtsLayer.getResource());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)limits.getReadFilter());
    }

    @Test
    public void testGetWmtsLayer() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        WorkspaceInfo ws = catalog.getWorkspaceByName("sf");
        Assert.assertNotNull((Object)ws);
        WMTSStoreInfo store = (WMTSStoreInfo)catalog.getStoreByName("sf", "demo", WMTSStoreInfo.class);
        Assert.assertNotNull((Object)store);
        LayerInfo layer = catalog.getLayerByName("sf:AMSR2_Snow_Water_Equivalent");
        Assert.assertNotNull((Object)layer);
        Assert.assertNotNull((Object)layer.getResource());
        Assert.assertTrue((boolean)(layer.getResource() instanceof WMTSLayerInfo));
        this.logout();
    }

    @Test
    public void testWmsGetCapabilites() throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        Document dom = this.getAsDOM("wms?request=GetCapabilities");
        this.print(dom);
        Assert.assertEquals((Object)"WMS_Capabilities", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"30", (String)"count(//*[local-name()='Layer'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//*[local-name()='Layer']/*[local-name()='Name' and starts-with(text(), 'sf:')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//*[local-name()='Layer']/*[local-name()='Name' and text()='sf:AMSR2_Snow_Water_Equivalent'])", (Document)dom);
    }
}

