/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.geofence.GeofenceAccessManager;
import org.geoserver.geofence.config.GeoFenceConfigurationManager;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public abstract class GeofenceBaseTest
extends GeoServerSystemTestSupport {
    protected static Catalog catalog;
    protected static XpathEngine xp;
    protected static Boolean IS_GEOFENCE_AVAILABLE;
    protected static GeofenceAccessManager accessManager;
    protected static GeoFenceConfigurationManager configManager;
    protected static RuleReaderService geofenceService;
    static GeoServerDataDirectory dd;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("html", "http://www.w3.org/1999/xhtml");
        namespaces.put("sld", "http://www.opengis.net/sld");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("atom", "http://www.w3.org/2005/Atom");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("wcs", "http://www.opengis.net/wcs/1.1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("sf", "http://cite.opengeospatial.org/gmlsf");
        namespaces.put("kml", "http://www.opengis.net/kml/2.2");
        SystemTestData.registerNamespaces(namespaces);
        this.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        xp = XMLUnit.newXpathEngine();
        testData.setUp();
        this.addUser("area", "area", Collections.singletonList("USERS"), Collections.singletonList("ROLE_AUTHENTICATED"));
        this.addUser("cite", "cite", Collections.singletonList("USERS"), Collections.singletonList("ROLE_AUTHENTICATED"));
        this.addUser("wms_user", "wms_user", Collections.singletonList("USERS"), Collections.singletonList("ROLE_AUTHENTICATED"));
        this.addUser("sf", "sf", Collections.singletonList("USERS"), Arrays.asList("ROLE_AUTHENTICATED", "ROLE_SF_ADMIN"));
        catalog = this.getCatalog();
        dd = new GeoServerDataDirectory(testData.getDataDirectoryRoot());
        GeoServerExtensionsHelper.singleton((String)"dataDirectory", (Object)dd, (Class[])new Class[]{GeoServerDataDirectory.class});
        accessManager = (GeofenceAccessManager)applicationContext.getBean("geofenceRuleAccessManager", GeofenceAccessManager.class);
        configManager = (GeoFenceConfigurationManager)applicationContext.getBean("geofenceConfigurationManager", GeoFenceConfigurationManager.class);
        Assert.assertNotNull((Object)accessManager);
        Assert.assertNotNull((Object)configManager);
        if (this.isGeoFenceAvailable()) {
            IS_GEOFENCE_AVAILABLE = true;
            System.setProperty("IS_GEOFENCE_AVAILABLE", "True");
        } else {
            LOGGER.warning("Skipping test in " + ((Object)((Object)this)).getClass().getSimpleName() + " as GeoFence service is down: in order to run this test you need the services to be running on port 9191");
        }
    }

    protected void registerNamespaces(Map<String, String> namespaces) {
    }

    @After
    public void after() {
        this.logout();
        this.username = null;
        this.password = null;
    }

    protected void onTearDown(SystemTestData testData) throws Exception {
        try {
            if (System.getProperty("IS_GEOFENCE_AVAILABLE") != null) {
                System.clearProperty("IS_GEOFENCE_AVAILABLE");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not remove System ENV variable {IS_GEOFENCE_AVAILABLE}", e);
        }
    }

    protected boolean isGeoFenceAvailable() {
        geofenceService = (RuleReaderService)applicationContext.getBean(applicationContext.getBeanFactory().resolveEmbeddedValue("${ruleReaderBackend}"));
        try {
            RuleFilter ruleFilter = new RuleFilter();
            ruleFilter.setService("WMS");
            List matchingRules = geofenceService.getMatchingRules(ruleFilter);
            if (geofenceService != null && matchingRules != null && !matchingRules.isEmpty()) {
                LOGGER.log(Level.WARNING, "GeoFence is active");
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error connecting to GeoFence", e);
            geofenceService = null;
        }
        LOGGER.log(Level.WARNING, "Not connecting to GeoFence");
        return false;
    }

    protected Authentication getUser(String username, String password, String ... roles) {
        ArrayList<SimpleGrantedAuthority> l = new ArrayList<SimpleGrantedAuthority>();
        for (String role : roles) {
            l.add(new SimpleGrantedAuthority(role));
        }
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, l);
    }

    static {
        IS_GEOFENCE_AVAILABLE = false;
    }
}

