/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.geofence.config.GeoFencePropertyPlaceholderConfigurer;
import org.geoserver.geofence.utils.GeofenceTestUtils;
import org.geoserver.geofence.web.GeofencePage;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class GeofencePageTest
extends GeoServerWicketTestSupport {
    static GeoFencePropertyPlaceholderConfigurer configurer;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        configurer = (GeoFencePropertyPlaceholderConfigurer)applicationContext.getBean("geofence-configurer");
        configurer.setLocation((Resource)new UrlResource(((Object)((Object)this)).getClass().getResource("/test-config.properties")));
    }

    @Before
    public void before() {
        this.login();
        tester.startPage(GeofencePage.class);
    }

    @Test
    public void testSave() throws URISyntaxException, IOException {
        GeofenceTestUtils.emptyFile("test-config.properties");
        FormTester ft = tester.newFormTester("form");
        ft.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
        File configFile = configurer.getConfigFile().file();
        LOGGER.info("Config file is " + configFile);
        Assert.assertTrue((GeofenceTestUtils.readConfig(configFile).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCancel() throws URISyntaxException, IOException {
        GeofenceTestUtils.emptyFile("test-config.properties");
        FormTester ft = tester.newFormTester("form");
        ft.submit("cancel");
        tester.assertRenderedPage(GeoServerHomePage.class);
        Assert.assertEquals((long)0L, (long)GeofenceTestUtils.readConfig("test-config.properties").length());
    }

    @Test
    public void testErrorEmptyInstance() {
        FormTester ft = tester.newFormTester("form");
        ft.setValue("instanceName", "");
        ft.submit("submit");
        tester.assertRenderedPage(GeofencePage.class);
        tester.assertContains("is required");
    }

    @Test
    public void testErrorEmptyURL() {
        FormTester ft = tester.newFormTester("form");
        ft.setValue("servicesUrl", "");
        ft.submit("submit");
        tester.assertRenderedPage(GeofencePage.class);
        tester.assertContains("is required");
    }

    @Test
    public void testErrorWrongURL() {
        TextField servicesUrl = (TextField)tester.getComponentFromLastRenderedPage("form:servicesUrl");
        servicesUrl.setDefaultModel((IModel)new Model((Serializable)((Object)"fakeurl")));
        tester.clickLink("form:test", true);
        tester.assertContains("RemoteAccessException");
    }

    @Test
    public void testErrorEmptyCacheSize() {
        FormTester ft = tester.newFormTester("form");
        ft.setValue("cacheSize", "");
        ft.submit("submit");
        tester.assertRenderedPage(GeofencePage.class);
        tester.assertContains("is required");
    }

    @Test
    public void testErrorWrongCacheSize() {
        FormTester ft = tester.newFormTester("form");
        ft.setValue("cacheSize", "A");
        ft.submit("submit");
        tester.assertRenderedPage(GeofencePage.class);
        tester.assertContains("long");
    }

    @Test
    public void testInvalidateCache() {
        tester.clickLink("form:invalidate", true);
        String success = (String)new StringResourceModel(GeofencePage.class.getSimpleName() + ".cacheInvalidated").getObject();
        tester.assertInfoMessages((Serializable[])new String[]{success});
    }
}

