/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geoserver.authentication.filter;

import java.util.logging.Logger;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.geoserver.authentication.auth.GeoFenceSecurityProvider;
import org.geoserver.geoserver.authentication.filter.GeoFenceAuthFilter;
import org.geoserver.geoserver.authentication.filter.GeoFenceAuthFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geotools.util.logging.Logging;
import org.junit.Assume;
import org.junit.Test;

public class GeofenceFilterConfigTest
extends GeofenceBaseTest {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.geoserver.authentication.auth");
    private String geofenceUrl = "http://localhost:9191/geofence";
    private String geoserverName = "geoserver";

    @Test
    public void testGeofenceFilterConfigValidation() throws Exception {
        GeoFenceAuthFilterConfig config = new GeoFenceAuthFilterConfig();
        config.setClassName(GeoFenceAuthFilter.class.getName());
        config.setName("testGeoFence");
        this.check(config);
    }

    public void check(GeoFenceAuthFilterConfig config) throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        config.setGeofenceUrl(this.geofenceUrl);
        config.setGeoserverName(this.geoserverName);
        GeoFenceAuthFilter filter = new GeoFenceAuthFilter();
        filter.setSecurityManager(this.getSecurityManager());
        GeoFenceSecurityProvider geofenceAuth = new GeoFenceSecurityProvider();
        geofenceAuth.setSecurityManager(this.getSecurityManager());
        geofenceAuth.setRuleReaderService(geofenceService);
        filter.setGeofenceAuth(geofenceAuth);
        filter.initializeFromConfig((SecurityNamedServiceConfig)config);
    }
}

