/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LocalWorkspaceCatalog;
import org.geoserver.geofence.RuleFilterBuilder;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.config.GeoFenceConfigurationManager;
import org.geoserver.geofence.containers.ContainerAccessResolver;
import org.geoserver.geofence.containers.ContainerLimitResolver;
import org.geoserver.geofence.core.model.LayerAttribute;
import org.geoserver.geofence.core.model.enums.AccessType;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.CatalogModeDTO;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.util.AccessInfoUtils;
import org.geoserver.geofence.util.GeomHelper;
import org.geoserver.geofence.wpscommon.WPSHelper;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WMTSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.LayerGroupContainmentCache;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class GeofenceAccessManager
implements ResourceAccessManager,
DispatcherCallback,
ExtensionPriority {
    private static final Logger LOGGER = Logging.getLogger(GeofenceAccessManager.class);
    static final String ROOT_ROLE = "ROLE_ADMINISTRATOR";
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);
    static final CatalogMode DEFAULT_CATALOG_MODE = CatalogMode.HIDE;
    RuleReaderService rulesService;
    Catalog catalog;
    private final GeoFenceConfigurationManager configurationManager;
    private ContainerAccessResolver containerAccessResolver;
    private LayerGroupContainmentCache groupsCache;
    private WPSHelper wpsHelper;

    public GeofenceAccessManager(RuleReaderService rulesService, Catalog catalog, GeoFenceConfigurationManager configurationManager, ContainerAccessResolver containerAccessResolver, WPSHelper wpsHelper) {
        this.rulesService = rulesService;
        this.catalog = new LocalWorkspaceCatalog(catalog);
        this.configurationManager = configurationManager;
        this.groupsCache = new LayerGroupContainmentCache(catalog);
        this.containerAccessResolver = containerAccessResolver;
        this.wpsHelper = wpsHelper;
    }

    public void setGroupsCache(LayerGroupContainmentCache groupsCache) {
        this.groupsCache = groupsCache;
    }

    boolean isAdmin(Authentication user) {
        if (user.getAuthorities() != null) {
            for (GrantedAuthority authority : user.getAuthorities()) {
                String userRole = authority.getAuthority();
                if (!ROOT_ROLE.equals(userRole) && !GeoServerRole.ADMIN_ROLE.getAuthority().equals(userRole)) continue;
                return true;
            }
        }
        return false;
    }

    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        LOGGER.log(Level.FINE, "Getting access limits for workspace {0}", workspace.getName());
        if (user != null && !(user instanceof AnonymousAuthenticationToken)) {
            if (this.isAdmin(user)) {
                LOGGER.log(Level.FINE, "Admin level access, returning full rights for workspace {0}", workspace.getName());
                return new WorkspaceAccessLimits(DEFAULT_CATALOG_MODE, true, true);
            }
            boolean canWrite = this.configurationManager.getConfiguration().isGrantWriteToWorkspacesToAuthenticatedUsers();
            boolean canAdmin = this.isWorkspaceAdmin(user, workspace.getName());
            return new WorkspaceAccessLimits(DEFAULT_CATALOG_MODE, true, canWrite, canAdmin);
        }
        boolean readable = true;
        boolean writable = false;
        return new WorkspaceAccessLimits(DEFAULT_CATALOG_MODE, true, false);
    }

    private boolean isWorkspaceAdmin(Authentication user, String workspaceName) {
        LOGGER.log(Level.FINE, "Getting admin auth for Workspace {0}", workspaceName);
        RuleFilter ruleFilter = new RuleFilter(RuleFilter.SpecialFilterType.DEFAULT);
        this.setRuleFilterUserAndRole(user, ruleFilter);
        ruleFilter.setInstance(this.configurationManager.getConfiguration().getInstanceName());
        ruleFilter.setWorkspace(workspaceName);
        String sourceAddress = this.retrieveCallerIpAddress();
        if (sourceAddress != null) {
            ruleFilter.setSourceAddress(sourceAddress);
        } else {
            LOGGER.log(Level.WARNING, "No source IP address found");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "AdminAuth filter: {0}", ruleFilter);
        }
        AccessInfo auth = this.rulesService.getAdminAuthorization(ruleFilter);
        LOGGER.log(Level.FINE, "Admin auth for User:{0} Workspace:{1}: {2}", new Object[]{user.getName(), workspaceName, auth.getAdminRights()});
        return auth.getAdminRights();
    }

    static String parseAddress(String a) {
        Pattern ipv4pattern = Pattern.compile("^(?<ADDR>\\d{1,3}(\\.\\d{1,3}){3})(:(?<PORT>\\d+))?$");
        Pattern ipv6pattern = Pattern.compile("^\\[?(?<ADDR>[0-9a-fA-F\\:]+)\\]?(\\]\\:(?<PORT>\\d+))?$");
        Matcher m = ipv4pattern.matcher(a);
        if (m.matches()) {
            return m.group("ADDR");
        }
        m = ipv6pattern.matcher(a);
        if (m.matches()) {
            return m.group("ADDR");
        }
        if (a.contains(":")) {
            int i = a.lastIndexOf(":");
            return a.substring(0, i);
        }
        return a;
    }

    String getSourceAddress(HttpServletRequest http) {
        try {
            if (http == null) {
                LOGGER.log(Level.WARNING, "No HTTP connection available.");
                return null;
            }
            String forwardedFor = http.getHeader("X-Forwarded-For");
            if (forwardedFor != null) {
                String[] ips = forwardedFor.split(", ");
                String parsed = GeofenceAccessManager.parseAddress(ips[0]);
                return InetAddress.getByName(parsed).getHostAddress();
            }
            return GeofenceAccessManager.parseAddress(http.getRemoteAddr());
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to get remote address", e);
            return null;
        }
    }

    private String retrieveCallerIpAddress() {
        String sourceAddress;
        Request owsRequest = (Request)Dispatcher.REQUEST.get();
        if (owsRequest != null) {
            HttpServletRequest httpReq = owsRequest.getHttpRequest();
            sourceAddress = this.getSourceAddress(httpReq);
            if (sourceAddress != null) {
                LOGGER.log(Level.FINE, "IP source address found in OWSRequest");
                return sourceAddress;
            }
            LOGGER.log(Level.WARNING, "Could not retrieve source address from OWSRequest");
        }
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            sourceAddress = this.getSourceAddress(request);
            if (sourceAddress != null) {
                LOGGER.log(Level.FINE, "IP source address found in Spring Request");
                return sourceAddress;
            }
            LOGGER.log(Level.WARNING, "Could not retrieve source address with Spring Request");
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.WARNING, "Error retrieving source address with Spring Request: " + ex.getMessage());
        }
        return null;
    }

    public StyleAccessLimits getAccessLimits(Authentication user, StyleInfo style) {
        LOGGER.fine("Not limiting styles");
        return null;
    }

    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerInfo) {
        LOGGER.log(Level.FINE, "Getting access limits for LayerGroup {0}", layerInfo.getName());
        return this.getAccessLimits(user, layerInfo, Collections.emptyList());
    }

    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        LOGGER.log(Level.FINE, "Getting access limits for Layer {0}", layer.getName());
        return this.getAccessLimits(user, layer, Collections.emptyList());
    }

    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        LOGGER.log(Level.FINE, "Getting access limits for Resource {0}", resource.getName());
        String workspace = resource.getStore().getWorkspace().getName();
        String layer = resource.getName();
        return (DataAccessLimits)this.getAccessLimits(user, (CatalogInfo)resource, layer, workspace, Collections.emptyList());
    }

    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer, List<LayerGroupInfo> containers) {
        LOGGER.log(Level.FINE, "Getting access limits for Layer {0} + containers", layer.getName());
        String workspace = layer.getResource().getStore().getWorkspace().getName();
        String layerName = layer.getName();
        return (DataAccessLimits)this.getAccessLimits(user, (CatalogInfo)layer, layerName, workspace, containers);
    }

    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup, List<LayerGroupInfo> containers) {
        LOGGER.log(Level.FINE, "Getting access limits for Layer {0} + containers", layerGroup.getName());
        WorkspaceInfo ws = layerGroup.getWorkspace();
        String workspace = ws != null ? ws.getName() : null;
        String layer = layerGroup.getName();
        return (LayerGroupAccessLimits)this.getAccessLimits(user, (CatalogInfo)layerGroup, layer, workspace, containers);
    }

    private AccessLimits getAccessLimits(Authentication user, CatalogInfo info, String layer, String workspace, List<LayerGroupInfo> containers) {
        Request req;
        String date;
        if (user != null && !(user instanceof AnonymousAuthenticationToken) && this.isAdmin(user)) {
            LOGGER.log(Level.FINE, "Admin level access, returning full rights for layer {0}", layer);
            return this.buildAdminAccessLimits(info);
        }
        String ipAddress = this.retrieveCallerIpAddress();
        RuleFilter ruleFilter = this.buildRuleFilter(workspace, layer, user, ipAddress, date = DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.now()));
        AccessInfo accessInfo = this.rulesService.getAccessInfo(ruleFilter);
        if (accessInfo == null) {
            accessInfo = AccessInfo.DENY_ALL;
            LOGGER.log(Level.WARNING, "GeoFence returning null AccessInfo for filter {0}", ruleFilter);
        }
        String service = (req = (Request)Dispatcher.REQUEST.get()) != null ? req.getService() : null;
        boolean isWms = "WMS".equalsIgnoreCase(service);
        boolean noLayerGroups = CollectionUtils.isEmpty(containers);
        ContainerLimitResolver.ProcessingResult processingResult = null;
        if (noLayerGroups && isWms) {
            Collection<LayerGroupContainmentCache.LayerGroupSummary> summaries = this.getGroupSummary(info);
            if (summaries != null && !summaries.isEmpty()) {
                boolean anySingle;
                boolean allOpaque = this.allOpaque(summaries);
                if (allOpaque) {
                    accessInfo.setGrant(GrantType.DENY);
                }
                if (!(anySingle = summaries.stream().anyMatch(gs -> gs.getMode().equals((Object)LayerGroupInfo.Mode.SINGLE))) && !allOpaque) {
                    processingResult = this.containerAccessResolver.getContainerResolverResult(info, layer, workspace, this.configurationManager.getConfiguration(), ipAddress, user, null, summaries);
                }
            }
        } else if (!noLayerGroups) {
            processingResult = this.containerAccessResolver.getContainerResolverResult(info, layer, workspace, this.configurationManager.getConfiguration(), ipAddress, user, containers, null);
        }
        if ("WPS".equalsIgnoreCase(service)) {
            if (!noLayerGroups) {
                LOGGER.log(Level.WARNING, "Don't know how to deal with WPS requests for group data. Won't dive into single process limits.");
            } else {
                AccessInfoUtils.WPSAccessInfo resolvedAccessInfo = this.wpsHelper.resolveWPSAccess(req, ruleFilter, accessInfo);
                if (resolvedAccessInfo != null) {
                    accessInfo = resolvedAccessInfo.getAccessInfo();
                    processingResult = new ContainerLimitResolver.ProcessingResult(resolvedAccessInfo.getArea(), resolvedAccessInfo.getClip(), accessInfo.getCatalogMode());
                    LOGGER.log(Level.FINE, "Got WPS access {0} for layer {1} and user {2}", new Object[]{accessInfo, layer, this.getUserNameFromAuth(user)});
                }
            }
        }
        AccessLimits limits = info instanceof LayerGroupInfo ? this.buildLayerGroupAccessLimits(accessInfo) : (info instanceof ResourceInfo ? this.buildResourceAccessLimits((ResourceInfo)info, accessInfo, processingResult) : this.buildResourceAccessLimits(((LayerInfo)info).getResource(), accessInfo, processingResult));
        LOGGER.log(Level.FINE, "Returning {0} for layer {1} and user {2}", new Object[]{limits, layer, this.getUserNameFromAuth(user)});
        return limits;
    }

    private boolean allOpaque(Collection<LayerGroupContainmentCache.LayerGroupSummary> summaries) {
        LayerGroupInfo.Mode opaque = LayerGroupInfo.Mode.OPAQUE_CONTAINER;
        return summaries.stream().allMatch(gs -> gs.getMode().equals((Object)opaque));
    }

    private AccessLimits buildAdminAccessLimits(CatalogInfo info) {
        AccessLimits accessLimits = info instanceof LayerGroupInfo ? this.buildLayerGroupAccessLimits(AccessInfo.ALLOW_ALL) : (info instanceof ResourceInfo ? this.buildResourceAccessLimits((ResourceInfo)info, AccessInfo.ALLOW_ALL, null) : this.buildResourceAccessLimits(((LayerInfo)info).getResource(), AccessInfo.ALLOW_ALL, null));
        return accessLimits;
    }

    private String getUserNameFromAuth(Authentication authentication) {
        String username;
        String string = username = authentication != null ? authentication.getName() : null;
        if (username != null && username.isEmpty()) {
            username = null;
        }
        return username;
    }

    private Collection<LayerGroupContainmentCache.LayerGroupSummary> getGroupSummary(Object resource) {
        Collection summaries = resource instanceof ResourceInfo ? this.groupsCache.getContainerGroupsFor((ResourceInfo)resource) : (resource instanceof LayerInfo ? this.groupsCache.getContainerGroupsFor(((LayerInfo)resource).getResource()) : this.groupsCache.getContainerGroupsFor((LayerGroupInfo)resource));
        return summaries;
    }

    private void setRuleFilterUserAndRole(Authentication user, RuleFilter ruleFilter) {
        if (user != null) {
            GeoFenceConfiguration config = this.configurationManager.getConfiguration();
            if (config.isUseRolesToFilter()) {
                if (config.getRoles().isEmpty()) {
                    LOGGER.log(Level.WARNING, "Role filtering requested, but no roles provided. Will only use user authorizations");
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    String authList = user.getAuthorities().stream().map(a -> a.getAuthority()).collect(Collectors.joining(",", "[", "]"));
                    LOGGER.log(Level.FINE, "Authorizations found for user {0}: {1}", new Object[]{user.getName(), authList});
                    String allowedAuth = config.getRoles().stream().collect(Collectors.joining(",", "[", "]"));
                    LOGGER.log(Level.FINE, "Authorizations allowed: {0}", new Object[]{allowedAuth});
                }
            }
            if (config.isUseRolesToFilter() && !config.getRoles().isEmpty()) {
                boolean getAllRoles = config.getRoles().contains("*");
                Set excluded = config.getRoles().stream().filter(r -> r.startsWith("-")).map(r -> r.substring(1)).collect(Collectors.toSet());
                ArrayList<String> roles = new ArrayList<String>();
                for (GrantedAuthority authority : user.getAuthorities()) {
                    String authRole = authority.getAuthority();
                    boolean addRole = getAllRoles || config.getRoles().contains(authRole);
                    if (!(addRole = addRole && !excluded.contains(authRole))) continue;
                    roles.add(authRole);
                }
                if (roles.isEmpty()) {
                    roles.add("UNKNOWN");
                }
                String joinedRoles = String.join((CharSequence)",", roles);
                LOGGER.log(Level.FINE, "Setting role for filter: {0}", new Object[]{joinedRoles});
                ruleFilter.setRole(joinedRoles);
            } else {
                ruleFilter.setRole(RuleFilter.SpecialFilterType.ANY);
            }
            String username = user.getName();
            if (StringUtils.isEmpty((String)username)) {
                LOGGER.log(Level.WARNING, "Username is null for user: {0}", new Object[]{user});
                ruleFilter.setUser(RuleFilter.SpecialFilterType.DEFAULT);
            } else {
                LOGGER.log(Level.FINE, "Setting user for filter: {0}", new Object[]{username});
                ruleFilter.setUser(username);
            }
        } else {
            LOGGER.log(Level.INFO, "No user given");
            ruleFilter.setUser(RuleFilter.SpecialFilterType.DEFAULT);
        }
    }

    AccessLimits buildResourceAccessLimits(ResourceInfo info, AccessInfo accessInfo, ContainerLimitResolver.ProcessingResult resultLimits) {
        Geometry clipArea;
        Geometry intersectsArea;
        GrantType actualGrant = accessInfo.getGrant();
        boolean includeFilter = actualGrant == GrantType.ALLOW || actualGrant == GrantType.LIMIT;
        IncludeFilter readFilter = includeFilter ? Filter.INCLUDE : Filter.EXCLUDE;
        IncludeFilter writeFilter = includeFilter ? Filter.INCLUDE : Filter.EXCLUDE;
        try {
            if (accessInfo.getCqlFilterRead() != null) {
                readFilter = ECQL.toFilter((String)accessInfo.getCqlFilterRead());
            }
            if (accessInfo.getCqlFilterWrite() != null) {
                writeFilter = ECQL.toFilter((String)accessInfo.getCqlFilterWrite());
            }
        }
        catch (CQLException e) {
            throw new IllegalArgumentException("Invalid cql filter found: " + e.getMessage(), e);
        }
        List<PropertyName> readAttributes = this.toPropertyNames(accessInfo.getAttributes(), PropertyAccessMode.READ);
        List<PropertyName> writeAttributes = this.toPropertyNames(accessInfo.getAttributes(), PropertyAccessMode.WRITE);
        if (resultLimits != null) {
            intersectsArea = resultLimits.getIntersectArea();
            clipArea = resultLimits.getClipArea();
        } else {
            CoordinateReferenceSystem crs = GeomHelper.getCRSFromInfo((CatalogInfo)info);
            intersectsArea = GeomHelper.parseWKT(accessInfo.getAreaWkt());
            intersectsArea = GeomHelper.reprojectGeometry(intersectsArea, crs);
            clipArea = GeomHelper.parseWKT(accessInfo.getClipAreaWkt());
            clipArea = GeomHelper.reprojectGeometry(clipArea, crs);
        }
        CatalogMode catalogMode = this.getCatalogMode(accessInfo, resultLimits);
        LOGGER.log(Level.FINE, "Returning mode {0} for resource {1}", new Object[]{catalogMode, info});
        VectorAccessLimits accessLimits = null;
        if (info instanceof FeatureTypeInfo) {
            if (intersectsArea != null) {
                Intersects areaFilter = FF.intersects((Expression)FF.property(""), (Expression)FF.literal((Object)intersectsArea));
                if (clipArea != null) {
                    Intersects intersectClipArea = FF.intersects((Expression)FF.property(""), (Expression)FF.literal((Object)clipArea));
                    areaFilter = FF.or((Filter)areaFilter, (Filter)intersectClipArea);
                }
                readFilter = this.mergeFilter((Filter)readFilter, (Filter)areaFilter);
                writeFilter = this.mergeFilter((Filter)writeFilter, (Filter)areaFilter);
            }
            accessLimits = new VectorAccessLimits(catalogMode, readAttributes, (Filter)readFilter, writeAttributes, (Filter)writeFilter);
            if (clipArea != null) {
                accessLimits.setClipVectorFilter(clipArea);
            }
            if (intersectsArea != null) {
                accessLimits.setIntersectVectorFilter(intersectsArea);
            }
        } else if (info instanceof CoverageInfo) {
            Geometry finalArea = null;
            if (clipArea != null && intersectsArea != null) {
                finalArea = clipArea.union(intersectsArea);
            } else if (intersectsArea != null) {
                finalArea = intersectsArea;
            } else if (clipArea != null) {
                finalArea = clipArea;
            }
            accessLimits = new CoverageAccessLimits(catalogMode, (Filter)readFilter, this.toMultiPoly(finalArea), null);
        } else if (info instanceof WMSLayerInfo) {
            accessLimits = new WMSAccessLimits(catalogMode, (Filter)readFilter, this.toMultiPoly(intersectsArea), true);
        } else if (info instanceof WMTSLayerInfo) {
            accessLimits = new WMTSAccessLimits(catalogMode, (Filter)readFilter, this.toMultiPoly(intersectsArea));
        } else {
            throw new IllegalArgumentException("Don't know how to handle resource " + info);
        }
        return accessLimits;
    }

    AccessLimits buildLayerGroupAccessLimits(AccessInfo accessInfo) {
        GrantType grant = accessInfo.getGrant();
        if (grant.equals((Object)GrantType.ALLOW) || grant.equals((Object)GrantType.LIMIT)) {
            return null;
        }
        return new LayerGroupAccessLimits(this.convert(accessInfo.getCatalogMode()));
    }

    private CatalogMode getCatalogMode(AccessInfo accessInfo, ContainerLimitResolver.ProcessingResult resultLimits) {
        CatalogModeDTO ruleCatalogMode = resultLimits != null ? resultLimits.getCatalogModeDTO() : accessInfo.getCatalogMode();
        CatalogMode catalogMode = DEFAULT_CATALOG_MODE;
        if (ruleCatalogMode != null) {
            switch (ruleCatalogMode) {
                case CHALLENGE: {
                    catalogMode = CatalogMode.CHALLENGE;
                    break;
                }
                case HIDE: {
                    catalogMode = CatalogMode.HIDE;
                    break;
                }
                case MIXED: {
                    catalogMode = CatalogMode.MIXED;
                }
            }
        }
        return catalogMode;
    }

    private CatalogMode convert(CatalogModeDTO ruleCatalogMode) {
        CatalogMode catalogMode = DEFAULT_CATALOG_MODE;
        if (ruleCatalogMode != null) {
            switch (ruleCatalogMode) {
                case CHALLENGE: {
                    catalogMode = CatalogMode.CHALLENGE;
                    break;
                }
                case HIDE: {
                    catalogMode = CatalogMode.HIDE;
                    break;
                }
                case MIXED: {
                    catalogMode = CatalogMode.MIXED;
                }
            }
        }
        return catalogMode;
    }

    private RuleFilter buildRuleFilter(String workspace, String layer, Authentication user, String ipAddress, String date) {
        RuleFilterBuilder builder = new RuleFilterBuilder(this.configurationManager.getConfiguration());
        return builder.withRequest((Request)Dispatcher.REQUEST.get()).withIpAddress(ipAddress).withDate(date).withWorkspace(workspace).withLayer(layer).withUser(user).build();
    }

    private MultiPolygon toMultiPoly(Geometry reprojArea) {
        MultiPolygon rasterFilter = null;
        if (reprojArea != null && (rasterFilter = (MultiPolygon)Converters.convert((Object)reprojArea, MultiPolygon.class)) == null) {
            throw new RuntimeException("Error applying security rules, cannot convert the Geofence area restriction " + reprojArea.toText() + " to a multi-polygon");
        }
        return rasterFilter;
    }

    private Filter mergeFilter(Filter filter, Filter areaFilter) {
        if (filter == null || filter == Filter.INCLUDE) {
            return areaFilter;
        }
        if (filter == Filter.EXCLUDE) {
            return filter;
        }
        return FF.and(filter, areaFilter);
    }

    private List<PropertyName> toPropertyNames(Set<LayerAttribute> attributes, PropertyAccessMode mode) {
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        ArrayList<PropertyName> result = new ArrayList<PropertyName>();
        for (LayerAttribute attribute : attributes) {
            if (attribute.getAccess() != AccessType.READWRITE && (mode != PropertyAccessMode.READ || attribute.getAccess() != AccessType.READONLY)) continue;
            PropertyName property = FF.property(attribute.getName());
            result.add(property);
        }
        return result;
    }

    public void finished(Request request) {
    }

    public Request init(Request request) {
        return request;
    }

    public Operation operationDispatched(Request gsRequest, Operation operation) {
        String service = gsRequest.getService();
        String request = gsRequest.getRequest();
        Authentication user = SecurityContextHolder.getContext().getAuthentication();
        String username = null;
        if (user != null && !(user instanceof AnonymousAuthenticationToken)) {
            if (this.isAdmin(user)) {
                LOGGER.log(Level.FINE, "Admin level access, not applying default style for this request");
                return operation;
            }
            username = user.getName();
            if (username != null && username.isEmpty()) {
                username = null;
            }
        }
        if (request != null && "WMS".equalsIgnoreCase(service) && ("GetMap".equalsIgnoreCase(request) || "GetFeatureInfo".equalsIgnoreCase(request))) {
            GetMapRequest getMap;
            Object ro = operation.getParameters()[0];
            if (ro instanceof GetMapRequest) {
                getMap = (GetMapRequest)ro;
            } else if (ro instanceof GetFeatureInfoRequest) {
                getMap = ((GetFeatureInfoRequest)ro).getGetMapRequest();
            } else {
                throw new ServiceException("Unrecognized request object: " + ro);
            }
            this.overrideGetMapRequest(gsRequest, service, request, user, getMap);
        } else if (request != null && "WMS".equalsIgnoreCase(service) && "GetLegendGraphic".equalsIgnoreCase(request)) {
            this.overrideGetLegendGraphicRequest(gsRequest, operation, service, request, user);
        }
        return operation;
    }

    void overrideGetLegendGraphicRequest(Request gsRequest, Operation operation, String service, String request, Authentication user) {
        String layerName = (String)gsRequest.getKvp().get("LAYER");
        String reqStyle = (String)gsRequest.getKvp().get("STYLE");
        ArrayList<String> styles = new ArrayList<String>();
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        LayerInfo candidateLayer = this.catalog.getLayerByName(layerName);
        if (candidateLayer == null) {
            LayerGroupInfo layerGroup = this.catalog.getLayerGroupByName(layerName);
            if (layerGroup != null) {
                boolean emptyStyleName = reqStyle == null || "".equals(reqStyle);
                layers.addAll(emptyStyleName ? layerGroup.layers() : layerGroup.layers(reqStyle));
                this.addGroupStyles(layerGroup, styles, reqStyle);
            }
        } else {
            layers.add(candidateLayer);
            styles.add(reqStyle);
        }
        GetLegendGraphicRequest getLegend = (GetLegendGraphicRequest)operation.getParameters()[0];
        for (int i = 0; i < layers.size(); ++i) {
            LayerInfo layer = (LayerInfo)layers.get(i);
            ResourceInfo resource = layer.getResource();
            RuleFilter ruleFilter = new RuleFilter(RuleFilter.SpecialFilterType.DEFAULT);
            this.setRuleFilterUserAndRole(user, ruleFilter);
            ruleFilter.setInstance(this.configurationManager.getConfiguration().getInstanceName());
            ruleFilter.setService(service);
            ruleFilter.setRequest(request);
            ruleFilter.setWorkspace(resource.getStore().getWorkspace().getName());
            ruleFilter.setLayer(resource.getName());
            LOGGER.log(Level.FINE, "Getting access limits for getLegendGraphic", ruleFilter);
            AccessInfo rule = this.rulesService.getAccessInfo(ruleFilter);
            String styleName = (String)styles.get(i);
            if (styleName == null) {
                if (rule.getDefaultStyle() == null) continue;
                try {
                    StyleInfo si = this.catalog.getStyleByName(rule.getDefaultStyle());
                    if (si == null) {
                        throw new ServiceException("Could not find default style suggested by GeoRepository: " + rule.getDefaultStyle());
                    }
                    getLegend.setStyle(si.getStyle());
                    continue;
                }
                catch (IOException e) {
                    throw new ServiceException("Unable to load the style suggested by GeoRepository: " + rule.getDefaultStyle(), (Throwable)e);
                }
            }
            this.checkStyleAllowed(rule, styleName);
        }
    }

    void overrideGetMapRequest(Request gsRequest, String service, String request, Authentication user, GetMapRequest getMap) {
        if (gsRequest.getKvp().get("layers") == null && gsRequest.getKvp().get("sld") == null && gsRequest.getKvp().get("sld_body") == null) {
            throw new ServiceException("GetMap POST requests are forbidden");
        }
        List<String> styleNameList = this.getRequestedStyles(gsRequest, getMap);
        List layers = getMap.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            MapLayerInfo layer = (MapLayerInfo)layers.get(i);
            ResourceInfo info = null;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR || layer.getType() == MapLayerInfo.TYPE_RASTER) {
                info = layer.getResource();
            } else if (!this.configurationManager.getConfiguration().isAllowRemoteAndInlineLayers()) {
                throw new ServiceException("Remote layers are not allowed");
            }
            RuleFilter ruleFilter = new RuleFilter(RuleFilter.SpecialFilterType.DEFAULT);
            this.setRuleFilterUserAndRole(user, ruleFilter);
            ruleFilter.setInstance(this.configurationManager.getConfiguration().getInstanceName());
            ruleFilter.setService(service);
            ruleFilter.setRequest(request);
            if (info != null) {
                ruleFilter.setWorkspace(info.getStore().getWorkspace().getName());
                ruleFilter.setLayer(info.getName());
            } else {
                ruleFilter.setWorkspace(RuleFilter.SpecialFilterType.DEFAULT);
                ruleFilter.setLayer(RuleFilter.SpecialFilterType.DEFAULT);
            }
            LOGGER.log(Level.FINE, "Getting access limits for getMap", ruleFilter);
            AccessInfo rule = this.rulesService.getAccessInfo(ruleFilter);
            String styleName = styleNameList.get(i);
            if (styleName != null) {
                this.checkStyleAllowed(rule, styleName);
                continue;
            }
            if (rule.getDefaultStyle() == null) continue;
            try {
                StyleInfo si = this.catalog.getStyleByName(rule.getDefaultStyle());
                if (si == null) {
                    throw new ServiceException("Could not find default style suggested by Geofence: " + rule.getDefaultStyle());
                }
                Style style = si.getStyle();
                getMap.getStyles().set(i, style);
                continue;
            }
            catch (IOException e) {
                throw new ServiceException("Unable to load the style suggested by Geofence: " + rule.getDefaultStyle(), (Throwable)e);
            }
        }
    }

    private void checkStyleAllowed(AccessInfo accessInfo, String styleName) {
        HashSet<String> allowedStyles = new HashSet<String>();
        if (accessInfo.getDefaultStyle() != null) {
            allowedStyles.add(accessInfo.getDefaultStyle());
        }
        if (accessInfo.getAllowedStyles() != null) {
            allowedStyles.addAll(accessInfo.getAllowedStyles());
        }
        if (!allowedStyles.isEmpty() && !allowedStyles.contains(styleName)) {
            throw new ServiceException("The '" + styleName + "' style is not available on this layer");
        }
    }

    public Filter getSecurityFilter(Authentication user, Class<? extends CatalogInfo> clazz) {
        return Predicates.acceptAll();
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return result;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return response;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        return service;
    }

    private List<String> getRequestedStyles(Request gsRequest, GetMapRequest getMap) {
        ArrayList<String> requestedStyles = new ArrayList<String>();
        int styleIndex = 0;
        List<String> parsedStyles = this.parseStylesParameter(gsRequest);
        for (Object layer : this.parseLayersParameter(gsRequest, getMap)) {
            boolean outOfBound;
            boolean bl = outOfBound = styleIndex >= parsedStyles.size();
            if (layer instanceof LayerGroupInfo) {
                String styleName = outOfBound ? null : parsedStyles.get(styleIndex);
                this.addGroupStyles((LayerGroupInfo)layer, requestedStyles, styleName);
            } else if (outOfBound) {
                requestedStyles.add(null);
            } else {
                requestedStyles.add(parsedStyles.get(styleIndex));
            }
            ++styleIndex;
        }
        return requestedStyles;
    }

    private void addGroupStyles(LayerGroupInfo groupInfo, List<String> requestedStyles, String styleName) {
        List groupStyles = styleName != null && !"".equals(styleName) ? groupInfo.styles(styleName) : groupInfo.styles();
        requestedStyles.addAll(groupStyles.stream().map(s -> s != null ? s.prefixedName() : null).collect(Collectors.toList()));
    }

    private List<Object> parseLayersParameter(Request gsRequest, GetMapRequest getMap) {
        String rawLayersParameter = (String)gsRequest.getRawKvp().get("LAYERS");
        if (rawLayersParameter != null) {
            List layersNames = KvpUtils.readFlat((String)rawLayersParameter);
            return LayersParser.getInstance().parseLayers(layersNames, getMap.getRemoteOwsURL(), getMap.getRemoteOwsType());
        }
        return new ArrayList<Object>();
    }

    private List<String> parseStylesParameter(Request gsRequest) {
        String rawStylesParameter = (String)gsRequest.getRawKvp().get("STYLES");
        if (rawStylesParameter != null) {
            return KvpUtils.readFlat((String)rawStylesParameter);
        }
        return new ArrayList<String>();
    }

    public int getPriority() {
        return 100;
    }

    static final class LayersParser
    extends GetMapKvpRequestReader {
        private static LayersParser singleton = null;

        public static LayersParser getInstance() {
            if (singleton == null) {
                singleton = new LayersParser();
            }
            return singleton;
        }

        private LayersParser() {
            super(WMS.get());
        }

        public List<Object> parseLayers(List<String> requestedLayerNames, URL remoteOwsUrl, String remoteOwsType) {
            try {
                return super.parseLayers(requestedLayerNames, remoteOwsUrl, remoteOwsType);
            }
            catch (Exception exception) {
                throw new ServiceException("Error parsing requested layers.", (Throwable)exception);
            }
        }
    }

    static enum PropertyAccessMode {
        READ,
        WRITE;

    }
}

