/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.geoserver.geofence.cache.CacheConfiguration;
import org.geoserver.geofence.cache.RuleCacheLoaderFactory;
import org.geoserver.geofence.config.GeoFenceConfigurationManager;
import org.geoserver.geofence.containers.ContainerAccessCacheLoaderFactory;
import org.geoserver.geofence.containers.ContainerLimitResolver;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.AuthUser;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geotools.util.logging.Logging;

public class CacheManager {
    static final Logger LOGGER = Logging.getLogger(CacheManager.class);
    private RuleCacheLoaderFactory ruleServiceLoaderFactory;
    private ContainerAccessCacheLoaderFactory containerAccessCacheLoaderFactory;
    private LoadingCache<RuleFilter, AccessInfo> ruleCache;
    private LoadingCache<RuleCacheLoaderFactory.NamePw, AuthUser> userCache;
    private LoadingCache<RuleFilter, AccessInfo> authCache;
    private LoadingCache<ContainerAccessCacheLoaderFactory.ResolveParams, ContainerLimitResolver.ProcessingResult> contCache;
    private final GeoFenceConfigurationManager configurationManager;
    private CacheConfiguration cacheConfiguration = new CacheConfiguration();
    private AtomicLong dumpCnt = new AtomicLong(0L);

    public CacheManager(GeoFenceConfigurationManager configurationManager, RuleCacheLoaderFactory cachedRuleLoaders, ContainerAccessCacheLoaderFactory containerAccessCacheLoaderFactory) {
        this(configurationManager);
        this.setRuleServiceLoaderFactory(this.ruleServiceLoaderFactory);
        this.setContainerAccessCacheLoaderFactory(containerAccessCacheLoaderFactory);
        this.init();
    }

    public CacheManager(GeoFenceConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public final void setRuleServiceLoaderFactory(RuleCacheLoaderFactory ruleServiceLoaderFactory) {
        this.ruleServiceLoaderFactory = ruleServiceLoaderFactory;
    }

    public final void setContainerAccessCacheLoaderFactory(ContainerAccessCacheLoaderFactory containerAccessCacheLoaderFactory) {
        this.containerAccessCacheLoaderFactory = containerAccessCacheLoaderFactory;
    }

    @PostConstruct
    public final void init() {
        this.cacheConfiguration = this.configurationManager.getCacheConfiguration();
        this.ruleCache = this.getCacheBuilder().build((CacheLoader)this.ruleServiceLoaderFactory.createRuleLoader());
        this.userCache = this.getCacheBuilder().build((CacheLoader)this.ruleServiceLoaderFactory.createUserLoader());
        this.authCache = this.getCacheBuilder().build((CacheLoader)this.ruleServiceLoaderFactory.createAuthLoader());
        this.contCache = this.getCacheBuilder().build((CacheLoader)this.containerAccessCacheLoaderFactory.createProcessingResultLoader());
    }

    protected CacheBuilder<Object, Object> getCacheBuilder() {
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize(this.cacheConfiguration.getSize()).refreshAfterWrite(this.cacheConfiguration.getRefreshMilliSec(), TimeUnit.MILLISECONDS).expireAfterWrite(this.cacheConfiguration.getExpireMilliSec(), TimeUnit.MILLISECONDS).recordStats();
        if (this.cacheConfiguration.getCustomTicker() != null) {
            LOGGER.log(Level.SEVERE, "Setting a custom Ticker in the cache {0}", this.cacheConfiguration.getCustomTicker().getClass().getName());
            builder.ticker(this.cacheConfiguration.getCustomTicker());
        }
        return builder;
    }

    public void invalidateAll() {
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Forcing cache invalidation");
        }
        this.ruleCache.invalidateAll();
        this.userCache.invalidateAll();
        this.authCache.invalidateAll();
        this.contCache.invalidateAll();
    }

    public void logStats() {
        if (LOGGER.isLoggable(Level.INFO) && this.dumpCnt.incrementAndGet() % 10L == 0L) {
            LOGGER.info("Rules  :" + this.ruleCache.stats());
            LOGGER.info("Users  :" + this.userCache.stats());
            LOGGER.info("Auth   :" + this.authCache.stats());
            LOGGER.info("Cont   :" + this.contCache.stats());
            LOGGER.fine("params :" + this.cacheConfiguration);
        }
    }

    public CacheConfiguration getCacheInitParams() {
        return this.cacheConfiguration;
    }

    public LoadingCache<RuleFilter, AccessInfo> getRuleCache() {
        if (this.ruleCache == null) {
            throw new IllegalStateException("CacheManager is not properly inizialized");
        }
        this.logStats();
        return this.ruleCache;
    }

    public LoadingCache<RuleCacheLoaderFactory.NamePw, AuthUser> getUserCache() {
        if (this.userCache == null) {
            throw new IllegalStateException("CacheManager is not properly inizialized");
        }
        this.logStats();
        return this.userCache;
    }

    public LoadingCache<RuleFilter, AccessInfo> getAuthCache() {
        if (this.authCache == null) {
            throw new IllegalStateException("CacheManager is not properly inizialized");
        }
        this.logStats();
        return this.authCache;
    }

    public LoadingCache<ContainerAccessCacheLoaderFactory.ResolveParams, ContainerLimitResolver.ProcessingResult> getContainerCache() {
        this.logStats();
        return this.contCache;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[Rule:" + this.ruleCache.stats() + " User:" + this.userCache.stats() + " Auth:" + this.authCache.stats() + " Cont:" + this.contCache.stats() + " " + this.cacheConfiguration + "]";
    }
}

