/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.util.Arrays;
import net.sf.ezmorph.test.ArrayAssertions;
import org.geoserver.geofence.RuleFilterBuilder;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.ows.Request;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class RuleFilterBuilderTest {
    @Test
    public void testFilterByUser() {
        RuleFilterBuilder ruleFilterBuilder = new RuleFilterBuilder(this.getGeofenceConfiguration());
        ruleFilterBuilder.withUser(this.getAuthentication());
        ruleFilterBuilder.withRequest(this.getRequest());
        ruleFilterBuilder.withLayer("states");
        ruleFilterBuilder.withWorkspace("topp");
        RuleFilter filter = ruleFilterBuilder.build();
        ArrayAssertions.assertEquals((Object)filter.getRole().getType(), (Object)RuleFilter.SpecialFilterType.ANY.getRelatedType());
        ArrayAssertions.assertEquals((String)filter.getUser().getText(), (String)this.getAuthentication().getName());
        ArrayAssertions.assertEquals((String)filter.getService().getText(), (String)"WMS");
        ArrayAssertions.assertEquals((String)filter.getRequest().getText(), (String)"GETMAP");
        ArrayAssertions.assertEquals((String)filter.getLayer().getText(), (String)"states");
        ArrayAssertions.assertEquals((String)filter.getWorkspace().getText(), (String)"topp");
    }

    @Test
    public void testFilterByRole() {
        GeoFenceConfiguration configuration = this.getGeofenceConfiguration();
        configuration.setUseRolesToFilter(true);
        configuration.setAcceptedRoles("ROLE_ONE");
        RuleFilterBuilder ruleFilterBuilder = new RuleFilterBuilder(configuration);
        ruleFilterBuilder.withUser(this.getAuthentication());
        ruleFilterBuilder.withRequest(this.getRequest());
        ruleFilterBuilder.withLayer("states");
        ruleFilterBuilder.withWorkspace("topp");
        RuleFilter filter = ruleFilterBuilder.build();
        ArrayAssertions.assertEquals((String)filter.getRole().getText(), (String)"ROLE_ONE");
        ArrayAssertions.assertEquals((String)filter.getUser().getText(), (String)this.getAuthentication().getName());
        ArrayAssertions.assertEquals((String)filter.getService().getText(), (String)"WMS");
        ArrayAssertions.assertEquals((String)filter.getRequest().getText(), (String)"GETMAP");
        ArrayAssertions.assertEquals((String)filter.getLayer().getText(), (String)"states");
        ArrayAssertions.assertEquals((String)filter.getWorkspace().getText(), (String)"topp");
    }

    @Test
    public void testDefaults() {
        RuleFilterBuilder ruleFilterBuilder = new RuleFilterBuilder(this.getGeofenceConfiguration());
        ruleFilterBuilder.withUser(this.getAuthentication());
        ruleFilterBuilder.withRequest(this.getRequest());
        RuleFilter filter = ruleFilterBuilder.build();
        ArrayAssertions.assertEquals((Object)filter.getRole().getType(), (Object)RuleFilter.SpecialFilterType.ANY.getRelatedType());
        ArrayAssertions.assertEquals((String)filter.getUser().getText(), (String)this.getAuthentication().getName());
        ArrayAssertions.assertEquals((String)filter.getService().getText(), (String)"WMS");
        ArrayAssertions.assertEquals((String)filter.getRequest().getText(), (String)"GETMAP");
        Assert.assertNull((Object)filter.getLayer().getText());
        Assert.assertNull((Object)filter.getWorkspace().getText());
        ArrayAssertions.assertEquals((Object)filter.getLayer().getType(), (Object)RuleFilter.FilterType.NAMEVALUE);
        ArrayAssertions.assertEquals((Object)filter.getWorkspace().getType(), (Object)RuleFilter.FilterType.NAMEVALUE);
    }

    private Request getRequest() {
        Request request = new Request();
        request.setService("WMS");
        request.setRequest("GETMAP");
        return request;
    }

    private GeoFenceConfiguration getGeofenceConfiguration() {
        GeoFenceConfiguration configuration = new GeoFenceConfiguration();
        configuration.setDefaultUserGroupServiceName("deafault");
        configuration.setInstanceName("geoserver");
        return configuration;
    }

    private Authentication getAuthentication() {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)"username", (Object)"password", Arrays.asList(new SimpleGrantedAuthority("ROLE_ONE"), new SimpleGrantedAuthority("ROLE_TWO")));
        return authentication;
    }
}

