/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class RuleFilterBuilder {
    private Request owsRequest;
    private String ipAddress;
    private String date;
    private String workspace;
    private String layer;
    private Authentication user;
    private GeoFenceConfiguration config;
    private static final Logger LOGGER = Logging.getLogger(RuleFilterBuilder.class);

    public RuleFilterBuilder(GeoFenceConfiguration configuration) {
        this.config = configuration;
    }

    public RuleFilterBuilder withRequest(Request request) {
        this.owsRequest = request;
        return this;
    }

    public RuleFilterBuilder withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public RuleFilterBuilder withDate(String date) {
        this.date = date;
        return this;
    }

    public RuleFilterBuilder withWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public RuleFilterBuilder withLayer(String layer) {
        this.layer = layer;
        return this;
    }

    public RuleFilterBuilder withUser(Authentication authentication) {
        this.user = authentication;
        return this;
    }

    public RuleFilter build() {
        RuleFilter ruleFilter = new RuleFilter(RuleFilter.SpecialFilterType.ANY);
        this.setRuleFilterUserAndRole(ruleFilter);
        ruleFilter.setInstance(this.config.getInstanceName());
        String service = null;
        String request = null;
        if (this.owsRequest != null) {
            service = this.owsRequest.getService();
            request = this.owsRequest.getRequest();
        }
        if (service != null) {
            if ("*".equals(service)) {
                ruleFilter.setService(RuleFilter.SpecialFilterType.ANY);
            } else {
                ruleFilter.setService(service);
            }
        } else {
            ruleFilter.setService(RuleFilter.SpecialFilterType.DEFAULT);
        }
        if (request != null) {
            if ("*".equals(request)) {
                ruleFilter.setRequest(RuleFilter.SpecialFilterType.ANY);
            } else {
                ruleFilter.setRequest(request);
            }
        } else {
            ruleFilter.setRequest(RuleFilter.SpecialFilterType.DEFAULT);
        }
        ruleFilter.setWorkspace(this.workspace);
        ruleFilter.setLayer(this.layer);
        String sourceAddress = this.ipAddress;
        if (sourceAddress != null) {
            ruleFilter.setSourceAddress(sourceAddress);
        } else {
            LOGGER.log(Level.WARNING, "No source IP address found");
            ruleFilter.setSourceAddress(RuleFilter.SpecialFilterType.DEFAULT);
        }
        if (this.date != null) {
            ruleFilter.setDate(this.date);
        } else {
            LOGGER.log(Level.WARNING, "No date found");
            ruleFilter.setDate(RuleFilter.SpecialFilterType.DEFAULT);
        }
        LOGGER.log(Level.FINE, "ResourceInfo filter: {0}", ruleFilter);
        return ruleFilter;
    }

    private void setRuleFilterUserAndRole(RuleFilter ruleFilter) {
        if (this.user != null) {
            this.setByRole(ruleFilter);
            String username = this.user.getName();
            if (StringUtils.isEmpty((String)username)) {
                LOGGER.log(Level.WARNING, "Username is null for user: {0}", new Object[]{this.user});
                ruleFilter.setUser(RuleFilter.SpecialFilterType.DEFAULT);
            } else {
                LOGGER.log(Level.FINE, "Setting user for filter: {0}", new Object[]{username});
                ruleFilter.setUser(username);
            }
        } else {
            LOGGER.log(Level.WARNING, "No user given");
            ruleFilter.setUser(RuleFilter.SpecialFilterType.DEFAULT);
        }
    }

    private void setByRole(RuleFilter ruleFilter) {
        if (this.config.isUseRolesToFilter()) {
            if (this.config.getRoles().isEmpty()) {
                LOGGER.log(Level.WARNING, "Role filtering requested, but no roles provided. Will only use user authorizations");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                String authList = this.user.getAuthorities().stream().map(a -> a.getAuthority()).collect(Collectors.joining(",", "[", "]"));
                LOGGER.log(Level.FINE, "Authorizations found for user {0}: {1}", new Object[]{this.user.getName(), authList});
                String allowedAuth = this.config.getRoles().stream().collect(Collectors.joining(",", "[", "]"));
                LOGGER.log(Level.FINE, "Authorizations allowed: {0}", new Object[]{allowedAuth});
            }
        }
        if (this.config.isUseRolesToFilter() && !this.config.getRoles().isEmpty()) {
            List<String> roles = this.getFilteredRoles();
            if (roles.isEmpty()) {
                roles.add("UNKNOWN");
            }
            String joinedRoles = String.join((CharSequence)",", roles);
            LOGGER.log(Level.FINE, "Setting role for filter: {0}", new Object[]{joinedRoles});
            ruleFilter.setRole(joinedRoles);
        }
    }

    public List<String> getFilteredRoles() {
        boolean getAllRoles = this.config.getRoles().contains("*");
        Set<String> excluded = this.config.getRoles().stream().filter(r -> r.startsWith("-")).map(r -> r.substring(1)).collect(Collectors.toSet());
        return this.getFilteredRoles(getAllRoles, excluded);
    }

    private List<String> getFilteredRoles(boolean getAllRoles, Set<String> excluded) {
        ArrayList<String> roles = new ArrayList<String>();
        if (this.user != null) {
            for (GrantedAuthority authority : this.user.getAuthorities()) {
                String authRole = authority.getAuthority();
                if (!this.addRole(authRole, excluded, getAllRoles)) continue;
                roles.add(authRole);
            }
        }
        return roles;
    }

    private boolean addRole(String role, Set<String> excluded, boolean getAllRoles) {
        boolean addRole = getAllRoles || this.config.getRoles().contains(role);
        return addRole && !excluded.contains(role);
    }
}

