/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.cache;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.geofence.cache.CacheManager;
import org.geoserver.geofence.cache.RuleCacheLoaderFactory;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.AuthUser;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.services.dto.ShortRule;
import org.geotools.util.logging.Logging;

public class CachedRuleReader
implements RuleReaderService {
    static final Logger LOGGER = Logging.getLogger(CachedRuleReader.class);
    private CacheManager cacheManager;

    public CachedRuleReader() {
    }

    public CachedRuleReader(CacheManager cacheManager) {
        this.setCacheManager(cacheManager);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public AccessInfo getAccessInfo(RuleFilter filter) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Request for {0}", filter);
        }
        AccessInfo accessInfo = null;
        try {
            accessInfo = (AccessInfo)this.cacheManager.getRuleCache().get((Object)filter);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        return accessInfo;
    }

    public AccessInfo getAdminAuthorization(RuleFilter filter) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "AdminAuth Request for {0}", filter);
        }
        try {
            return (AccessInfo)this.cacheManager.getAuthCache().get((Object)filter);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<ShortRule> getMatchingRules(RuleFilter filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AuthUser authorize(String username, String password) {
        try {
            return (AuthUser)this.cacheManager.getUserCache().get((Object)new RuleCacheLoaderFactory.NamePw(username, password));
        }
        catch (ExecutionException ex) {
            LOGGER.warning(ex.getMessage());
            return null;
        }
    }
}

