/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.cache;

import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.AuthUser;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geotools.util.logging.Logging;

public class RuleCacheLoaderFactory {
    static final Logger LOGGER = Logging.getLogger(RuleCacheLoaderFactory.class);
    private RuleReaderService realRuleReaderService;

    public RuleCacheLoaderFactory(RuleReaderService realRuleReaderService) {
        this.realRuleReaderService = realRuleReaderService;
    }

    public RuleLoader createRuleLoader() {
        return new RuleLoader();
    }

    public AuthLoader createAuthLoader() {
        return new AuthLoader();
    }

    public UserLoader createUserLoader() {
        return new UserLoader();
    }

    static class NoAuthException
    extends Exception {
        public NoAuthException() {
        }

        public NoAuthException(String message) {
            super(message);
        }

        public NoAuthException(String message, Throwable cause) {
            super(message, cause);
        }

        public NoAuthException(Throwable cause) {
            super(cause);
        }
    }

    public static class NamePw {
        private String name;
        private String pw;

        public NamePw() {
        }

        public NamePw(String name, String pw) {
            this.name = name;
            this.pw = pw;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPw() {
            return this.pw;
        }

        public void setPw(String pw) {
            this.pw = pw;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 89 * hash + (this.pw != null ? this.pw.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamePw other = (NamePw)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.pw == null ? other.pw != null : !this.pw.equals(other.pw));
        }
    }

    class UserLoader
    extends CacheLoader<NamePw, AuthUser> {
        private UserLoader() {
        }

        public AuthUser load(NamePw user) throws NoAuthException {
            AuthUser auth;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Loading user '" + user.getName() + "'");
            }
            if ((auth = RuleCacheLoaderFactory.this.realRuleReaderService.authorize(user.getName(), user.getPw())) == null) {
                throw new NoAuthException("Can't auth user [" + user.getName() + "]");
            }
            return auth;
        }

        public ListenableFuture<AuthUser> reload(NamePw user, AuthUser authUser) throws NoAuthException {
            AuthUser auth;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Reloading user '" + user.getName() + "'");
            }
            if ((auth = RuleCacheLoaderFactory.this.realRuleReaderService.authorize(user.getName(), user.getPw())) == null) {
                throw new NoAuthException("Can't auth user [" + user.getName() + "]");
            }
            return Futures.immediateFuture((Object)auth);
        }
    }

    class AuthLoader
    extends CacheLoader<RuleFilter, AccessInfo> {
        private AuthLoader() {
        }

        public AccessInfo load(RuleFilter filter) throws Exception {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Loading {0}", filter);
            }
            RuleFilter clone = filter.clone();
            return RuleCacheLoaderFactory.this.realRuleReaderService.getAdminAuthorization(clone);
        }

        public ListenableFuture<AccessInfo> reload(RuleFilter filter, AccessInfo accessInfo) throws Exception {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Reloading {0}", filter);
            }
            RuleFilter clone = filter.clone();
            AccessInfo ret = RuleCacheLoaderFactory.this.realRuleReaderService.getAdminAuthorization(clone);
            return Futures.immediateFuture((Object)ret);
        }
    }

    class RuleLoader
    extends CacheLoader<RuleFilter, AccessInfo> {
        private RuleLoader() {
        }

        public AccessInfo load(RuleFilter filter) throws Exception {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Loading {0}", filter);
            }
            RuleFilter clone = filter.clone();
            return RuleCacheLoaderFactory.this.realRuleReaderService.getAccessInfo(clone);
        }

        public ListenableFuture<AccessInfo> reload(RuleFilter filter, AccessInfo accessInfo) throws Exception {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Reloading {0}", filter);
            }
            RuleFilter clone = filter.clone();
            AccessInfo ret = RuleCacheLoaderFactory.this.realRuleReaderService.getAccessInfo(clone);
            return Futures.immediateFuture((Object)ret);
        }
    }
}

