/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.config;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GeoFenceConfiguration
implements Serializable,
Cloneable {
    public static final String URL_INTERNAL = "internal:/";
    private static final long serialVersionUID = 3L;
    private String servicesUrl;
    private String instanceName;
    private boolean allowRemoteAndInlineLayers;
    private boolean grantWriteToWorkspacesToAuthenticatedUsers;
    private boolean useRolesToFilter;
    private String acceptedRoles = "";
    private List<String> roles = new ArrayList<String>();
    private String gwcContextSuffix;
    private String defaultUserGroupServiceName;

    public String getServicesUrl() {
        return this.servicesUrl;
    }

    public void setServicesUrl(String servicesUrl) {
        this.servicesUrl = servicesUrl;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setAllowRemoteAndInlineLayers(boolean allowRemoteAndInlineLayers) {
        this.allowRemoteAndInlineLayers = allowRemoteAndInlineLayers;
    }

    public boolean isAllowRemoteAndInlineLayers() {
        return this.allowRemoteAndInlineLayers;
    }

    public boolean isGrantWriteToWorkspacesToAuthenticatedUsers() {
        return this.grantWriteToWorkspacesToAuthenticatedUsers;
    }

    public void setGrantWriteToWorkspacesToAuthenticatedUsers(boolean grantWriteToWorkspacesToAuthenticatedUsers) {
        this.grantWriteToWorkspacesToAuthenticatedUsers = grantWriteToWorkspacesToAuthenticatedUsers;
    }

    public boolean isUseRolesToFilter() {
        return this.useRolesToFilter;
    }

    public void setUseRolesToFilter(boolean useRolesToFilter) {
        this.useRolesToFilter = useRolesToFilter;
    }

    public String getAcceptedRoles() {
        return this.acceptedRoles;
    }

    public void setAcceptedRoles(String acceptedRoles) {
        if (acceptedRoles == null) {
            acceptedRoles = "";
        }
        this.acceptedRoles = acceptedRoles;
        this.roles = Lists.newArrayList((Object[])acceptedRoles.split(","));
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean isInternal() {
        return this.servicesUrl.startsWith(URL_INTERNAL);
    }

    public String getGwcContextSuffix() {
        return this.gwcContextSuffix;
    }

    public void setGwcContextSuffix(String gwcContextSuffix) {
        this.gwcContextSuffix = gwcContextSuffix;
    }

    public void setDefaultUserGroupServiceName(String defaultUserGroupServiceName) {
        this.defaultUserGroupServiceName = defaultUserGroupServiceName;
    }

    public String getDefaultUserGroupServiceName() {
        return this.defaultUserGroupServiceName;
    }

    public GeoFenceConfiguration clone() {
        try {
            GeoFenceConfiguration clone = (GeoFenceConfiguration)super.clone();
            clone.setAcceptedRoles(this.acceptedRoles);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new UnknownError("Unexpected exception: " + ex.getMessage());
        }
    }
}

