/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.containers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.geofence.RuleFilterBuilder;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.CatalogModeDTO;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.util.AccessInfoUtils;
import org.geoserver.geofence.util.GeomHelper;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.impl.LayerGroupContainmentCache;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class ContainerLimitResolver {
    private RuleReaderService ruleService;
    private List<LayerGroupInfo> groupList;
    private Collection<LayerGroupContainmentCache.LayerGroupSummary> groupSummaries;
    private Authentication authentication;
    private String layer;
    private String workspace;
    private String callerIp;
    private GeoFenceConfiguration configuration;
    private static final Logger LOGGER = Logging.getLogger(ContainerLimitResolver.class);

    ContainerLimitResolver(List<LayerGroupInfo> groups, RuleReaderService ruleService, Authentication authentication, String layer, String workspace, String callerIp, GeoFenceConfiguration configuration) {
        this(ruleService, authentication, layer, workspace, callerIp, configuration);
        this.groupList = groups;
    }

    ContainerLimitResolver(Collection<LayerGroupContainmentCache.LayerGroupSummary> groups, RuleReaderService ruleService, Authentication authentication, String layer, String workspace, String callerIp, GeoFenceConfiguration configuration) {
        this(ruleService, authentication, layer, workspace, callerIp, configuration);
        this.groupSummaries = groups;
    }

    private ContainerLimitResolver(RuleReaderService ruleService, Authentication authentication, String layer, String workspace, String callerIp, GeoFenceConfiguration configuration) {
        this.ruleService = ruleService;
        this.authentication = authentication;
        this.layer = layer;
        this.workspace = workspace;
        this.configuration = configuration;
        this.callerIp = callerIp;
    }

    ProcessingResult resolveResourceInGroupLimits() {
        HashMap<String, AccessInfo> publishedAccessByRole = new HashMap<String, AccessInfo>();
        Collection authorities = this.authentication.getAuthorities();
        for (GrantedAuthority authority : authorities) {
            AccessInfo accessInfo;
            RuleFilter filter = this.ruleFilterByRole(authority, this.workspace, this.layer, this.callerIp);
            if (filter == null || (accessInfo = this.ruleService.getAccessInfo(filter)) == null || this.isDeny(accessInfo)) continue;
            publishedAccessByRole.put(authority.getAuthority(), accessInfo);
        }
        ListMultimap<String, AccessInfo> groupsByRoleAccess = this.collectContainersAccessInfoByRole();
        ListMultimap<RestrictionType, ProcessingResult> restrictionResults = this.intersectAccesses(publishedAccessByRole, groupsByRoleAccess);
        return this.unionAccesses(restrictionResults);
    }

    private ProcessingResult unionAccesses(ListMultimap<RestrictionType, ProcessingResult> restrictionResults) {
        List bothGroup = restrictionResults.get((Object)RestrictionType.GROUP_BOTH);
        List intersectsGroup = restrictionResults.get((Object)RestrictionType.GROUP_INTERSECT);
        List clipGroup = restrictionResults.get((Object)RestrictionType.GROUP_CLIP);
        List bothLayer = restrictionResults.get((Object)RestrictionType.LAYER_BOTH);
        List intersectsLayer = restrictionResults.get((Object)RestrictionType.LAYER_INTERSECT);
        List clipLayer = restrictionResults.get((Object)RestrictionType.LAYER_CLIP);
        ProcessingResult intersectProcessG = this.enlargeGroupProcessingResult(intersectsGroup);
        ProcessingResult clipProcessG = this.enlargeGroupProcessingResult(clipGroup);
        ProcessingResult bothProcessG = this.enlargeGroupProcessingResult(bothGroup);
        ProcessingResult intersectProcessL = this.enlargeGroupProcessingResult(intersectsLayer);
        ProcessingResult clipProcessL = this.enlargeGroupProcessingResult(clipLayer);
        ProcessingResult bothProcessL = this.enlargeGroupProcessingResult(bothLayer);
        Geometry intersectArea = null;
        Geometry clipArea = null;
        CatalogModeDTO catalogModeDTO = null;
        if (intersectProcessG != null) {
            LOGGER.fine(() -> "Processing group areas with intersect type");
            intersectArea = intersectProcessG.getIntersectArea();
            clipArea = intersectProcessG.getClipArea();
            catalogModeDTO = AccessInfoUtils.getLarger(null, intersectProcessG.getCatalogModeDTO());
        }
        if (clipProcessG != null) {
            LOGGER.fine(() -> "Processing group areas with clip type");
            clipArea = this.unionOrReturnIfNull(() -> clipProcessG.getClipArea(), clipArea, false);
            intersectArea = this.unionOrReturnIfNull(() -> clipProcessG.getIntersectArea(), intersectArea, false);
            catalogModeDTO = AccessInfoUtils.getLarger(catalogModeDTO, clipProcessG.getCatalogModeDTO());
        }
        if (bothProcessG != null) {
            LOGGER.fine(() -> "Processing group areas with both intersects and clip types");
            boolean favourNull = this.groupSummaries != null;
            intersectArea = this.unionOrReturnIfNull(() -> bothProcessG.getIntersectArea(), intersectArea, favourNull);
            clipArea = this.unionOrReturnIfNull(() -> bothProcessG.getClipArea(), clipArea, favourNull);
            catalogModeDTO = AccessInfoUtils.getLarger(catalogModeDTO, bothProcessG.getCatalogModeDTO());
        }
        if (intersectProcessL != null) {
            LOGGER.fine(() -> "Processing layer intersect areas if present");
            intersectArea = this.unionOrReturnIfNull(() -> intersectProcessL.getIntersectArea(), intersectArea, false);
            catalogModeDTO = AccessInfoUtils.getLarger(catalogModeDTO, intersectProcessL.getCatalogModeDTO());
        }
        if (clipProcessL != null) {
            LOGGER.fine(() -> "Processing layer clip areas if present");
            clipArea = this.unionOrReturnIfNull(() -> clipProcessL.getClipArea(), clipArea, false);
            catalogModeDTO = AccessInfoUtils.getLarger(catalogModeDTO, clipProcessL.getCatalogModeDTO());
        }
        if (bothProcessL != null) {
            LOGGER.fine(() -> "Processing layer areas with both intersects and clip types");
            intersectArea = this.unionOrReturnIfNull(() -> bothProcessL.getIntersectArea(), intersectArea, false);
            clipArea = this.unionOrReturnIfNull(() -> bothProcessL.getClipArea(), clipArea, false);
            catalogModeDTO = AccessInfoUtils.getLarger(catalogModeDTO, bothProcessL.getCatalogModeDTO());
        }
        return new ProcessingResult(intersectArea, clipArea, catalogModeDTO);
    }

    private Geometry unionOrReturnIfNull(Supplier<Geometry> supplier, Geometry area, boolean favourNull) {
        area = area != null ? GeomHelper.reprojectAndUnion(supplier.get(), area, favourNull) : supplier.get();
        return area;
    }

    private ProcessingResult enlargeGroupProcessingResult(List<ProcessingResult> processingResult) {
        if (processingResult == null || processingResult.isEmpty()) {
            return null;
        }
        CatalogModeDTO catalogModeDTO = null;
        Geometry intersectArea = null;
        Geometry clipArea = null;
        boolean favourNull = this.groupSummaries != null;
        for (int i = 0; i < processingResult.size(); ++i) {
            ProcessingResult pr = processingResult.get(i);
            catalogModeDTO = AccessInfoUtils.getLarger(catalogModeDTO, pr.getCatalogModeDTO());
            Geometry allowedArea = pr.getIntersectArea();
            Geometry allowedAreaClip = pr.getClipArea();
            if (i == 0) {
                intersectArea = allowedArea;
                clipArea = allowedAreaClip;
                continue;
            }
            intersectArea = GeomHelper.reprojectAndUnion(intersectArea, allowedArea, favourNull);
            clipArea = GeomHelper.reprojectAndUnion(clipArea, allowedAreaClip, favourNull);
        }
        return new ProcessingResult(intersectArea, clipArea, catalogModeDTO);
    }

    private ListMultimap<RestrictionType, ProcessingResult> intersectAccesses(Map<String, AccessInfo> resourceAccessInfo, ListMultimap<String, AccessInfo> groupAccessInfoByRole) {
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        for (String key : resourceAccessInfo.keySet()) {
            List infos = groupAccessInfoByRole.get((Object)key);
            this.intersectAccesses(resourceAccessInfo.get(key), infos, (ListMultimap<RestrictionType, ProcessingResult>)multiMap);
        }
        return multiMap;
    }

    private void intersectAccesses(AccessInfo resAccessInfo, List<AccessInfo> groupsAccessInfo, ListMultimap<RestrictionType, ProcessingResult> multiMap) {
        Geometry resIntersectArea = GeomHelper.parseWKT(resAccessInfo.getAreaWkt());
        Geometry resClipArea = GeomHelper.parseWKT(resAccessInfo.getClipAreaWkt());
        CatalogModeDTO catalogMode = resAccessInfo.getCatalogMode();
        boolean groupOnIntersect = false;
        boolean groupOnClip = false;
        boolean lessRestrictive = this.groupSummaries != null;
        Geometry groupsIntersectArea = null;
        Geometry groupClipArea = null;
        if (groupsAccessInfo != null && !groupsAccessInfo.isEmpty()) {
            for (int i = 0; i < groupsAccessInfo.size(); ++i) {
                AccessInfo accessInfo = groupsAccessInfo.get(i);
                catalogMode = AccessInfoUtils.getStricter(catalogMode, accessInfo.getCatalogMode());
                String allowedArea = accessInfo.getAreaWkt();
                String clipAllowedArea = accessInfo.getClipAreaWkt();
                if (!groupOnIntersect) {
                    boolean bl = groupOnIntersect = allowedArea != null;
                }
                if (!groupOnClip) {
                    groupOnClip = clipAllowedArea != null;
                }
                Geometry area = GeomHelper.parseWKT(allowedArea);
                Geometry clipArea = GeomHelper.parseWKT(clipAllowedArea);
                if (i == 0) {
                    groupsIntersectArea = area;
                    groupClipArea = clipArea;
                    continue;
                }
                groupsIntersectArea = GeomHelper.reprojectAndIntersect(groupsIntersectArea, area, lessRestrictive);
                groupClipArea = GeomHelper.reprojectAndIntersect(groupClipArea, clipArea, lessRestrictive);
            }
        }
        resIntersectArea = GeomHelper.reprojectAndIntersect(resIntersectArea, groupsIntersectArea, false);
        resClipArea = GeomHelper.reprojectAndIntersect(resClipArea, groupClipArea, false);
        ProcessingResult result = new ProcessingResult(resIntersectArea, resClipArea, catalogMode);
        if (groupOnClip && groupOnIntersect) {
            multiMap.put((Object)RestrictionType.GROUP_BOTH, (Object)result);
        } else if (groupOnClip) {
            multiMap.put((Object)RestrictionType.GROUP_CLIP, (Object)result);
        } else if (groupOnIntersect) {
            multiMap.put((Object)RestrictionType.GROUP_INTERSECT, (Object)result);
        } else if (resIntersectArea != null && resClipArea != null) {
            multiMap.put((Object)RestrictionType.LAYER_BOTH, (Object)result);
        } else if (resIntersectArea != null) {
            multiMap.put((Object)RestrictionType.LAYER_INTERSECT, (Object)result);
        } else if (resClipArea != null) {
            multiMap.put((Object)RestrictionType.LAYER_CLIP, (Object)result);
        }
    }

    private ListMultimap<String, AccessInfo> collectContainersAccessInfoByRole() {
        ArrayListMultimap groupAccessInfoByRole = ArrayListMultimap.create();
        if (this.groupSummaries == null) {
            this.collectGroupAccessInfoByRole(this.groupList, this.authentication, (ListMultimap<String, AccessInfo>)groupAccessInfoByRole);
        } else {
            this.collectGroupSummaryAccessInfoByRole(this.groupSummaries, this.authentication.getAuthorities(), (ListMultimap<String, AccessInfo>)groupAccessInfoByRole);
        }
        return groupAccessInfoByRole;
    }

    private void collectGroupSummaryAccessInfoByRole(Collection<LayerGroupContainmentCache.LayerGroupSummary> summaries, Collection<? extends GrantedAuthority> authorities, ListMultimap<String, AccessInfo> groupAccessInfoByRole) {
        for (LayerGroupContainmentCache.LayerGroupSummary summary : summaries) {
            LayerGroupInfo.Mode mode = summary.getMode();
            if (mode.equals((Object)LayerGroupInfo.Mode.OPAQUE_CONTAINER)) continue;
            String layer = summary.getName();
            String workspace = summary.getWorkspace();
            HashMap<String, AccessInfo> map = new HashMap<String, AccessInfo>(authorities.size());
            for (GrantedAuthority grantedAuthority : authorities) {
                AccessInfo accessInfo;
                RuleFilter filter = this.ruleFilterByRole(grantedAuthority, workspace, layer, this.callerIp);
                if (filter == null || this.isDeny(accessInfo = this.ruleService.getAccessInfo(filter))) continue;
                map.put(grantedAuthority.getAuthority(), accessInfo);
            }
            map.keySet().forEach(k -> groupAccessInfoByRole.put(k, (Object)((AccessInfo)map.get(k))));
        }
    }

    private void collectGroupAccessInfoByRole(List<LayerGroupInfo> groupList, Authentication user, ListMultimap<String, AccessInfo> groupAccessInfoByRole) {
        for (LayerGroupInfo group : groupList) {
            String[] nameParts = group.prefixedName().split(":");
            String layer = null;
            String workspace = null;
            if (nameParts.length == 1) {
                layer = nameParts[0];
            } else {
                workspace = nameParts[0];
                layer = nameParts[1];
            }
            if (this.isUserAllowed(layer, workspace)) continue;
            this.addAccessInfoByRole(groupAccessInfoByRole, user.getAuthorities(), layer, workspace);
        }
    }

    private boolean isUserAllowed(String layer, String workspace) {
        if (!this.configuration.isUseRolesToFilter() || this.configuration.getRoles().isEmpty()) {
            RuleFilterBuilder builder = new RuleFilterBuilder(this.configuration);
            RuleFilter filter = builder.withUser(this.authentication).withIpAddress(this.callerIp).withWorkspace(workspace).withLayer(layer).withRequest((Request)Dispatcher.REQUEST.get()).build();
            AccessInfo accessInfo = this.ruleService.getAccessInfo(filter);
            LOGGER.log(Level.FINE, () -> "User allowed for the entire layer group. No limit processing is needed.");
            return this.isAllow(accessInfo) && accessInfo.getAreaWkt() == null && accessInfo.getClipAreaWkt() == null;
        }
        return false;
    }

    private void addAccessInfoByRole(ListMultimap<String, AccessInfo> multimap, Collection<? extends GrantedAuthority> authorities, String layer, String workspace) {
        for (GrantedAuthority grantedAuthority : authorities) {
            RuleFilter filter = this.ruleFilterByRole(grantedAuthority, workspace, layer, this.callerIp);
            if (filter == null) continue;
            AccessInfo accessInfo = this.ruleService.getAccessInfo(filter);
            multimap.put((Object)grantedAuthority.getAuthority(), (Object)accessInfo);
        }
    }

    private boolean isAllow(AccessInfo accessInfo) {
        return accessInfo != null && accessInfo.getGrant().equals((Object)GrantType.ALLOW);
    }

    private boolean isDeny(AccessInfo accessInfo) {
        return accessInfo != null && accessInfo.getGrant().equals((Object)GrantType.DENY);
    }

    private RuleFilter ruleFilterByRole(GrantedAuthority grantedAuthority, String workspace, String layer, String ipAddress) {
        RuleFilterBuilder builder = new RuleFilterBuilder(this.configuration);
        Request request = (Request)Dispatcher.REQUEST.get();
        builder = builder.withLayer(layer).withWorkspace(workspace).withIpAddress(ipAddress).withRequest(request);
        RuleFilter filter = builder.build();
        if (this.filterIsInValid(builder, grantedAuthority.getAuthority())) {
            LOGGER.log(Level.FINE, () -> "Skipping layegroup limits resolution for role " + grantedAuthority.getAuthority() + " because not among allowed ones");
            return null;
        }
        filter.setUser(this.authentication.getName());
        filter.setRole(grantedAuthority.getAuthority());
        return filter;
    }

    private boolean filterIsInValid(RuleFilterBuilder builder, String authority) {
        builder.withUser(this.authentication);
        return this.configuration.isUseRolesToFilter() && !this.configuration.getRoles().isEmpty() && !builder.getFilteredRoles().contains(authority);
    }

    public static class ProcessingResult {
        private Geometry intersectArea;
        private Geometry clipArea;
        private CatalogModeDTO catalogModeDTO;

        public ProcessingResult(Geometry intersectArea, Geometry clipArea, CatalogModeDTO catalogModeDTO) {
            this.intersectArea = intersectArea;
            this.clipArea = clipArea;
            this.catalogModeDTO = catalogModeDTO;
        }

        public Geometry getIntersectArea() {
            return this.intersectArea;
        }

        public Geometry getClipArea() {
            return this.clipArea;
        }

        public CatalogModeDTO getCatalogModeDTO() {
            return this.catalogModeDTO;
        }

        void setIntersectArea(Geometry intersectArea) {
            this.intersectArea = intersectArea;
        }

        void setClipArea(Geometry clipArea) {
            this.clipArea = clipArea;
        }
    }

    private static enum RestrictionType {
        GROUP_INTERSECT,
        GROUP_CLIP,
        GROUP_BOTH,
        LAYER_INTERSECT,
        LAYER_CLIP,
        LAYER_BOTH;

    }
}

