/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.web;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.geofence.cache.CacheConfiguration;
import org.geoserver.geofence.cache.CacheManager;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.config.GeoFenceConfigurationController;
import org.geoserver.geofence.config.GeoFenceConfigurationManager;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.model.ExtPropertyModel;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

public class GeofencePage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 5845823599005718408L;
    private GeoFenceConfiguration config;
    private CacheConfiguration cacheParams;
    private final Map<String, Object> statsValues = new HashMap<String, Object>();
    private final Set<Label> statsLabels = new HashSet<Label>();
    private static final String KEY_RULE_SIZE = "rule.size";
    private static final String KEY_RULE_HIT = "rule.hit";
    private static final String KEY_RULE_MISS = "rule.miss";
    private static final String KEY_RULE_LOADOK = "rule.loadok";
    private static final String KEY_RULE_LOADKO = "rule.loadko";
    private static final String KEY_RULE_LOADTIME = "rule.loadtime";
    private static final String KEY_RULE_EVICTION = "rule.evict";
    private static final String KEY_ADMIN_SIZE = "admin.size";
    private static final String KEY_ADMIN_HIT = "admin.hit";
    private static final String KEY_ADMIN_MISS = "admin.miss";
    private static final String KEY_ADMIN_LOADOK = "admin.loadok";
    private static final String KEY_ADMIN_LOADKO = "admin.loadko";
    private static final String KEY_ADMIN_LOADTIME = "admin.loadtime";
    private static final String KEY_ADMIN_EVICTION = "admin.evict";
    private static final String KEY_USER_SIZE = "user.size";
    private static final String KEY_USER_HIT = "user.hit";
    private static final String KEY_USER_MISS = "user.miss";
    private static final String KEY_USER_LOADOK = "user.loadok";
    private static final String KEY_USER_LOADKO = "user.loadko";
    private static final String KEY_USER_LOADTIME = "user.loadtime";
    private static final String KEY_USER_EVICTION = "user.evict";
    private static final String KEY_CONT_SIZE = "cont.size";
    private static final String KEY_CONT_HIT = "cont.hit";
    private static final String KEY_CONT_MISS = "cont.miss";
    private static final String KEY_CONT_LOADOK = "cont.loadok";
    private static final String KEY_CONT_LOADKO = "cont.loadko";
    private static final String KEY_CONT_LOADTIME = "cont.loadtime";
    private static final String KEY_CONT_EVICTION = "cont.evict";

    public GeofencePage() {
        GeoFenceConfigurationManager configManager = (GeoFenceConfigurationManager)GeoServerExtensions.bean(GeoFenceConfigurationManager.class);
        this.config = configManager.getConfiguration().clone();
        this.cacheParams = configManager.getCacheConfiguration().clone();
        IModel<GeoFenceConfiguration> configModel = this.getGeoFenceConfigModel();
        IModel<CacheConfiguration> cacheModel = this.getCacheConfigModel();
        final Form form = new Form("form", (IModel)new CompoundPropertyModel(configModel));
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        form.add(new Component[]{new TextField("instanceName", (IModel)new PropertyModel(configModel, "instanceName")).setRequired(true)});
        form.add(new Component[]{new TextField("servicesUrl", (IModel)new ExtPropertyModel(configModel, "servicesUrl").setReadOnly(this.config.isInternal())).setRequired(true).setEnabled(!this.config.isInternal())});
        form.add(new Component[]{new AjaxSubmitLink("test"){
            private static final long serialVersionUID = -91239899377941223L;

            protected void onSubmit(AjaxRequestTarget target) {
                ((FormComponent)form.get("servicesUrl")).processInput();
                String servicesUrl = (String)((FormComponent)form.get("servicesUrl")).getConvertedInput();
                RuleReaderService ruleReader = this.getRuleReaderService(servicesUrl);
                try {
                    ruleReader.getMatchingRules(new RuleFilter());
                    this.info((Serializable)new StringResourceModel(GeofencePage.class.getSimpleName() + ".connectionSuccessful").getObject());
                }
                catch (Exception e) {
                    this.error(e);
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                if (this.getPage() instanceof GeoServerBasePage) {
                    ((GeoServerBasePage)this.getPage()).addFeedbackPanels(target);
                }
            }

            private RuleReaderService getRuleReaderService(String servicesUrl) {
                if (GeofencePage.this.config.isInternal()) {
                    return (RuleReaderService)GeoServerExtensions.bean((String)"ruleReaderService");
                }
                HttpInvokerProxyFactoryBean invoker = new HttpInvokerProxyFactoryBean();
                invoker.setServiceUrl(servicesUrl);
                invoker.setServiceInterface(RuleReaderService.class);
                invoker.afterPropertiesSet();
                return (RuleReaderService)invoker.getObject();
            }
        }.setDefaultFormProcessing(false)});
        form.add(new Component[]{new CheckBox("allowRemoteAndInlineLayers", (IModel)new PropertyModel(configModel, "allowRemoteAndInlineLayers"))});
        form.add(new Component[]{new CheckBox("grantWriteToWorkspacesToAuthenticatedUsers", (IModel)new PropertyModel(configModel, "grantWriteToWorkspacesToAuthenticatedUsers"))});
        form.add(new Component[]{new CheckBox("useRolesToFilter", (IModel)new PropertyModel(configModel, "useRolesToFilter"))});
        form.add(new Component[]{new TextField("acceptedRoles", (IModel)new PropertyModel(configModel, "acceptedRoles"))});
        Button submit = new Button("submit"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                try {
                    ((GeoFenceConfigurationController)GeoServerExtensions.bean(GeoFenceConfigurationController.class)).storeConfiguration(GeofencePage.this.config, GeofencePage.this.cacheParams);
                    GeofencePage.this.doReturn();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Save error", e);
                    this.error(e);
                }
            }
        };
        form.add(new Component[]{submit});
        Button cancel = new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                GeofencePage.this.doReturn();
            }
        }.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        form.add(new Component[]{new TextField("cacheSize", (IModel)new PropertyModel(cacheModel, "size")).setRequired(true)});
        form.add(new Component[]{new TextField("cacheRefresh", (IModel)new PropertyModel(cacheModel, "refreshMilliSec")).setRequired(true)});
        form.add(new Component[]{new TextField("cacheExpire", (IModel)new PropertyModel(cacheModel, "expireMilliSec")).setRequired(true)});
        CacheManager cacheManager = (CacheManager)GeoServerExtensions.bean(CacheManager.class);
        this.updateStatsValues(cacheManager);
        for (String key : this.statsValues.keySet()) {
            Label label = new Label(key, (IModel)new MapModel(this.statsValues, key));
            label.setOutputMarkupId(true);
            form.add(new Component[]{label});
            this.statsLabels.add(label);
        }
        form.add(new Component[]{new AjaxSubmitLink("invalidate"){
            private static final long serialVersionUID = 3847903240475052867L;

            protected void onSubmit(AjaxRequestTarget target) {
                CacheManager cacheManager = (CacheManager)GeoServerExtensions.bean(CacheManager.class);
                cacheManager.invalidateAll();
                this.info((Serializable)new StringResourceModel(GeofencePage.class.getSimpleName() + ".cacheInvalidated").getObject());
                GeofencePage.this.updateStatsValues(cacheManager);
                for (Label label : GeofencePage.this.statsLabels) {
                    target.add(new Component[]{label});
                }
                if (this.getPage() instanceof GeoServerBasePage) {
                    ((GeoServerBasePage)this.getPage()).addFeedbackPanels(target);
                }
            }
        }.setDefaultFormProcessing(false)});
    }

    private void updateStatsValues(CacheManager cacheManager) {
        Object cache = cacheManager.getRuleCache();
        this.statsValues.put(KEY_RULE_SIZE, "" + cache.size());
        this.statsValues.put(KEY_RULE_HIT, "" + cache.stats().hitCount());
        this.statsValues.put(KEY_RULE_MISS, "" + cache.stats().missCount());
        this.statsValues.put(KEY_RULE_LOADOK, "" + cache.stats().loadSuccessCount());
        this.statsValues.put(KEY_RULE_LOADKO, "" + cache.stats().loadExceptionCount());
        this.statsValues.put(KEY_RULE_LOADTIME, "" + cache.stats().totalLoadTime());
        this.statsValues.put(KEY_RULE_EVICTION, "" + cache.stats().evictionCount());
        cache = cacheManager.getAuthCache();
        this.statsValues.put(KEY_ADMIN_SIZE, "" + cache.size());
        this.statsValues.put(KEY_ADMIN_HIT, "" + cache.stats().hitCount());
        this.statsValues.put(KEY_ADMIN_MISS, "" + cache.stats().missCount());
        this.statsValues.put(KEY_ADMIN_LOADOK, "" + cache.stats().loadSuccessCount());
        this.statsValues.put(KEY_ADMIN_LOADKO, "" + cache.stats().loadExceptionCount());
        this.statsValues.put(KEY_ADMIN_LOADTIME, "" + cache.stats().totalLoadTime());
        this.statsValues.put(KEY_ADMIN_EVICTION, "" + cache.stats().evictionCount());
        cache = cacheManager.getUserCache();
        this.statsValues.put(KEY_USER_SIZE, "" + cache.size());
        this.statsValues.put(KEY_USER_HIT, "" + cache.stats().hitCount());
        this.statsValues.put(KEY_USER_MISS, "" + cache.stats().missCount());
        this.statsValues.put(KEY_USER_LOADOK, "" + cache.stats().loadSuccessCount());
        this.statsValues.put(KEY_USER_LOADKO, "" + cache.stats().loadExceptionCount());
        this.statsValues.put(KEY_USER_LOADTIME, "" + cache.stats().totalLoadTime());
        this.statsValues.put(KEY_USER_EVICTION, "" + cache.stats().evictionCount());
        cache = cacheManager.getContainerCache();
        this.statsValues.put(KEY_CONT_SIZE, "" + cache.size());
        this.statsValues.put(KEY_CONT_HIT, "" + cache.stats().hitCount());
        this.statsValues.put(KEY_CONT_MISS, "" + cache.stats().missCount());
        this.statsValues.put(KEY_CONT_LOADOK, "" + cache.stats().loadSuccessCount());
        this.statsValues.put(KEY_CONT_LOADKO, "" + cache.stats().loadExceptionCount());
        this.statsValues.put(KEY_CONT_LOADTIME, "" + cache.stats().totalLoadTime());
        this.statsValues.put(KEY_CONT_EVICTION, "" + cache.stats().evictionCount());
    }

    private IModel<GeoFenceConfiguration> getGeoFenceConfigModel() {
        return new Model((Serializable)this.config);
    }

    private IModel<CacheConfiguration> getCacheConfigModel() {
        return new Model((Serializable)this.cacheParams);
    }
}

