/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.wpscommon;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.geofence.core.model.enums.GrantType;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.services.dto.AccessInfo;
import org.geoserver.geofence.services.dto.RuleFilter;
import org.geoserver.geofence.util.AccessInfoUtils;
import org.geoserver.geofence.wpscommon.ChainStatusHolder;
import org.geoserver.geofence.wpscommon.ExecutionIdRetriever;
import org.geoserver.ows.Request;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WPSHelper
implements ApplicationContextAware {
    private static final Logger LOGGER = Logging.getLogger(WPSHelper.class);
    private RuleReaderService ruleService;
    ChainStatusHolder statusHolder = null;
    ExecutionIdRetriever executionIdRetriever = null;
    private boolean helperAvailable = false;

    public WPSHelper(RuleReaderService ruleService) {
        this.ruleService = ruleService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            this.statusHolder = (ChainStatusHolder)applicationContext.getBean(ChainStatusHolder.class);
            this.executionIdRetriever = (ExecutionIdRetriever)applicationContext.getBean(ExecutionIdRetriever.class);
            this.helperAvailable = true;
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.severe("GeoFence-WPS integration classes not available. Please include geofence-wps module.");
        }
    }

    public AccessInfoUtils.WPSAccessInfo resolveWPSAccess(Request req, RuleFilter filter, AccessInfo wpsAccessInfo) {
        if (!this.helperAvailable) {
            LOGGER.warning("WPSHelper not available");
            return null;
        }
        String execId = this.executionIdRetriever.getCurrentExecutionId();
        List<String> procNames = this.statusHolder.getCurrentStack(execId);
        LinkedList<AccessInfo> procAccessInfo = new LinkedList<AccessInfo>();
        for (String procName : procNames) {
            LOGGER.fine("Retrieving AccessInfo for proc " + procName);
            RuleFilter r = filter.clone();
            r.setSubfield(procName);
            AccessInfo accessInfo = this.ruleService.getAccessInfo(r);
            if (accessInfo.getGrant() == GrantType.DENY) {
                LOGGER.fine("Process " + procName + " not allowed to operate on layer");
                return new AccessInfoUtils.WPSAccessInfo(AccessInfo.DENY_ALL, null, null);
            }
            if (!accessInfo.equals(wpsAccessInfo)) {
                procAccessInfo.add(accessInfo);
                continue;
            }
            LOGGER.fine("Skipping accessInfo for " + procName);
        }
        if (procAccessInfo.isEmpty()) {
            return null;
        }
        return AccessInfoUtils.intersect(procAccessInfo.toArray(new AccessInfo[0]));
    }
}

