/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.config.GeoFenceConfigurationManager;
import org.geoserver.geofence.config.GeoFencePropertyPlaceholderConfigurer;
import org.geoserver.geofence.utils.GeofenceTestUtils;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.core.io.UrlResource;

public class GeoFenceConfigurationManagerTest
extends GeoServerTestSupport {
    GeoFencePropertyPlaceholderConfigurer configurer;
    GeoFenceConfigurationManager manager;

    protected void oneTimeSetUp() throws Exception {
        try {
            super.oneTimeSetUp();
        }
        catch (Exception e) {
            LOGGER.severe("Error in OneTimeSetup: it may be due to GeoFence not running, please check the logs -- " + e.getMessage());
            LOGGER.log(Level.FINE, "Error in OneTimeSetup: it may be due to GeoFence not running, please check the logs", e);
        }
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("wcs", "http://www.opengis.net/wcs/1.1.1");
        namespaces.put("gml", "http://www.opengis.net/gml");
        this.getTestData().registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.manager = (GeoFenceConfigurationManager)applicationContext.getBean("geofenceConfigurationManager");
        this.configurer = (GeoFencePropertyPlaceholderConfigurer)applicationContext.getBean("geofence-configurer");
        this.configurer.setLocation((org.springframework.core.io.Resource)new UrlResource(((Object)((Object)this)).getClass().getResource("/test-config.properties")));
    }

    @Test
    public void testSave() throws IOException, URISyntaxException {
        GeofenceTestUtils.emptyFile("test-config.properties");
        GeoFenceConfiguration config = new GeoFenceConfiguration();
        config.setInstanceName("TEST_INSTANCE");
        config.setServicesUrl("http://fakeservice");
        config.setAllowRemoteAndInlineLayers(true);
        config.setGrantWriteToWorkspacesToAuthenticatedUsers(true);
        config.setUseRolesToFilter(true);
        config.setAcceptedRoles("A,B");
        this.manager.setConfiguration(config);
        Resource configurationFile = this.configurer.getConfigFile();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(configurationFile.out()));){
            writer.write("newUserProperty=custom_property_value\n");
        }
        this.manager.storeConfiguration();
        File configFile = this.configurer.getConfigFile().file();
        LOGGER.info("Config file is " + configFile);
        String content = GeofenceTestUtils.readConfig(configFile);
        Assert.assertTrue((boolean)content.contains("fakeservice"));
        Assert.assertTrue((boolean)content.contains("TEST_INSTANCE"));
        Assert.assertFalse((boolean)content.contains("custom_property_value"));
    }
}

