/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.CoverageStoreInfoImpl;
import org.geoserver.catalog.impl.DataStoreInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.geofence.GeofenceAccessManager;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.Authentication;

public class GeofenceAccessManagerTest
extends GeofenceBaseTest {
    @Test
    public void testAdmin() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Authentication user = this.getUser("admin", "geoserver", "ROLE_ADMINISTRATOR");
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        WorkspaceInfo citeWS = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        WorkspaceAccessLimits wl = accessManager.getAccessLimits(user, citeWS);
        Assert.assertTrue((boolean)wl.isReadable());
        Assert.assertTrue((boolean)wl.isWritable());
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS));
        VectorAccessLimits vl = (VectorAccessLimits)accessManager.getAccessLimits(user, layer);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getReadFilter());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getWriteFilter());
        Assert.assertNull((Object)vl.getReadAttributes());
        Assert.assertNull((Object)vl.getWriteAttributes());
    }

    @Test
    public void testCiteCannotWriteOnWorkspace() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        configManager.getConfiguration().setGrantWriteToWorkspacesToAuthenticatedUsers(false);
        Authentication user = this.getUser("cite", "cite", "ROLE_AUTHENTICATED");
        WorkspaceInfo citeWS = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        WorkspaceAccessLimits wl = accessManager.getAccessLimits(user, citeWS);
        Assert.assertTrue((boolean)wl.isReadable());
        Assert.assertFalse((boolean)wl.isWritable());
    }

    @Test
    public void testCiteCanWriteOnWorkspace() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        configManager.getConfiguration().setGrantWriteToWorkspacesToAuthenticatedUsers(true);
        Authentication user = this.getUser("cite", "cite", "ROLE_AUTHENTICATED");
        WorkspaceInfo citeWS = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        WorkspaceAccessLimits wl = accessManager.getAccessLimits(user, citeWS);
        Assert.assertTrue((boolean)wl.isReadable());
        Assert.assertTrue((boolean)wl.isWritable());
        configManager.getConfiguration().setGrantWriteToWorkspacesToAuthenticatedUsers(false);
    }

    @Test
    public void testAnonymousUser() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        LayerInfo layer = catalog.getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS));
        VectorAccessLimits vl = (VectorAccessLimits)accessManager.getAccessLimits(null, layer);
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)vl.getReadFilter());
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)vl.getWriteFilter());
        Assert.assertNull((Object)vl.getReadAttributes());
        Assert.assertNull((Object)vl.getWriteAttributes());
    }

    @Test
    public void testCiteWorkspaceAccess() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Authentication user = this.getUser("cite", "cite", "ROLE_AUTHENTICATED");
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        WorkspaceInfo citeWS = catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        WorkspaceAccessLimits wl = accessManager.getAccessLimits(user, citeWS);
        Assert.assertTrue((boolean)wl.isReadable());
        Assert.assertFalse((boolean)wl.isWritable());
        WorkspaceInfo cdfWS = catalog.getWorkspaceByName(MockData.CDF_PREFIX);
        wl = accessManager.getAccessLimits(user, cdfWS);
        Assert.assertTrue((boolean)wl.isReadable());
        Assert.assertFalse((boolean)wl.isWritable());
        WorkspaceInfo sfWS = catalog.getWorkspaceByName(MockData.SF_PREFIX);
        wl = accessManager.getAccessLimits(user, sfWS);
        Assert.assertTrue((boolean)wl.isReadable());
        Assert.assertFalse((boolean)wl.isWritable());
    }

    @Test
    public void testCiteLayerAccess() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Authentication user = this.getUser("cite", "cite", "ROLE_AUTHENTICATED");
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
        LayerInfo bpolygons = catalog.getLayerByName(this.getLayerId(MockData.BASIC_POLYGONS));
        VectorAccessLimits vl = (VectorAccessLimits)accessManager.getAccessLimits(user, bpolygons);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getReadFilter());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getWriteFilter());
        Assert.assertNull((Object)vl.getReadAttributes());
        Assert.assertNull((Object)vl.getWriteAttributes());
        Request request = new Request();
        request.setService("WFS");
        request.setRequest("GetFeature");
        Dispatcher.REQUEST.set(request);
        LayerInfo generic = catalog.getLayerByName(this.getLayerId(MockData.GENERICENTITY));
        vl = (VectorAccessLimits)accessManager.getAccessLimits(user, generic);
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)vl.getReadFilter());
        Assert.assertEquals((Object)Filter.EXCLUDE, (Object)vl.getWriteFilter());
        request = new Request();
        request.setService("WmS");
        request.setRequest("gETmAP");
        Dispatcher.REQUEST.set(request);
        vl = (VectorAccessLimits)accessManager.getAccessLimits(user, generic);
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getReadFilter());
        Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getWriteFilter());
    }

    @Test
    public void testWmsLimited() {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Authentication user = this.getUser("wmsuser", "wmsuser", "ROLE_AUTHENTICATED");
        Request request = new Request();
        request.setService("WFS");
        request.setRequest("GetFeature");
        Dispatcher.REQUEST.set(request);
        LayerInfo generic = catalog.getLayerByName(this.getLayerId(MockData.GENERICENTITY));
        if (generic != null) {
            VectorAccessLimits vl = (VectorAccessLimits)accessManager.getAccessLimits(user, generic);
            Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getReadFilter());
            Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getWriteFilter());
            request = new Request();
            request.setService("wms");
            Dispatcher.REQUEST.set(request);
            vl = (VectorAccessLimits)accessManager.getAccessLimits(user, generic);
            Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getReadFilter());
            Assert.assertEquals((Object)Filter.INCLUDE, (Object)vl.getWriteFilter());
        }
    }

    @Test
    public void testAreaLimited() throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Authentication user = this.getUser("area", "area", "ROLE_AUTHENTICATED");
        this.login("area", "area", new String[]{"ROLE_AUTHENTICATED"});
        LayerInfo generic = catalog.getLayerByName(this.getLayerId(MockData.GENERICENTITY));
        VectorAccessLimits vl = (VectorAccessLimits)accessManager.getAccessLimits(user, generic);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Geometry limit = new WKTReader().read("MULTIPOLYGON(((48 62, 48 63, 49 63, 49 62, 48 62)))");
        Intersects filter = ff.intersects((Expression)ff.property(""), (Expression)ff.literal((Object)limit));
        Assert.assertEquals((Object)filter, (Object)vl.getReadFilter());
        Assert.assertEquals((Object)filter, (Object)vl.getWriteFilter());
    }

    @Test
    public void testArea900913Vector() throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Authentication user = this.getUser("area", "area", "ROLE_AUTHENTICATED");
        this.login("area", "area", new String[]{"ROLE_AUTHENTICATED"});
        LayerInfo generic = catalog.getLayerByName(this.getLayerId(MockData.GENERICENTITY));
        WorkspaceInfoImpl ws = new WorkspaceInfoImpl();
        ws.setName(generic.getResource().getStore().getWorkspace().getName());
        DataStoreInfoImpl store = new DataStoreInfoImpl(catalog);
        store.setWorkspace((WorkspaceInfo)ws);
        FeatureTypeInfoImpl resource = new FeatureTypeInfoImpl(catalog);
        resource.setNamespace(generic.getResource().getNamespace());
        resource.setSRS("EPSG:900913");
        resource.setName(generic.getResource().getName());
        resource.setStore((StoreInfo)store);
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setResource((ResourceInfo)resource);
        layerInfo.setName(generic.getName());
        VectorAccessLimits vl = (VectorAccessLimits)accessManager.getAccessLimits(user, (ResourceInfo)resource);
        Geometry expectedLimit = new WKTReader().read(" MULTIPOLYGON (((5343335.558077131 8859142.800565697, 5343335.558077131 9100250.907059547, 5454655.048870404 9100250.907059547, 5454655.048870404 8859142.800565697, 5343335.558077131 8859142.800565697)))");
        IntersectExtractor ier = new IntersectExtractor();
        vl.getReadFilter().accept((FilterVisitor)ier, null);
        Assert.assertTrue((boolean)expectedLimit.equalsExact(ier.geom, 1.0E-9));
        IntersectExtractor iew = new IntersectExtractor();
        vl.getWriteFilter().accept((FilterVisitor)iew, null);
        Assert.assertTrue((boolean)expectedLimit.equalsExact(iew.geom, 1.0E-9));
    }

    @Test
    public void testArea900913Raster() throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        Authentication user = this.getUser("area", "area", "ROLE_AUTHENTICATED");
        this.login("area", "area", new String[]{"ROLE_AUTHENTICATED"});
        LayerInfo generic = catalog.getLayerByName(this.getLayerId(MockData.GENERICENTITY));
        WorkspaceInfoImpl ws = new WorkspaceInfoImpl();
        ws.setName(generic.getResource().getStore().getWorkspace().getName());
        CoverageStoreInfoImpl store = new CoverageStoreInfoImpl(catalog);
        store.setWorkspace((WorkspaceInfo)ws);
        CoverageInfoImpl resource = new CoverageInfoImpl(catalog);
        resource.setNamespace(generic.getResource().getNamespace());
        resource.setSRS("EPSG:900913");
        resource.setName(generic.getResource().getName());
        resource.setStore((StoreInfo)store);
        LayerInfoImpl layerInfo = new LayerInfoImpl();
        layerInfo.setResource((ResourceInfo)resource);
        layerInfo.setName(generic.getName());
        CoverageAccessLimits accessLimits = (CoverageAccessLimits)accessManager.getAccessLimits(user, (ResourceInfo)resource);
        Geometry expectedLimit = new WKTReader().read("MULTIPOLYGON (((5343335.558077131 8859142.800565697, 5343335.558077131 9100250.907059547, 5454655.048870404 9100250.907059547, 5454655.048870404 8859142.800565697, 5343335.558077131 8859142.800565697)))");
        Assert.assertTrue((boolean)expectedLimit.equalsExact((Geometry)accessLimits.getRasterFilter(), 1.0E-9));
    }

    public void assertAddress(String input, String expectedAddress) {
        String addr = GeofenceAccessManager.parseAddress((String)input);
        Assert.assertEquals((String)"Parsed address does not match", (Object)expectedAddress, (Object)addr);
    }

    @Test
    public void testParseAddress() {
        this.assertAddress("127.0.0.1", "127.0.0.1");
        this.assertAddress("127.0.0.1:8000", "127.0.0.1");
        this.assertAddress("999.999.999.999:8000", "999.999.999.999");
        this.assertAddress("0:0:0:0:0:0:0:42", "0:0:0:0:0:0:0:42");
        this.assertAddress(":::::::42", ":::::::42");
        this.assertAddress("[:1::2::4a4a:F1F0:42]", ":1::2::4a4a:F1F0:42");
        this.assertAddress("[::::::F1F0:42]:1234", "::::::F1F0:42");
        this.assertAddress("whatever", "whatever");
        this.assertAddress("whatever:1000", "whatever");
    }

    @Test
    public void testIPv6AddressXFF() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("x-forwarded-for", (Object)"[0:0:0:0:0:0:0:1]:1234");
        String sourceAddress = accessManager.getSourceAddress((HttpServletRequest)request);
        Assert.assertEquals((Object)"0:0:0:0:0:0:0:1", (Object)sourceAddress);
    }

    @Test
    public void testIPv6AddressRemoteAddr() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("[0:0:0:0:0:0:0:1]:1234");
        String sourceAddress = accessManager.getSourceAddress((HttpServletRequest)request);
        Assert.assertEquals((Object)"0:0:0:0:0:0:0:1", (Object)sourceAddress);
    }

    static class IntersectExtractor
    extends DefaultFilterVisitor {
        Geometry geom;

        IntersectExtractor() {
        }

        public Object visit(Intersects filter, Object data) {
            this.geom = (Geometry)filter.getExpression2().evaluate(null);
            return data;
        }
    }
}

