/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence;

import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.MockData;
import org.geoserver.geofence.GeofenceBaseTest;
import org.geoserver.platform.GeoServerExtensions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class ServicesTest
extends GeofenceBaseTest {
    void loginAsCite() {
        this.login("cite", "cite", new String[]{"ROLE_CITE_ADMIN"});
    }

    void loginAsSf() {
        this.login("sf", "sf", new String[]{"ROLE_SF_ADMIN"});
    }

    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Test
    public void testAdmin() throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        this.username = "admin";
        this.password = "geoserver";
        Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.1.1&service=WMS");
        XMLAssert.assertXpathEvaluatesTo((String)"11", (String)"count(//Layer[starts-with(Name, 'cite:')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//Layer[starts-with(Name, 'sf:')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"8", (String)"count(//Layer[starts-with(Name, 'cdf:')])", (Document)dom);
    }

    @Test
    public void testCiteCapabilities() throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        this.username = "cite";
        this.password = "cite";
        Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.1.1&service=WMS");
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"11", (String)"count(//Layer[starts-with(Name, 'cite:')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3", (String)"count(//Layer[starts-with(Name, 'sf:')])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//Layer[starts-with(Name, 'cdf:')])", (Document)dom);
    }

    @Test
    public void testCiteLayers() throws Exception {
        Assume.assumeTrue((boolean)IS_GEOFENCE_AVAILABLE);
        this.loginAsCite();
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=wfs&version=1.0.0&request=getfeature&typeName=" + this.getLayerId(MockData.GENERICENTITY));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((String)("Bad content type found " + response.getContentType()), (boolean)response.getContentType().startsWith("text/xml"));
        String content = response.getContentAsString();
        LOGGER.info("Content: " + content);
        Assert.assertTrue((boolean)content.contains("Feature type sf:GenericEntity unknown"));
    }
}

